/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.installer;

import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.flow.internal.MessageDigestUtil;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.installer.DefaultFileDownloader;
import com.vaadin.flow.server.frontend.installer.DownloadException;
import com.vaadin.flow.server.frontend.installer.FileDownloader;
import com.vaadin.flow.server.frontend.installer.InstallationException;
import com.vaadin.flow.server.frontend.installer.Platform;
import com.vaadin.flow.server.frontend.installer.ProxyConfig;
import com.vaadin.frontendtools.installer.ArchiveExtractionException;
import com.vaadin.frontendtools.installer.ArchiveExtractor;
import com.vaadin.frontendtools.installer.DefaultArchiveExtractor;
import com.vaadin.frontendtools.installer.VerificationException;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeInstaller {
    public static final String INSTALL_PATH_PREFIX = "/node";
    public static final String SHA_SUMS_FILE = "SHASUMS256.txt";
    public static final String PROVIDED_VERSION = "provided";
    private static final int MAX_DOWNLOAD_ATTEMPS = 5;
    private static final int DOWNLOAD_ATTEMPT_DELAY = 5;
    public static final String ACCEPT_MISSING_SHA = "vaadin.node.download.acceptMissingSHA";
    public static final String DEFAULT_NODEJS_DOWNLOAD_ROOT = "https://nodejs.org/dist/";
    public static final String UNOFFICIAL_NODEJS_DOWNLOAD_ROOT = "https://unofficial-builds.nodejs.org/download/release/";
    private final Object lock = new Object();
    private String npmVersion = "provided";
    private String nodeVersion;
    private URI nodeDownloadRoot;
    private String userName;
    private String password;
    private final File installDirectory;
    private final Platform platform;
    private final ArchiveExtractor archiveExtractor;
    private final FileDownloader fileDownloader;

    public NodeInstaller(File installDirectory, List<ProxyConfig.Proxy> proxies) {
        this(installDirectory, Platform.guess(), proxies);
    }

    public NodeInstaller(File installDirectory, Platform platform, List<ProxyConfig.Proxy> proxies) {
        this(installDirectory, platform, (ArchiveExtractor)new DefaultArchiveExtractor(), new DefaultFileDownloader(new ProxyConfig(proxies)));
    }

    public NodeInstaller(File installDirectory, Platform platform, ArchiveExtractor archiveExtractor, FileDownloader fileDownloader) {
        this.installDirectory = installDirectory;
        this.platform = platform;
        this.archiveExtractor = archiveExtractor;
        this.fileDownloader = fileDownloader;
    }

    public NodeInstaller setNodeVersion(String nodeVersion) {
        this.nodeVersion = nodeVersion;
        return this;
    }

    public NodeInstaller setNodeDownloadRoot(URI nodeDownloadRoot) {
        this.nodeDownloadRoot = nodeDownloadRoot;
        return this;
    }

    public NodeInstaller setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public NodeInstaller setPassword(String password) {
        this.password = password;
        return this;
    }

    private boolean npmProvided() throws InstallationException {
        if (PROVIDED_VERSION.equals(this.npmVersion)) {
            if (Integer.parseInt(this.nodeVersion.replace("v", "").split("[.]")[0]) < 4) {
                throw new InstallationException("npm version is '" + this.npmVersion + "' but Node didn't include npm prior to v4.0.0");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() throws InstallationException {
        Object object = this.lock;
        synchronized (object) {
            if (this.nodeDownloadRoot == null) {
                this.nodeDownloadRoot = URI.create(this.platform.getNodeDownloadRoot());
            }
            NodeInstaller.getLogger().info("Installing node version {}", (Object)this.nodeVersion);
            if (!this.nodeVersion.startsWith("v")) {
                NodeInstaller.getLogger().warn("Node version does not start with naming convention 'v'. If download fails please add 'v' to the version string.");
            }
            InstallData data = new InstallData(this.nodeVersion, this.nodeDownloadRoot, this.platform);
            this.installNode(data);
        }
    }

    private void installNode(InstallData data) throws InstallationException {
        try {
            this.downloadFileIfMissing(data.getDownloadUrl(), data.getArchive(), this.userName, this.password);
            this.extractFile(data.getArchive(), data.getTmpDirectory());
        }
        catch (DownloadException e) {
            throw new InstallationException("Node.js download failed. This may be due to loss of internet connection.\nIf you are behind a proxy server you should configure your proxy settings.\nVerify connection and proxy settings or follow the https://nodejs.org/en/download/ guide to install Node.js globally.", e);
        }
        catch (ArchiveExtractionException e) {
            throw new InstallationException("Could not extract the Node archive", e);
        }
        try {
            if (this.platform.isWindows()) {
                this.installNodeWindows(data);
            } else {
                this.installNodeUnix(data);
            }
        }
        catch (IOException e) {
            throw new InstallationException("Could not install Node", e);
        }
        NodeInstaller.getLogger().info("Local node installation successful.");
    }

    private void installNodeUnix(InstallData data) throws InstallationException, IOException {
        File extractedNodeDir = new File(data.getTmpDirectory(), data.getNodeFilename());
        if (!extractedNodeDir.exists() || !extractedNodeDir.isDirectory()) {
            throw new FileNotFoundException("Could not find the extracted Node.js directory at " + String.valueOf(extractedNodeDir));
        }
        File nodeBinary = new File(extractedNodeDir, "bin" + File.separator + data.getNodeExecutable());
        if (!nodeBinary.exists()) {
            throw new FileNotFoundException("Could not find the downloaded Node.js binary in " + String.valueOf(nodeBinary));
        }
        File destinationDirectory = this.getNodeInstallDirectory();
        NodeInstaller.getLogger().info("Installing complete Node.js distribution from {} to {}", (Object)extractedNodeDir, (Object)destinationDirectory);
        FileIOUtils.copyDirectory(extractedNodeDir, destinationDirectory);
        File installedNodeBinary = new File(destinationDirectory, "bin" + File.separator + data.getNodeExecutable());
        if (!installedNodeBinary.setExecutable(true, false)) {
            throw new InstallationException("Could not install Node: Was not allowed to make " + String.valueOf(installedNodeBinary) + " executable.");
        }
        this.makeScriptExecutable(destinationDirectory, "bin/npm");
        this.makeScriptExecutable(destinationDirectory, "bin/npx");
        this.makeScriptExecutable(destinationDirectory, "bin/corepack");
        this.deleteTempDirectory(data.getTmpDirectory());
    }

    private void makeScriptExecutable(File baseDirectory, String scriptPath) {
        boolean success;
        File scriptFile = new File(baseDirectory, scriptPath);
        if (scriptFile.exists() && !(success = scriptFile.setExecutable(true, false))) {
            NodeInstaller.getLogger().debug("Failed to make '{}' executable.", (Object)scriptFile.toPath());
        }
    }

    private void installNodeWindows(InstallData data) throws InstallationException, IOException {
        File extractedNodeDir = new File(data.getTmpDirectory(), data.getNodeFilename());
        File nodeBinary = new File(extractedNodeDir, data.getNodeExecutable());
        if (!nodeBinary.exists()) {
            throw new FileNotFoundException("Could not find the downloaded Node.js binary in " + String.valueOf(nodeBinary));
        }
        File destinationDirectory = this.getNodeInstallDirectory();
        NodeInstaller.getLogger().info("Installing complete Node.js distribution from {} to {}", (Object)extractedNodeDir, (Object)destinationDirectory);
        FileIOUtils.copyDirectory(extractedNodeDir, destinationDirectory);
        this.deleteTempDirectory(data.getTmpDirectory());
    }

    public String getInstallDirectory() {
        return this.getInstallDirectoryFile().getPath();
    }

    private File getInstallDirectoryFile() {
        return new File(this.installDirectory, this.getVersionedInstallPath());
    }

    private String getVersionedInstallPath() {
        if (this.nodeVersion == null || PROVIDED_VERSION.equals(this.nodeVersion)) {
            return INSTALL_PATH_PREFIX;
        }
        return "/node-" + this.nodeVersion;
    }

    private File getNodeInstallDirectory() {
        File nodeInstallDirectory = this.getInstallDirectoryFile();
        if (!nodeInstallDirectory.exists()) {
            NodeInstaller.getLogger().debug("Creating install directory {}", (Object)nodeInstallDirectory);
            boolean success = nodeInstallDirectory.mkdirs();
            if (!success) {
                NodeInstaller.getLogger().debug("Failed to create install directory");
            }
        }
        return nodeInstallDirectory;
    }

    private void deleteTempDirectory(File tmpDirectory) throws IOException {
        if (tmpDirectory != null && tmpDirectory.exists()) {
            NodeInstaller.getLogger().debug("Deleting temporary directory {}", (Object)tmpDirectory);
            FileIOUtils.delete(tmpDirectory);
        }
    }

    private void extractFile(File archive, File destinationDirectory) throws ArchiveExtractionException {
        long size;
        try {
            size = Files.size(archive.toPath());
        }
        catch (IOException e) {
            throw new ArchiveExtractionException("Error determining archive size", (Throwable)e);
        }
        try {
            NodeInstaller.getLogger().info("Unpacking {} ({} bytes) into {}", new Object[]{archive, size, destinationDirectory});
            this.archiveExtractor.extract(archive, destinationDirectory);
        }
        catch (ArchiveExtractionException e) {
            if (e.getCause() instanceof EOFException) {
                NodeInstaller.getLogger().error("The archive file {} is corrupted and will be deleted. Please run the application again.", (Object)archive.getPath());
                NodeInstaller.removeArchiveFile(archive);
                try {
                    FileIOUtils.delete(destinationDirectory);
                }
                catch (IOException ioe) {
                    NodeInstaller.getLogger().error("Failed to remove target directory '{}'", (Object)destinationDirectory, (Object)ioe);
                }
            } else {
                NodeInstaller.removeArchiveFile(archive);
            }
            throw e;
        }
    }

    private static void removeArchiveFile(File archive) {
        if (!archive.delete()) {
            NodeInstaller.getLogger().error("Failed to remove archive file {}. Please remove it manually and run the application.", (Object)archive.getPath());
        }
    }

    private void downloadFileIfMissing(URI downloadUrl, File destination, String userName, String password) throws DownloadException {
        if (!destination.exists()) {
            NodeInstaller.getLogger().info("Downloading {} to {}", (Object)downloadUrl, (Object)destination);
            for (int i = 0; i < 5; ++i) {
                try {
                    this.fileDownloader.download(downloadUrl, destination, userName, password, null);
                    this.verifyArchive(destination);
                    return;
                }
                catch (DownloadException e) {
                    if (i == 4) {
                        NodeInstaller.removeArchiveFile(destination);
                        throw e;
                    }
                    NodeInstaller.getLogger().debug("Error during downloading " + String.valueOf(downloadUrl), (Throwable)e);
                    NodeInstaller.getLogger().warn("Download failed, retrying in 5s...");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                catch (VerificationException ve) {
                    NodeInstaller.getLogger().warn("SHA256 verification of downloaded node archive failed.");
                    if (i != 4) continue;
                    NodeInstaller.removeArchiveFile(destination);
                    throw new DownloadException("Failed to download node matching SHA256.");
                }
            }
        } else {
            try {
                this.verifyArchive(destination);
            }
            catch (VerificationException de) {
                NodeInstaller.removeArchiveFile(destination);
                this.downloadFileIfMissing(downloadUrl, destination, userName, password);
            }
        }
    }

    private void verifyArchive(File archive) throws DownloadException, VerificationException {
        try {
            URI shaSumsURL = this.nodeDownloadRoot.resolve(this.nodeVersion + "/SHASUMS256.txt");
            if ("file".equalsIgnoreCase(shaSumsURL.getScheme())) {
                return;
            }
            File shaSums = new File(this.installDirectory, "node-SHASUMS256.txt");
            NodeInstaller.getLogger().debug("Downloading {} to {}", (Object)shaSumsURL, (Object)shaSums);
            try {
                this.fileDownloader.download(shaSumsURL, shaSums, this.userName, this.password, null);
            }
            catch (DownloadException e) {
                if (Boolean.getBoolean(ACCEPT_MISSING_SHA)) {
                    NodeInstaller.getLogger().warn("Could not verify SHA256 sum of downloaded node in {}. Accepting missing checksum verification as set in '{}' system property.", (Object)archive, (Object)ACCEPT_MISSING_SHA);
                    return;
                }
                NodeInstaller.getLogger().info("Download of {} failed. If failure persists, use system property '{}' to skip verification or download node manually.", (Object)SHA_SUMS_FILE, (Object)ACCEPT_MISSING_SHA);
                throw e;
            }
            String archiveSHA256 = MessageDigestUtil.sha256Hex(Files.readAllBytes(archive.toPath()));
            List<String> sha256sums = Files.readAllLines(shaSums.toPath());
            String archiveTargetSHA256 = sha256sums.stream().filter(sum -> sum.endsWith(archive.getName())).map(sum -> sum.substring(0, sum.length() - archive.getName().length()).trim()).findFirst().orElse("-1");
            shaSums.delete();
            if (!archiveSHA256.equals(archiveTargetSHA256)) {
                NodeInstaller.getLogger().error("Expected SHA256 [{}] for downloaded node archive, got [{}]", (Object)archiveTargetSHA256, (Object)archiveSHA256);
                throw new VerificationException("SHA256 sums did not match for downloaded node");
            }
        }
        catch (IOException e) {
            throw new VerificationException("Failed to validate archive hash.", (Throwable)e);
        }
    }

    private static FrontendVersion getVersion(String tool, List<String> versionCommand) throws InstallationException {
        try {
            String version;
            Process process = FrontendUtils.createProcessBuilder(versionCommand).start();
            CompletableFuture<Pair<String, String>> streamConsumer = FrontendUtils.consumeProcessStreams(process);
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new IOException("Process exited with non 0 exit code. (" + exitCode + ")");
            }
            try {
                version = streamConsumer.get(1L, TimeUnit.SECONDS).getFirst();
            }
            catch (ExecutionException | TimeoutException e) {
                NodeInstaller.getLogger().debug("Cannot read {} version", (Object)tool, (Object)e);
                version = "";
            }
            return FrontendUtils.parseFrontendVersion(version);
        }
        catch (IOException | InterruptedException e) {
            throw new InstallationException(String.format("Unable to detect version of %s. %s", tool, "Using command " + String.join((CharSequence)" ", versionCommand)), e);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)"NodeInstaller");
    }

    private class InstallData {
        String nodeFilename;
        URI downloadUrl;
        File tmpDirectory;
        File archive;
        String nodeExecutable;

        InstallData(String nodeVersion, URI nodeDownloadRoot, Platform platform) {
            this.nodeFilename = this.getLongNodeFilename(nodeVersion);
            this.downloadUrl = nodeDownloadRoot.resolve(this.getNodeDownloadFilename(nodeVersion));
            this.tmpDirectory = this.getTempDirectory();
            this.archive = this.resolveArchive("node", nodeVersion, platform.getNodeClassifier(new FrontendVersion(nodeVersion)), platform.getArchiveExtension());
            this.nodeExecutable = platform.isWindows() ? "node.exe" : "node";
        }

        public String getNodeFilename() {
            return this.nodeFilename;
        }

        public URI getDownloadUrl() {
            return this.downloadUrl;
        }

        public File getTmpDirectory() {
            return this.tmpDirectory;
        }

        public File getArchive() {
            return this.archive;
        }

        public String getNodeExecutable() {
            return this.nodeExecutable;
        }

        private File getTempDirectory() {
            File temporaryDirectory = new File(NodeInstaller.this.getNodeInstallDirectory(), "tmp");
            if (!temporaryDirectory.exists()) {
                NodeInstaller.getLogger().debug("Creating temporary directory {}", (Object)temporaryDirectory);
                boolean success = temporaryDirectory.mkdirs();
                if (!success) {
                    NodeInstaller.getLogger().debug("Failed to create temporary directory");
                }
            }
            return temporaryDirectory;
        }

        private String getNodeDownloadFilename(String nodeVersion) {
            return nodeVersion + "/" + this.getLongNodeFilename(nodeVersion) + "." + NodeInstaller.this.platform.getOs().getArchiveExtension();
        }

        private String getLongNodeFilename(String nodeVersion) {
            return "node-" + nodeVersion + "-" + NodeInstaller.this.platform.getNodeClassifier(new FrontendVersion(nodeVersion));
        }

        private File resolveArchive(String name, String nodeVersion, String classifier, String archiveExtension) {
            if (!NodeInstaller.this.installDirectory.exists()) {
                NodeInstaller.this.installDirectory.mkdirs();
            }
            StringBuilder filename = new StringBuilder().append(name).append("-").append(nodeVersion);
            if (classifier != null) {
                filename.append("-").append(classifier);
            }
            filename.append(".").append(archiveExtension);
            return new File(NodeInstaller.this.installDirectory, filename.toString());
        }
    }
}

