/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendPluginsUtil;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class TaskInstallFrontendBuildPlugins
implements FallibleCommand {
    private final File targetFolder;

    public TaskInstallFrontendBuildPlugins(Options options) {
        this.targetFolder = new File(options.getBuildDirectory(), "plugins");
    }

    @Override
    public void execute() {
        FrontendPluginsUtil.getPlugins().forEach(plugin -> {
            try {
                this.generatePluginFiles((String)plugin);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("Installation of Flow frontend plugin '" + plugin + "' failed", ioe);
            }
        });
    }

    private void generatePluginFiles(String pluginName) throws IOException {
        String packageFile;
        ObjectNode targetJson;
        File pluginTargetFolder = new File(this.targetFolder, pluginName);
        String pluginFolderName = "plugins/" + pluginName + "/";
        JsonNode packageJson = FrontendPluginsUtil.getJsonFile(pluginFolderName + "package.json");
        if (packageJson == null) {
            this.log().error("Couldn't locate '{}' for plugin '{}'. Plugin will not be installed.", (Object)"package.json", (Object)pluginName);
            return;
        }
        if (pluginTargetFolder.exists() && new File(pluginTargetFolder, "package.json").exists() && (targetJson = JacksonUtils.readTree(packageFile = Files.readString(new File(pluginTargetFolder, "package.json").toPath(), StandardCharsets.UTF_8))).has("update") && !targetJson.get("update").booleanValue()) {
            return;
        }
        Files.createDirectories(pluginTargetFolder.toPath(), new FileAttribute[0]);
        JsonNode files = packageJson.get("files");
        for (int i = 0; i < files.size(); ++i) {
            String file = files.get(i).textValue();
            this.copyIfNeeded(new File(pluginTargetFolder, file), pluginFolderName + file);
        }
        this.copyIfNeeded(new File(pluginTargetFolder, "package.json"), pluginFolderName + "package.json");
    }

    private void copyIfNeeded(File targetFile, String sourceResource) throws IOException {
        String content = StringUtil.toUTF8String(FrontendPluginsUtil.getResourceAsStream(sourceResource));
        FileIOUtils.writeIfChanged(targetFile, content);
    }

    private Logger log() {
        return LoggerFactory.getLogger(TaskInstallFrontendBuildPlugins.class);
    }
}

