/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.regex.Pattern;

public class TaskGenerateTsDefinitions
extends AbstractTaskClientGenerator {
    private static final String DECLARE_CSS_MODULE = "declare module '*.css?inline' {";
    private static final String DECLARE_CSSTYPE_MODULE = "declare module 'csstype' {";
    static final String UPDATE_MESSAGE = "\n***************************************************************************\n*  The TypeScript type declaration file 'types.d.ts' has been updated     *\n*  to the latest version by Vaadin. Previous content has been backed up   *\n*  as a '.bak' file. Please verify that the updated 'types.d.ts' file    *\n*  contains configuration needed for your project, and then delete the    *\n*  backup file.                                                           *\n***************************************************************************\n\n";
    static final String CHECK_CONTENT_MESSAGE = "\n****************************************************************************\n*  The TypeScript type declaration file 'types.d.ts' has been customized.  *\n*  Make sure the exact following configuration is present in that file:    *\n*                                                                          *\n%s\n*                                                                          *\n*  As an alternative you can rename the file, make Vaadin re-generate it,  *\n*  and then update it with your custom contents.                           *\n****************************************************************************\"\n\n";
    protected static boolean warningEmitted = false;
    static final String TS_DEFINITIONS = "types.d.ts";
    static final Pattern COMMENT_LINE = Pattern.compile("(?m)^/[/*].*\\R");
    private final Options options;

    TaskGenerateTsDefinitions(Options options) {
        this.options = options;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        if (this.shouldGenerate()) {
            super.execute();
        } else {
            this.updateIfContentMissing();
        }
    }

    @Override
    protected String getFileContent() throws IOException {
        return this.getTemplateContent("");
    }

    @Override
    protected File getGeneratedFile() {
        return new File(this.options.getNpmFolder(), TS_DEFINITIONS);
    }

    @Override
    protected boolean shouldGenerate() {
        File tsDefinitionsFile = this.getGeneratedFile();
        return !tsDefinitionsFile.exists() && new File(this.options.getNpmFolder(), "tsconfig.json").exists();
    }

    private void updateIfContentMissing() throws ExecutionFailedException {
        File tsDefinitions = this.getGeneratedFile();
        if (tsDefinitions.exists()) {
            String cssModuleContent;
            String content;
            String defaultContent;
            try {
                defaultContent = this.getFileContent();
            }
            catch (IOException ex) {
                throw new ExecutionFailedException("Cannot read default types.d.ts contents", ex);
            }
            try {
                content = Files.readString(tsDefinitions.toPath());
            }
            catch (IOException ex) {
                throw new ExecutionFailedException("Cannot read types.d.ts contents", ex);
            }
            try {
                cssModuleContent = TaskGenerateTsDefinitions.removeComments(this.getTemplateContent(".v2"));
            }
            catch (IOException ex) {
                throw new ExecutionFailedException("Cannot read types.d.ts.v2 contents", ex);
            }
            String uncommentedDefaultContent = TaskGenerateTsDefinitions.removeComments(defaultContent);
            String cssTypeModuleContent = uncommentedDefaultContent.replace(cssModuleContent, "");
            boolean containsExactCssModule = FileIOUtils.compareIgnoringIndentationEOLAndWhiteSpace(content, cssModuleContent, String::equals) || FileIOUtils.compareIgnoringIndentationEOLAndWhiteSpace(content, cssModuleContent, String::contains);
            boolean containsExactCssTypeModule = FileIOUtils.compareIgnoringIndentationEOLAndWhiteSpace(content, cssTypeModuleContent, String::equals) || FileIOUtils.compareIgnoringIndentationEOLAndWhiteSpace(content, cssTypeModuleContent, String::contains);
            boolean containsCssType = content.contains(DECLARE_CSSTYPE_MODULE);
            boolean containsCssModule = content.contains(DECLARE_CSS_MODULE);
            if (FileIOUtils.compareIgnoringIndentationEOLAndWhiteSpace(content, defaultContent, String::equals) || FileIOUtils.compareIgnoringIndentationEOLAndWhiteSpace(content, uncommentedDefaultContent, String::contains)) {
                TaskGenerateTsDefinitions.log().debug("{} is up-to-date", (Object)TS_DEFINITIONS);
            } else if (containsExactCssModule && containsExactCssTypeModule) {
                TaskGenerateTsDefinitions.log().debug("{} is up-to-date", (Object)TS_DEFINITIONS);
            } else {
                if (containsCssModule && !containsExactCssModule) {
                    TaskGenerateTsDefinitions.log().debug("Custom {} not updated because it contains '*.css?inline' module declaration", (Object)TS_DEFINITIONS);
                    throw new ExecutionFailedException(String.format(CHECK_CONTENT_MESSAGE, uncommentedDefaultContent));
                }
                if (containsCssType && !containsExactCssTypeModule) {
                    TaskGenerateTsDefinitions.log().debug("Custom {} not updated because it contains 'csstype' module declaration", (Object)TS_DEFINITIONS);
                    throw new ExecutionFailedException(String.format(CHECK_CONTENT_MESSAGE, uncommentedDefaultContent));
                }
                if (containsExactCssModule) {
                    TaskGenerateTsDefinitions.log().debug("Updating custom {} to add 'csstype' module declaration", (Object)TS_DEFINITIONS);
                } else {
                    TaskGenerateTsDefinitions.log().debug("Updating custom {} to add '*.css?inline' and 'csstype' module declarations", (Object)TS_DEFINITIONS);
                }
                UpdateMode updateMode = this.computeUpdateMode(content);
                if (updateMode == UpdateMode.UPDATE_AND_BACKUP) {
                    try {
                        File backupFile = File.createTempFile(tsDefinitions.getName() + ".", ".bak", tsDefinitions.getParentFile());
                        this.writeIfChanged(backupFile, content);
                        TaskGenerateTsDefinitions.log().debug("Created {} backup copy on {}", (Object)TS_DEFINITIONS, (Object)backupFile);
                    }
                    catch (IOException ex) {
                        throw new ExecutionFailedException("Cannot create backup copy of types.d.ts file", ex);
                    }
                }
                try {
                    if (updateMode == UpdateMode.REPLACE) {
                        Files.writeString(tsDefinitions.toPath(), (CharSequence)defaultContent, StandardOpenOption.TRUNCATE_EXISTING);
                    } else {
                        if (containsExactCssModule) {
                            uncommentedDefaultContent = uncommentedDefaultContent.replace(cssModuleContent, "");
                        }
                        if (containsExactCssTypeModule) {
                            uncommentedDefaultContent = uncommentedDefaultContent.replace(cssTypeModuleContent, "");
                        }
                        Files.writeString(tsDefinitions.toPath(), (CharSequence)uncommentedDefaultContent, StandardOpenOption.APPEND);
                        if (updateMode == UpdateMode.UPDATE_AND_BACKUP && !warningEmitted) {
                            TaskGenerateTsDefinitions.log().warn(UPDATE_MESSAGE);
                            warningEmitted = true;
                        }
                    }
                    this.track(tsDefinitions);
                }
                catch (IOException ex) {
                    throw new ExecutionFailedException("Error updating custom types.d.ts file", ex);
                }
            }
        }
    }

    private UpdateMode computeUpdateMode(String content) throws ExecutionFailedException {
        String templateContent;
        try {
            templateContent = this.getTemplateContent(".v1");
            if (FileIOUtils.compareIgnoringIndentationEOLAndWhiteSpace(content, templateContent, String::equals)) {
                return UpdateMode.REPLACE;
            }
            templateContent = this.getTemplateContent(".v2");
            if (FileIOUtils.compareIgnoringIndentationEOLAndWhiteSpace(content, templateContent, String::equals)) {
                return UpdateMode.REPLACE;
            }
        }
        catch (IOException ex) {
            throw new ExecutionFailedException("Cannot read default types.d.ts.v1 contents", ex);
        }
        try {
            templateContent = this.getTemplateContent(".hilla.v1");
            String templateV2Content = this.getTemplateContent(".hilla.v2");
            String uncommentedContent = TaskGenerateTsDefinitions.removeComments(content);
            if (FileIOUtils.compareIgnoringIndentationEOLAndWhiteSpace(uncommentedContent, templateContent, String::equals) || FileIOUtils.compareIgnoringIndentationEOLAndWhiteSpace(uncommentedContent, templateV2Content, String::equals)) {
                return UpdateMode.UPDATE;
            }
        }
        catch (IOException ex) {
            throw new ExecutionFailedException("Cannot read default types.d.ts.hilla contents", ex);
        }
        return UpdateMode.UPDATE_AND_BACKUP;
    }

    private static String removeComments(String content) {
        return COMMENT_LINE.matcher(content).replaceAll("");
    }

    private String getTemplateContent(String suffix) throws IOException {
        try (InputStream tsDefinitionStream = this.getClass().getResourceAsStream(TS_DEFINITIONS + suffix);){
            String string = StringUtil.toUTF8String(tsDefinitionStream);
            return string;
        }
    }

    private static enum UpdateMode {
        REPLACE,
        UPDATE,
        UPDATE_AND_BACKUP;

    }
}

