/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Inherited
@Documented
public @interface ColorScheme {
    public Value value() default Value.NORMAL;

    public static enum Value {
        LIGHT("light"),
        DARK("dark"),
        LIGHT_DARK("light dark"),
        DARK_LIGHT("dark light"),
        NORMAL("normal"),
        SYSTEM("light dark");

        private final String value;

        private Value(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getThemeValue() {
            return this.value.replace(' ', '-');
        }

        public static Value fromString(String value) {
            if (value == null || value.isEmpty()) {
                return NORMAL;
            }
            for (Value v : Value.values()) {
                if (!v.value.equals(value)) continue;
                return v;
            }
            return NORMAL;
        }
    }
}

