/*
 * Copyright 2000-2025 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.flow.server.streams;

/**
 * Upload handler that stores the data into a file generated by the given
 * {@link FileFactory}.
 *
 * @since 24.8
 */
public class FileUploadHandler
        extends AbstractFileUploadHandler<FileUploadHandler> {

    /**
     * Constructor for file upload handler.
     *
     * @param successCallback
     *            consumer to be called when upload successfully completes
     * @param fileFactory
     *            factory for generating file to write to
     */
    public FileUploadHandler(FileUploadCallback successCallback,
            FileFactory fileFactory) {
        super(successCallback, fileFactory);
    }
}
