/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ErrorHandlerUtil {
    public static boolean handleErrorByRedirectingToErrorView(Throwable throwable) {
        if (throwable instanceof Exception) {
            return ErrorHandlerUtil.handleErrorByRedirectingToErrorView((Exception)throwable);
        }
        return false;
    }

    public static boolean handleErrorByRedirectingToErrorView(Throwable throwable, VaadinContext context, UI ui) {
        if (throwable instanceof Exception) {
            return ErrorHandlerUtil.handleErrorByRedirectingToErrorView((Exception)throwable, context, ui);
        }
        return false;
    }

    public static boolean handleErrorByRedirectingToErrorView(Exception exception) {
        VaadinContext context;
        UI ui = UI.getCurrent();
        if (ui == null) {
            return false;
        }
        VaadinSession session = ui.getSession();
        VaadinService current = session != null ? session.getService() : null;
        VaadinContext vaadinContext = context = current != null ? current.getContext() : null;
        if (context == null) {
            return false;
        }
        return ErrorHandlerUtil.handleErrorByRedirectingToErrorView(exception, context, ui);
    }

    public static boolean handleErrorByRedirectingToErrorView(Exception exception, VaadinContext context, UI ui) {
        ApplicationRouteRegistry appRegistry = ApplicationRouteRegistry.getInstance(context);
        Optional<ErrorTargetEntry> errorNavigationTarget = appRegistry.getErrorNavigationTarget(exception);
        if (errorNavigationTarget.isPresent() && errorNavigationTarget.get().getHandledExceptionType().equals(exception.getClass())) {
            Component routeTarget = ErrorHandlerUtil.getRouteTarget(errorNavigationTarget.get().getNavigationTarget(), ui);
            List<Class<? extends RouterLayout>> routeLayouts = RouteUtil.getParentLayoutsForNonRouteTarget(routeTarget.getClass());
            List<RouterLayout> parentLayouts = routeLayouts.stream().map(route -> (RouterLayout)ErrorHandlerUtil.getRouteTarget(route, ui)).collect(Collectors.toList());
            UIInternals internals = ui.getInternals();
            internals.showRouteTarget(internals.getActiveViewLocation(), routeTarget, parentLayouts);
            NavigationEvent navigationEvent = new NavigationEvent(internals.getRouter(), internals.getActiveViewLocation(), ui, NavigationTrigger.PROGRAMMATIC);
            BeforeEnterEvent beforeEnterEvent = new BeforeEnterEvent(navigationEvent, errorNavigationTarget.get().getNavigationTarget(), routeLayouts);
            ((HasErrorParameter)((Object)routeTarget)).setErrorParameter(beforeEnterEvent, new ErrorParameter(exception.getClass(), exception));
            return true;
        }
        return false;
    }

    private static <T extends HasElement> T getRouteTarget(Class<T> routeTargetType, UI ui) {
        Optional<HasElement> currentInstance = ui.getInternals().getActiveRouterTargetsChain().stream().filter(component -> component.getClass().equals(routeTargetType)).findAny();
        return (T)currentInstance.orElseGet(() -> Instantiator.get(ui).createRouteTarget(routeTargetType, null));
    }
}

