/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.installer;

import com.vaadin.flow.server.frontend.installer.DownloadException;
import com.vaadin.flow.server.frontend.installer.FileDownloader;
import com.vaadin.flow.server.frontend.installer.ProxyConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultFileDownloader
implements FileDownloader {
    public static final String HTTPS_PROTOCOLS = "https.protocols";
    private final ProxyConfig proxyConfig;
    private String userName;
    private String password;

    public DefaultFileDownloader(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    @Override
    public void download(URI downloadURI, File destination, String userName, String password, FileDownloader.ProgressListener progressListener) throws DownloadException {
        this.userName = userName;
        this.password = password;
        String oldProtocols = System.setProperty(HTTPS_PROTOCOLS, "TLSv1.2");
        try {
            if ("file".equalsIgnoreCase(downloadURI.getScheme())) {
                FileUtils.copyFile((File)new File(downloadURI), (File)destination);
            } else {
                this.downloadFile(destination, downloadURI, progressListener);
            }
        }
        catch (IOException e) {
            throw new DownloadException("Could not download " + String.valueOf(downloadURI), e);
        }
        finally {
            if (oldProtocols == null) {
                System.clearProperty(HTTPS_PROTOCOLS);
            } else {
                System.setProperty(HTTPS_PROTOCOLS, oldProtocols);
            }
        }
    }

    private void downloadFile(File destination, URI downloadUri, FileDownloader.ProgressListener progressListener) throws IOException, DownloadException {
        HttpClient.Builder clientBuilder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL);
        final ProxyConfig.Proxy proxy = this.proxyConfig.getProxyForUrl(downloadUri.toString());
        if (proxy != null) {
            this.getLogger().debug("Downloading via proxy {}", (Object)proxy.toString());
            clientBuilder = clientBuilder.proxy(ProxySelector.of(new InetSocketAddress(proxy.host, proxy.port)));
            clientBuilder = clientBuilder.authenticator(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                        return new PasswordAuthentication(proxy.username, proxy.password.toCharArray());
                    }
                    return new PasswordAuthentication(DefaultFileDownloader.this.userName, DefaultFileDownloader.this.password.toCharArray());
                }
            });
        } else {
            this.getLogger().debug("No proxy was configured, downloading directly");
            if (this.userName != null && !this.userName.isEmpty() && this.password != null && !this.password.isEmpty()) {
                this.getLogger().info("Using credentials ({})", (Object)this.userName);
                clientBuilder = clientBuilder.authenticator(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(DefaultFileDownloader.this.userName, DefaultFileDownloader.this.password.toCharArray());
                    }
                });
            }
        }
        HttpClient client = clientBuilder.build();
        HttpRequest request = HttpRequest.newBuilder().uri(downloadUri).GET().build();
        try {
            HttpResponse.BodyHandler<InputStream> bodyHandler = HttpResponse.BodyHandlers.ofInputStream();
            HttpResponse<InputStream> response = client.send(request, bodyHandler);
            if (response.statusCode() != 200) {
                throw new DownloadException("Got error code " + response.statusCode() + " from the server.");
            }
            long contentLength = response.headers().firstValueAsLong("Content-Length").orElse(-1L);
            try (FileOutputStream out = FileUtils.openOutputStream((File)destination);){
                this.copy(response.body(), out, contentLength, progressListener);
            }
            if (contentLength != -1L && destination.length() != contentLength) {
                throw new DownloadException("Error downloading from " + String.valueOf(downloadUri) + ". Expected " + contentLength + " bytes but got " + destination.length());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
    }

    long copy(InputStream inputStream, OutputStream outputStream, long total, FileDownloader.ProgressListener progressListener) throws IOException {
        int n;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        byte[] buffer = IOUtils.byteArray((int)8192);
        long count = 0L;
        double lastReportedProgress = 0.0;
        while (-1 != (n = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, n);
            lastReportedProgress = this.reportProgress(progressListener, total, count += (long)n, lastReportedProgress);
        }
        if (lastReportedProgress != 1.0 && lastReportedProgress != (double)total) {
            lastReportedProgress = this.reportProgress(progressListener, total, count, 0.0);
        }
        return count;
    }

    private double reportProgress(FileDownloader.ProgressListener progressListener, long total, long count, double lastReportedProgress) {
        if (progressListener == null) {
            return lastReportedProgress;
        }
        if (total == -1L) {
            if ((double)count >= lastReportedProgress + 1048576.0) {
                progressListener.onProgress(count, total, -1.0);
                return count;
            }
        } else {
            double progress = (double)count / (double)total;
            if (progress - lastReportedProgress > 0.01) {
                progressListener.onProgress(count, total, progress);
                return progress;
            }
        }
        return lastReportedProgress;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)"FileDownloader");
    }
}

