/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.internal.ConstantPool;
import com.vaadin.flow.internal.ConstantPoolKey;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ReturnChannelRegistration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonType;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.stream.Stream;

public class JsonCodec {
    public static final int NODE_TYPE = 0;
    public static final int ARRAY_TYPE = 1;
    public static final int RETURN_CHANNEL_TYPE = 2;

    private JsonCodec() {
    }

    public static JsonValue encodeWithTypeInfo(Object value) {
        assert (value == null || JsonCodec.canEncodeWithTypeInfo(value.getClass()));
        if (value instanceof Component) {
            return JsonCodec.encodeNode(((Component)value).getElement());
        }
        if (value instanceof Node) {
            return JsonCodec.encodeNode((Node)value);
        }
        if (value instanceof ReturnChannelRegistration) {
            return JsonCodec.encodeReturnChannel((ReturnChannelRegistration)value);
        }
        JsonValue encoded = JsonCodec.encodeWithoutTypeInfo(value);
        if (encoded.getType() == JsonType.ARRAY) {
            encoded = JsonCodec.wrapComplexValue(1, encoded);
        }
        return encoded;
    }

    private static JsonValue encodeReturnChannel(ReturnChannelRegistration value) {
        return JsonCodec.wrapComplexValue(2, new JsonValue[]{Json.create((double)value.getStateNodeId()), Json.create((double)value.getChannelId())});
    }

    private static JsonValue encodeNode(Node<?> node) {
        StateNode stateNode = node.getNode();
        if (stateNode.isAttached()) {
            return JsonCodec.wrapComplexValue(0, new JsonValue[]{Json.create((double)stateNode.getId())});
        }
        return Json.createNull();
    }

    private static JsonArray wrapComplexValue(int typeId, JsonValue ... values) {
        return Stream.concat(Stream.of(Json.create((double)typeId)), Stream.of(values)).collect(JsonUtils.asArray());
    }

    public static boolean canEncodeWithoutTypeInfo(Class<?> type) {
        assert (type != null);
        return String.class.equals(type) || Integer.class.equals(type) || Double.class.equals(type) || Boolean.class.equals(type) || JsonValue.class.isAssignableFrom(type);
    }

    public static boolean canEncodeWithTypeInfo(Class<?> type) {
        return JsonCodec.canEncodeWithoutTypeInfo(type) || Node.class.isAssignableFrom(type) || Component.class.isAssignableFrom(type) || ReturnChannelRegistration.class.isAssignableFrom(type);
    }

    public static JsonValue encodeWithConstantPool(Object value, ConstantPool constantPool) {
        if (value instanceof ConstantPoolKey) {
            ConstantPoolKey reference = (ConstantPoolKey)value;
            return Json.create((String)constantPool.getConstantId(reference));
        }
        return JsonCodec.encodeWithoutTypeInfo(value);
    }

    public static JsonValue encodeWithoutTypeInfo(Object value) {
        if (value == null) {
            return Json.createNull();
        }
        assert (JsonCodec.canEncodeWithoutTypeInfo(value.getClass()));
        Class<?> type = value.getClass();
        if (String.class.equals(value.getClass())) {
            return Json.create((String)((String)value));
        }
        if (Integer.class.equals(type) || Double.class.equals(type)) {
            return Json.create((double)((Number)value).doubleValue());
        }
        if (Boolean.class.equals(type)) {
            return Json.create((boolean)((Boolean)value));
        }
        if (JsonValue.class.isAssignableFrom(type)) {
            return (JsonValue)value;
        }
        assert (!JsonCodec.canEncodeWithoutTypeInfo(type));
        throw new IllegalArgumentException("Can't encode " + value.getClass() + " to json");
    }

    public static Serializable decodeWithoutTypeInfo(JsonValue json) {
        assert (json != null);
        switch (json.getType()) {
            case BOOLEAN: {
                return JsonCodec.decodeAs(json, Boolean.class);
            }
            case STRING: {
                return (Serializable)((Object)JsonCodec.decodeAs(json, String.class));
            }
            case NUMBER: {
                return JsonCodec.decodeAs(json, Double.class);
            }
            case NULL: {
                return null;
            }
        }
        return json;
    }

    public static <T> T decodeAs(JsonValue json, Class<T> type) {
        assert (json != null);
        if (json.getType() == JsonType.NULL && !type.isPrimitive()) {
            return null;
        }
        Class<?> convertedType = ReflectTools.convertPrimitiveType(type);
        if (type == String.class) {
            return type.cast(json.asString());
        }
        if (convertedType == Boolean.class) {
            return (T)convertedType.cast(json.asBoolean());
        }
        if (convertedType == Double.class) {
            return (T)convertedType.cast(json.asNumber());
        }
        if (convertedType == Integer.class) {
            return (T)convertedType.cast((int)json.asNumber());
        }
        if (JsonValue.class.isAssignableFrom(type)) {
            return type.cast(json);
        }
        assert (!JsonCodec.canEncodeWithoutTypeInfo(type));
        throw new IllegalArgumentException("Unknown type " + type.getName());
    }
}

