/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.BodySize;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.Meta;
import com.vaadin.flow.component.page.Viewport;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.InlineTargets;
import com.vaadin.flow.server.VaadinService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class BootstrapUtils {
    private BootstrapUtils() {
    }

    static Optional<String> getViewportContent(BootstrapHandler.BootstrapContext context) {
        return context.getPageConfigurationAnnotation(Viewport.class).map(Viewport::value);
    }

    static Map<String, String> getMetaTargets(BootstrapHandler.BootstrapContext context) {
        List<Meta> metaAnnotations = context.getPageConfigurationAnnotations(Meta.class);
        boolean illegalValue = false;
        HashMap<String, String> map = new HashMap<String, String>();
        for (Meta meta : metaAnnotations) {
            if (!meta.name().isEmpty() && !meta.content().isEmpty()) {
                map.put(meta.name(), meta.content());
                continue;
            }
            illegalValue = true;
            break;
        }
        if (illegalValue) {
            throw new IllegalStateException("Meta tags added via Meta annotation contain null value on name or content attribute.");
        }
        return map;
    }

    static String getBodySizeContent(BootstrapHandler.BootstrapContext context) {
        Optional<BodySize> bodySize = context.getPageConfigurationAnnotation(BodySize.class);
        String height = bodySize.map(BodySize::height).orElse("100vh");
        String width = bodySize.map(BodySize::width).orElse("100%");
        StringBuilder bodyString = new StringBuilder();
        bodyString.append("body {");
        if (!height.isEmpty()) {
            bodyString.append("height:").append(height).append(";");
        }
        if (!width.isEmpty()) {
            bodyString.append("width:").append(width).append(";");
        }
        bodyString.append("margin:0;");
        bodyString.append("}");
        return bodyString.toString();
    }

    static Optional<InlineTargets> getInlineTargets(BootstrapHandler.BootstrapContext context) {
        List<Inline> inlineAnnotations = context.getPageConfigurationAnnotations(Inline.class);
        if (inlineAnnotations.isEmpty()) {
            return Optional.empty();
        }
        InlineTargets inlines = new InlineTargets();
        inlineAnnotations.forEach(inline -> inlines.addInlineDependency((Inline)inline, context.getService()));
        return Optional.of(inlines);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static String getDependencyContents(VaadinService service, String file) {
        try (InputStream inlineResourceStream = BootstrapUtils.getInlineResourceStream(service, file);){
            String string;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inlineResourceStream, StandardCharsets.UTF_8));){
                string = bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Could not read file %s contents", file), e);
        }
    }

    private static InputStream getInlineResourceStream(VaadinService service, String file) {
        ResourceProvider resourceProvider = service.getContext().getAttribute(Lookup.class).lookup(ResourceProvider.class);
        URL appResource = resourceProvider.getApplicationResource(file);
        InputStream stream = null;
        try {
            stream = appResource == null ? null : appResource.openStream();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Couldn't open application resource '%s' for inline resource", file), e);
        }
        if (stream == null) {
            throw new IllegalStateException(String.format("Application resource '%s' for inline resource is not available", file));
        }
        return stream;
    }

    public static Optional<Class<?>> resolvePageConfigurationHolder(UI ui, Location route) {
        assert (ui != null);
        assert (route != null);
        if (ui.getInternals().getRouter() == null) {
            return Optional.empty();
        }
        Optional<Class<?>> navigationTarget = ui.getInternals().getRouter().resolveNavigationTarget(route).map(BootstrapUtils::resolveTopParentLayout);
        if (navigationTarget.isPresent()) {
            return navigationTarget;
        }
        return ui.getInternals().getRouter().resolveRouteNotFoundNavigationTarget().map(state -> {
            List<Class<? extends RouterLayout>> layouts = RouteUtil.getParentLayoutsForNonRouteTarget(state.getNavigationTarget());
            if (layouts.isEmpty()) {
                return state.getNavigationTarget();
            }
            return layouts.get(layouts.size() - 1);
        });
    }

    private static Class<?> resolveTopParentLayout(NavigationState navigationState) {
        Class<? extends RouterLayout> parentLayout = BootstrapUtils.getTopParentLayout(navigationState);
        if (parentLayout != null) {
            return parentLayout;
        }
        return navigationState.getNavigationTarget();
    }

    private static Class<? extends RouterLayout> getTopParentLayout(NavigationState navigationState) {
        List<Class<? extends RouterLayout>> routeLayouts = navigationState.getRouteTarget().getParentLayouts();
        if (routeLayouts.isEmpty()) {
            return null;
        }
        return routeLayouts.get(routeLayouts.size() - 1);
    }
}

