/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.server.HttpStatusCode;
import java.io.InputStream;
import java.io.Serializable;

public class DownloadResponse
implements Serializable {
    private final InputStream inputStream;
    private final String fileName;
    private final String contentType;
    private final long contentLength;
    private Integer error;
    private String errorMessage;

    public DownloadResponse(InputStream inputStream, String fileName, String contentType, long contentLength) {
        this.inputStream = inputStream;
        this.fileName = fileName;
        this.contentLength = contentLength;
        this.contentType = contentType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public static DownloadResponse error(int statusCode) {
        DownloadResponse downloadResponse = new DownloadResponse(null, null, null, -1L);
        downloadResponse.setError(statusCode);
        return downloadResponse;
    }

    public static DownloadResponse error(int statusCode, String message) {
        DownloadResponse downloadResponse = new DownloadResponse(null, null, null, -1L);
        downloadResponse.setError(statusCode, message);
        return downloadResponse;
    }

    public static DownloadResponse error(HttpStatusCode statusCode) {
        DownloadResponse downloadResponse = new DownloadResponse(null, null, null, -1L);
        downloadResponse.setError(statusCode);
        return downloadResponse;
    }

    public static DownloadResponse error(HttpStatusCode statusCode, String message) {
        DownloadResponse downloadResponse = new DownloadResponse(null, null, null, -1L);
        downloadResponse.setError(statusCode, message);
        return downloadResponse;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public void setError(int error) {
        this.error = error;
    }

    public void setError(int error, String errorMessage) {
        this.error = error;
        this.errorMessage = errorMessage;
    }

    public void setError(HttpStatusCode error) {
        this.error = error.getCode();
    }

    public void setError(HttpStatusCode error, String errorMessage) {
        this.error = error.getCode();
        this.errorMessage = errorMessage;
    }

    public int getError() {
        if (this.error == null) {
            return -1;
        }
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

