/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.TargetElement;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.BootstrapUtils;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.ui.LoadMode;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class InlineTargets {
    private final Map<Inline.Position, List<ObjectNode>> inlineHead = new EnumMap<Inline.Position, List<ObjectNode>>(Inline.Position.class);
    private final Map<Inline.Position, List<ObjectNode>> inlineBody = new EnumMap<Inline.Position, List<ObjectNode>>(Inline.Position.class);

    public void addInlineDependency(Inline inline, VaadinService service) {
        Inline.Wrapping type = inline.wrapping().equals((Object)Inline.Wrapping.AUTOMATIC) ? this.determineDependencyType(inline) : inline.wrapping();
        ObjectNode dependency = JacksonUtils.createObjectNode();
        dependency.put("type", type.toString());
        dependency.put("LoadMode", LoadMode.INLINE.toString());
        dependency.put("contents", BootstrapUtils.getDependencyContents(service, inline.value()));
        if (inline.target() == TargetElement.BODY) {
            this.getInlineBody(inline.position()).add(dependency);
        } else {
            this.getInlineHead(inline.position()).add(dependency);
        }
    }

    private Inline.Wrapping determineDependencyType(Inline inline) {
        Inline.Wrapping type = inline.value().endsWith(".js") ? Inline.Wrapping.JAVASCRIPT : (inline.value().endsWith(".css") ? Inline.Wrapping.STYLESHEET : Inline.Wrapping.NONE);
        return type;
    }

    public List<ObjectNode> getInlineHead(Inline.Position position) {
        return this.inlineHead.computeIfAbsent(position, key -> new ArrayList());
    }

    public List<ObjectNode> getInlineBody(Inline.Position position) {
        return this.inlineBody.computeIfAbsent(position, key -> new ArrayList());
    }
}

