/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.internal.JacksonUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VersionsJsonConverter {
    static final String VAADIN_CORE_NPM_PACKAGE = "@vaadin/vaadin-core";
    static final String VAADIN_BUNDLES = "@vaadin/bundles";
    private static final String JS_VERSION = "jsVersion";
    private static final String NPM_NAME = "npmName";
    private static final String NPM_VERSION = "npmVersion";
    public static final String EXCLUSIONS = "exclusions";
    public static final String MODE = "mode";
    public static final String MODE_LIT = "lit";
    public static final String MODE_REACT = "react";
    public static final String MODE_ALL = "all";
    private static final Object VAADIN_ROUTER = "@vaadin/router";
    private final ObjectNode convertedObject;
    private boolean reactEnabled;
    private boolean excludeWebComponents;
    private Set<String> exclusions;

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VersionsJsonConverter.class);
    }

    VersionsJsonConverter(JsonNode platformVersions, boolean reactEnabled, boolean excludeWebComponents) {
        this.reactEnabled = reactEnabled;
        this.excludeWebComponents = excludeWebComponents;
        this.exclusions = new HashSet<String>();
        this.convertedObject = JacksonUtils.createObjectNode();
        this.collectDependencies(platformVersions);
        this.excludeDependencies();
    }

    ObjectNode getConvertedJson() {
        return this.convertedObject;
    }

    Set<String> getExclusions() {
        return this.exclusions;
    }

    private void collectDependencies(JsonNode obj) {
        for (String key : JacksonUtils.getKeys(obj)) {
            JsonNode value = obj.get(key);
            if (!(value instanceof ObjectNode)) continue;
            if (value.has(NPM_NAME)) {
                this.addDependency(value);
                continue;
            }
            this.collectDependencies(value);
        }
    }

    private void excludeDependencies() {
        for (String key : JacksonUtils.getKeys((JsonNode)this.convertedObject)) {
            if (!this.exclusions.contains(key)) continue;
            this.convertedObject.remove(key);
        }
    }

    private boolean isIncludedByMode(String mode) {
        if (mode == null || mode.isBlank() || MODE_ALL.equalsIgnoreCase(mode)) {
            return true;
        }
        if (this.excludeWebComponents) {
            return false;
        }
        if (this.reactEnabled) {
            return MODE_REACT.equalsIgnoreCase(mode);
        }
        return MODE_LIT.equalsIgnoreCase(mode);
    }

    private void addDependency(JsonNode obj) {
        String version;
        String mode;
        assert (obj.has(NPM_NAME));
        String npmName = obj.get(NPM_NAME).textValue();
        String string = mode = obj.has(MODE) ? obj.get(MODE).textValue() : null;
        if (Objects.equals(npmName, VAADIN_CORE_NPM_PACKAGE)) {
            return;
        }
        if (this.excludeWebComponents && Objects.equals(npmName, VAADIN_BUNDLES)) {
            this.exclusions.add(npmName);
            return;
        }
        if (this.reactEnabled && Objects.equals(npmName, VAADIN_ROUTER)) {
            this.exclusions.add(npmName);
            return;
        }
        if (!this.isIncludedByMode(mode)) {
            if (this.excludeWebComponents) {
                if (MODE_REACT.equalsIgnoreCase(mode)) {
                    this.exclusions.add(npmName);
                }
                this.collectExclusions(obj);
            }
            return;
        }
        if (obj.has(NPM_VERSION)) {
            version = obj.get(NPM_VERSION).textValue();
        } else if (obj.has(JS_VERSION)) {
            version = obj.get(JS_VERSION).textValue();
        } else {
            throw new IllegalStateException("Vaadin code versions file contains unexpected data: dependency '" + npmName + "' has no 'npmVersion'/'jsVersion' . Please report a bug in https://github.com/vaadin/platform/issues/new");
        }
        this.convertedObject.put(npmName, version);
        this.collectExclusions(obj);
        VersionsJsonConverter.getLogger().debug("versions.json adds dependency {} with version {}{}", new Object[]{npmName, version, mode != null ? " for mode " + mode : ""});
    }

    private void collectExclusions(JsonNode obj) {
        ArrayNode array;
        if (obj.has(EXCLUSIONS) && (array = (ArrayNode)obj.get(EXCLUSIONS)) != null) {
            IntStream.range(0, array.size()).forEach(i -> this.exclusions.add(array.get(i).textValue()));
        }
    }
}

