/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.AccessDeniedException;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import com.vaadin.flow.server.auth.AccessCheckDecision;
import com.vaadin.flow.server.auth.AccessCheckDecisionResolver;
import com.vaadin.flow.server.auth.AccessCheckResult;
import com.vaadin.flow.server.auth.AccessDeniedErrorRouter;
import com.vaadin.flow.server.auth.AnnotatedViewAccessChecker;
import com.vaadin.flow.server.auth.DefaultAccessCheckDecisionResolver;
import com.vaadin.flow.server.auth.NavigationAccessChecker;
import com.vaadin.flow.server.auth.NavigationContext;
import java.lang.reflect.AnnotatedElement;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavigationAccessControl
implements BeforeEnterListener {
    public static final String SESSION_STORED_REDIRECT = NavigationAccessControl.class.getName() + ".redirect";
    public static final String SESSION_STORED_REDIRECT_ABSOLUTE = NavigationAccessControl.class.getName() + ".redirectAbsolute";
    private final List<NavigationAccessChecker> checkerList;
    private final AccessCheckDecisionResolver decisionResolver;
    private Class<? extends Component> loginView;
    private String loginUrl;
    private boolean enabled = true;

    public NavigationAccessControl() {
        this(List.of(new AnnotatedViewAccessChecker()));
    }

    public NavigationAccessControl(Collection<NavigationAccessChecker> checkerList, AccessCheckDecisionResolver decisionResolver) {
        this.decisionResolver = Objects.requireNonNull(decisionResolver, "decision resolver must not be null");
        this.checkerList = List.copyOf(checkerList);
    }

    protected NavigationAccessControl(Collection<NavigationAccessChecker> checkerList) {
        this(checkerList, new DefaultAccessCheckDecisionResolver());
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setLoginView(Class<? extends Component> loginView) {
        if (loginView == this.loginView) {
            return;
        }
        this.throwIfLoginViewSet();
        this.loginView = loginView;
    }

    protected Class<? extends Component> getLoginView() {
        return this.loginView;
    }

    public void setLoginView(String loginUrl) {
        if (loginUrl == this.loginUrl) {
            return;
        }
        this.throwIfLoginViewSet();
        this.loginUrl = loginUrl;
    }

    protected String getLoginUrl() {
        return this.loginUrl;
    }

    private void throwIfLoginViewSet() {
        if (this.loginUrl != null) {
            throw new IllegalStateException("Already using " + this.loginUrl + " as the login view");
        }
        if (this.loginView != null) {
            throw new IllegalStateException("Already using " + this.loginView.getName() + " as the login view");
        }
    }

    @Override
    public void beforeEnter(BeforeEnterEvent event) {
        VaadinRequest request = VaadinRequest.getCurrent();
        NavigationContext context = new NavigationContext(event, this.getPrincipal(request), this.getRolesChecker(request));
        AccessCheckResult result = this.checkAccess(context, this.isProductionMode(event));
        if (result.decision() != AccessCheckDecision.ALLOW) {
            if (context.getPrincipal() == null) {
                this.storeRedirectURL(event, request);
                if (this.loginView != null) {
                    event.forwardTo(this.loginView, true);
                } else if (this.loginUrl != null) {
                    event.forwardToUrl(this.loginUrl);
                } else {
                    event.rerouteToError(NotFoundException.class, result.reason());
                }
            } else {
                event.rerouteToError(this.getAccessDeniedException(AccessAnnotationChecker.securityTarget(event.getNavigationTarget())), result.reason());
            }
        }
    }

    public AccessCheckResult checkAccess(NavigationContext context, boolean productionMode) {
        Class<?> navigationTarget = context.getNavigationTarget();
        if (!this.enabled) {
            NavigationAccessControl.getLogger().trace("Navigation to view {} allowed because navigation access control is disable", (Object)navigationTarget.getName());
            return context.allow();
        }
        if (this.checkerList.isEmpty()) {
            NavigationAccessControl.getLogger().debug("Navigation to view {} allowed because there are no navigation checkers configured", (Object)navigationTarget.getName());
            return context.allow();
        }
        NavigationAccessControl.getLogger().debug("Checking access for view {}", (Object)navigationTarget.getName());
        if (this.loginView != null && navigationTarget == this.loginView) {
            NavigationAccessControl.getLogger().debug("Allowing access for login view {}", (Object)navigationTarget.getName());
            return context.allow();
        }
        if (this.loginUrl != null && PathUtil.trimPath(this.loginUrl).equals(context.getLocation().getPath())) {
            NavigationAccessControl.getLogger().debug("Allowing access for login URL {}", (Object)this.loginUrl);
            return AccessCheckResult.allow();
        }
        List<AccessCheckResult> results = this.checkerList.stream().map(checker -> checker.check(context)).toList();
        AccessCheckResult decision = this.decisionResolver.resolve(results, context);
        NavigationAccessControl.getLogger().debug("Decision against {} checker results: {}", (Object)results.size(), (Object)decision);
        if (decision.decision() == AccessCheckDecision.REJECT && !productionMode) {
            throw new IllegalStateException(decision.reason());
        }
        if (productionMode) {
            decision = new AccessCheckResult(decision.decision(), "");
        }
        return decision;
    }

    protected Principal getPrincipal(VaadinRequest request) {
        if (request == null) {
            return null;
        }
        return request.getUserPrincipal();
    }

    protected Predicate<String> getRolesChecker(VaadinRequest request) {
        if (request == null) {
            return role -> false;
        }
        return request::isUserInRole;
    }

    protected String getRequestURL(VaadinRequest vaadinRequest) {
        if (vaadinRequest instanceof VaadinServletRequest) {
            VaadinServletRequest httpRequest = (VaadinServletRequest)vaadinRequest;
            String url = httpRequest.getRequestURL().toString();
            if (HandlerHelper.isRequestType(vaadinRequest, HandlerHelper.RequestType.PUSH) && url.endsWith("VAADIN/push")) {
                url = url.substring(0, url.indexOf("VAADIN/push"));
            }
            return url;
        }
        return "";
    }

    private void storeRedirectURL(BeforeEnterEvent event, VaadinRequest request) {
        WrappedSession session;
        WrappedSession wrappedSession = session = request != null ? request.getWrappedSession() : null;
        if (session != null) {
            String servletHostAndPath = this.getRequestURL(request);
            String viewPathAndParameters = event.getLocation().getPathWithQueryParameters();
            session.setAttribute(SESSION_STORED_REDIRECT, viewPathAndParameters);
            session.setAttribute(SESSION_STORED_REDIRECT_ABSOLUTE, servletHostAndPath + viewPathAndParameters);
        } else if (request == null) {
            NavigationAccessControl.getLogger().debug("Unable to store redirect in session because no request is available");
        }
    }

    protected Class<? extends RuntimeException> getAccessDeniedException(AnnotatedElement securedClass) {
        if (securedClass.isAnnotationPresent(AccessDeniedErrorRouter.class)) {
            return securedClass.getAnnotation(AccessDeniedErrorRouter.class).rerouteToError();
        }
        return AccessDeniedException.class;
    }

    private boolean isProductionMode(BeforeEnterEvent beforeEnterEvent) {
        return beforeEnterEvent.getUI().getSession().getConfiguration().isProductionMode();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(NavigationAccessControl.class);
    }

    public boolean hasAccessChecker(Class<? extends NavigationAccessChecker> type) {
        return this.checkerList.stream().anyMatch(checker -> type.isAssignableFrom(checker.getClass()));
    }

    public NavigationContext createNavigationContext(Class<?> navigationTarget, String path, VaadinService vaadinService, VaadinRequest vaadinRequest) {
        Objects.requireNonNull(navigationTarget);
        Objects.requireNonNull(path);
        Objects.requireNonNull(vaadinService);
        return new NavigationContext(vaadinService.getRouter(), navigationTarget, new Location(path), RouteParameters.empty(), this.getPrincipal(vaadinRequest), this.getRolesChecker(vaadinRequest), false);
    }
}

