/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.ModelList;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.NodeFeatureRegistry;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import com.vaadin.flow.internal.nodefeature.PropertyChangeDeniedException;
import com.vaadin.flow.server.communication.rpc.AbstractRpcInvocationHandler;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapSyncRpcHandler
extends AbstractRpcInvocationHandler {
    @Override
    public String getRpcType() {
        return "mSync";
    }

    @Override
    protected Optional<Runnable> handleNode(StateNode node, JsonObject invocationJson) {
        DisabledUpdateMode eventMode;
        assert (invocationJson.hasKey("feature"));
        assert (invocationJson.hasKey("property"));
        assert (invocationJson.hasKey("value"));
        int featureId = (int)invocationJson.getNumber("feature");
        Class<? extends NodeFeature> feature = NodeFeatureRegistry.getFeature(featureId);
        assert (NodeMap.class.isAssignableFrom(feature));
        assert (ElementPropertyMap.class.equals(feature));
        boolean isEnabled = node.isEnabled();
        ArrayList<DisabledUpdateMode> seenUpdateModes = new ArrayList<DisabledUpdateMode>();
        String property = invocationJson.getString("property");
        if (node.hasFeature(ElementListenerMap.class) && (eventMode = node.getFeature(ElementListenerMap.class).getPropertySynchronizationMode(property)) != null) {
            seenUpdateModes.add(eventMode);
        }
        DisabledUpdateMode updateMode = seenUpdateModes.stream().reduce(DisabledUpdateMode::mostPermissive).orElse(null);
        if (isEnabled) {
            return this.enqueuePropertyUpdate(node, invocationJson, feature, property);
        }
        if (DisabledUpdateMode.ALWAYS.equals((Object)updateMode)) {
            LoggerFactory.getLogger(MapSyncRpcHandler.class).trace("Property update request for disabled element is received from the client side. Change will be applied since the property '{}' always allows its update.", (Object)property);
            return this.enqueuePropertyUpdate(node, invocationJson, feature, property);
        }
        Logger logger = LoggerFactory.getLogger(MapSyncRpcHandler.class);
        Optional<Serializable> featureProperty = node.getFeatureIfInitialized(ElementPropertyMap.class).map(feat -> feat.getProperty(property));
        if (featureProperty.isPresent()) {
            logger.warn("Property update request for disabled element is received from the client side. The property is '{}'. Request is ignored.", (Object)property);
        } else {
            logger.debug("Ignored property '{}' change for disabled element. Most likely client sent the default value as no value has been set for the property.", (Object)property);
        }
        return Optional.empty();
    }

    private Optional<Runnable> enqueuePropertyUpdate(StateNode node, JsonObject invocationJson, Class<? extends NodeFeature> feature, String property) {
        Serializable value = JsonCodec.decodeWithoutTypeInfo(invocationJson.get("value"));
        value = this.tryConvert(value, node);
        try {
            return Optional.of(node.getFeature(ElementPropertyMap.class).deferredUpdateFromClient(property, value));
        }
        catch (PropertyChangeDeniedException exception) {
            throw new IllegalArgumentException(this.getVetoPropertyUpdateMessage(node, property), exception);
        }
    }

    private boolean hasElement(StateNode node) {
        return node != null && node.hasFeature(ElementData.class);
    }

    private String getVetoPropertyUpdateMessage(StateNode node, String property) {
        if (this.hasElement(node)) {
            Element element = Element.get(node);
            String tag = element.getTag();
            Optional<Component> component = element.getComponent();
            String prefix = component.isPresent() ? "Component " + component.get().getClass().getName() : "Element with tag '" + tag + "'";
            return String.format("%s tries to update (sub)property '%s' whose update is not allowed. For security reasons, the property must be defined as synchronized through the Element's API.", prefix, property);
        }
        if (node != null) {
            return this.getVetoPropertyUpdateMessage(node.getParent(), property);
        }
        return "";
    }

    private Serializable tryConvert(Serializable value, StateNode context) {
        JsonObject json;
        if (value instanceof JsonObject && (json = (JsonObject)value).hasKey("nodeId")) {
            StateTree tree = (StateTree)context.getOwner();
            double id = json.getNumber("nodeId");
            StateNode stateNode = tree.getNodeById((int)id);
            return this.tryCopyStateNode(stateNode, json);
        }
        return value;
    }

    private Serializable tryCopyStateNode(StateNode node, JsonObject properties) {
        if (node == null) {
            return properties;
        }
        if (this.isInList(node)) {
            StateNode copy = new StateNode(node);
            ElementPropertyMap originalProperties = node.getFeature(ElementPropertyMap.class);
            ElementPropertyMap copyProperties = copy.getFeature(ElementPropertyMap.class);
            originalProperties.getPropertyNames().forEach(property -> copyProperties.setProperty((String)property, originalProperties.getProperty((String)property)));
            return copy;
        }
        if (this.isProperty(node)) {
            return node;
        }
        return properties;
    }

    private boolean isProperty(StateNode node) {
        StateNode parent = node.getParent();
        assert (parent != null);
        if (parent.hasFeature(ElementPropertyMap.class)) {
            ElementPropertyMap map = parent.getFeature(ElementPropertyMap.class);
            return map.getPropertyNames().anyMatch(name -> node.equals(map.getProperty((String)name)));
        }
        return false;
    }

    private boolean isInList(StateNode node) {
        StateNode parent = node.getParent();
        assert (parent != null);
        return parent.hasFeature(ModelList.class) && parent.getFeature(ModelList.class).contains(node);
    }
}

