/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.servlet.http.HttpSession;
import java.security.Principal;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewAccessChecker
implements BeforeEnterListener {
    public static final String SESSION_STORED_REDIRECT = ViewAccessChecker.class.getName() + ".redirect";
    public static final String SESSION_STORED_REDIRECT_ABSOLUTE = ViewAccessChecker.class.getName() + ".redirectAbsolute";
    private final AccessAnnotationChecker accessAnnotationChecker;
    private Class<? extends Component> loginView;
    private String loginUrl;
    private boolean enabled = false;

    public ViewAccessChecker() {
        this(true);
    }

    public ViewAccessChecker(boolean enabled) {
        this(new AccessAnnotationChecker());
        this.enabled = enabled;
    }

    protected ViewAccessChecker(AccessAnnotationChecker accessAnnotationChecker) {
        this.accessAnnotationChecker = accessAnnotationChecker;
    }

    public void enable() {
        this.enabled = true;
    }

    public void setLoginView(Class<? extends Component> loginView) {
        this.throwIfLoginViewSet();
        this.loginView = loginView;
    }

    public void setLoginView(String loginUrl) {
        this.throwIfLoginViewSet();
        this.loginUrl = loginUrl;
    }

    private void throwIfLoginViewSet() {
        if (this.loginUrl != null) {
            throw new IllegalStateException("Already using " + this.loginUrl + " as the login view");
        }
        if (this.loginView != null) {
            throw new IllegalStateException("Already using " + this.loginView.getName() + " as the login view");
        }
    }

    @Override
    public void beforeEnter(BeforeEnterEvent beforeEnterEvent) {
        if (!this.enabled) {
            return;
        }
        Class<?> targetView = beforeEnterEvent.getNavigationTarget();
        VaadinRequest request = VaadinRequest.getCurrent();
        Principal principal = this.getPrincipal(request);
        Function<String, Boolean> rolesChecker = this.getRolesChecker(request);
        this.getLogger().debug("Checking access for view {}", (Object)targetView.getName());
        if (this.loginView != null && targetView == this.loginView) {
            this.getLogger().debug("Allowing access for login view {}", (Object)targetView.getName());
            return;
        }
        boolean hasAccess = this.accessAnnotationChecker.hasAccess(targetView, principal, rolesChecker);
        if (hasAccess) {
            this.getLogger().debug("Allowed access to view {}", (Object)targetView.getName());
            return;
        }
        this.getLogger().debug("Denied access to view {}", (Object)targetView.getName());
        if (principal == null) {
            HttpSession session;
            HttpSession httpSession = session = request instanceof VaadinServletRequest ? ((VaadinServletRequest)request).getSession() : null;
            if (session != null) {
                VaadinServletRequest servletRequest = (VaadinServletRequest)request;
                String servletHostAndPath = servletRequest.getRequestURL().toString();
                String viewPathAndParameters = beforeEnterEvent.getLocation().getPathWithQueryParameters();
                session.setAttribute(SESSION_STORED_REDIRECT, (Object)viewPathAndParameters);
                session.setAttribute(SESSION_STORED_REDIRECT_ABSOLUTE, (Object)(servletHostAndPath + viewPathAndParameters));
            } else if (request == null) {
                this.getLogger().debug("Unable to store redirect in session because no request is available");
            } else {
                this.getLogger().debug("Unable to store redirect in session because request is of type {}", (Object)request.getClass().getName());
            }
            if (this.loginView != null) {
                beforeEnterEvent.forwardTo(this.loginView);
            } else if (this.loginUrl != null) {
                beforeEnterEvent.forwardToUrl(this.loginUrl);
            } else {
                beforeEnterEvent.rerouteToError(NotFoundException.class);
            }
        } else if (this.isProductionMode(beforeEnterEvent)) {
            beforeEnterEvent.rerouteToError(NotFoundException.class);
        } else {
            Object errorMsg = "Access denied";
            if (this.isImplicitlyDenyAllAnnotated(targetView)) {
                errorMsg = (String)errorMsg + ". Consider adding one of the following annotations to make the view accessible: @AnonymousAllowed, @PermitAll, @RolesAllowed.";
            }
            beforeEnterEvent.rerouteToError(NotFoundException.class, (String)errorMsg);
        }
    }

    protected Function<String, Boolean> getRolesChecker(VaadinRequest request) {
        if (request == null) {
            return role -> false;
        }
        return request::isUserInRole;
    }

    protected Principal getPrincipal(VaadinRequest request) {
        if (request == null) {
            return null;
        }
        return request.getUserPrincipal();
    }

    private boolean isProductionMode(BeforeEnterEvent beforeEnterEvent) {
        return beforeEnterEvent.getUI().getSession().getConfiguration().isProductionMode();
    }

    private boolean isImplicitlyDenyAllAnnotated(Class<?> targetView) {
        return !targetView.isAnnotationPresent(DenyAll.class) && !targetView.isAnnotationPresent(PermitAll.class) && !targetView.isAnnotationPresent(RolesAllowed.class);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

