/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUpdateWebpack
implements FallibleCommand {
    private final Path webpackOutputPath;
    private final Path resourceOutputPath;
    private final Path flowImportsFilePath;
    private final Path webpackConfigPath;
    private final Path frontendDirectory;
    private final boolean useV14Bootstrapping;
    private final PwaConfiguration pwaConfiguration;
    private final Path resourceFolder;
    private final Path frontendGeneratedFolder;
    private final String buildFolder;

    TaskUpdateWebpack(File frontendDirectory, File webpackConfigFolder, File webpackOutputDirectory, File resourceOutputDirectory, File generatedFlowImports, boolean useV14Bootstrapping, PwaConfiguration pwaConfiguration, String buildFolder) {
        this.frontendDirectory = frontendDirectory.toPath();
        this.webpackOutputPath = webpackOutputDirectory.toPath();
        this.resourceOutputPath = resourceOutputDirectory.toPath();
        this.flowImportsFilePath = generatedFlowImports.toPath();
        this.webpackConfigPath = webpackConfigFolder.toPath();
        this.useV14Bootstrapping = useV14Bootstrapping;
        this.pwaConfiguration = pwaConfiguration;
        this.resourceFolder = new File(webpackOutputDirectory, "VAADIN/static/").toPath();
        this.frontendGeneratedFolder = this.frontendDirectory.resolve("generated/");
        this.buildFolder = buildFolder;
    }

    @Override
    public void execute() {
        try {
            this.createWebpackConfig();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void createWebpackConfig() throws IOException {
        File configFile = new File(this.webpackConfigPath.toFile(), "webpack.config.js");
        if (configFile.exists()) {
            String contents;
            if (!FrontendUtils.isWebpackConfigFile(configFile)) {
                this.log().warn("Flow generated webpack configuration was not mentioned in the configuration file: {}.Please verify that './webpack.generated.js' is used in the merge or remove the file to generate a new one.", (Object)configFile);
            }
            if ((contents = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8)).contains("const merge = require('webpack-merge');")) {
                this.log().debug("Updating " + configFile.getName() + " to new webpack-merge syntax");
                contents = contents.replace("const merge = require('webpack-merge');", "const { merge } = require('webpack-merge');");
                FileUtils.write((File)configFile, (CharSequence)contents, (Charset)StandardCharsets.UTF_8);
            }
        } else {
            URL resource = this.getClass().getClassLoader().getResource("webpack.config.js");
            FileUtils.copyURLToFile((URL)resource, (File)configFile);
            this.log().debug("Created webpack configuration file: '{}'", (Object)configFile);
        }
        File generatedFile = new File(this.webpackConfigPath.toFile(), "webpack.generated.js");
        URL resource = this.getClass().getClassLoader().getResource("webpack.generated.js");
        FileUtils.copyURLToFile((URL)resource, (File)generatedFile);
        List<String> lines = this.modifyWebpackConfig(generatedFile);
        FileUtils.writeLines((File)generatedFile, lines);
    }

    private List<String> modifyWebpackConfig(File generatedFile) throws IOException {
        List lines = FileUtils.readLines((File)generatedFile, (Charset)StandardCharsets.UTF_8);
        List<Pair<String, String>> replacements = this.getReplacements();
        String declaration = "%s = %s;";
        for (int i = 0; i < lines.size(); ++i) {
            for (int j = 0; j < replacements.size(); ++j) {
                Pair<String, String> pair = replacements.get(j);
                if (!((String)lines.get(i)).startsWith(pair.getFirst() + " ")) continue;
                lines.set(i, String.format(declaration, pair.getFirst(), pair.getSecond()));
            }
        }
        return lines;
    }

    private List<Pair<String, String>> getReplacements() {
        return Arrays.asList(new Pair<String, String>("const frontendFolder", this.formatPathResolve(this.getEscapedRelativeWebpackPath(this.frontendDirectory))), new Pair<String, String>("const frontendGeneratedFolder", this.formatPathResolve(this.getEscapedRelativeWebpackPath(this.frontendGeneratedFolder))), new Pair<String, String>("const mavenOutputFolderForFlowBundledFiles", this.formatPathResolve(this.getEscapedRelativeWebpackPath(this.webpackOutputPath))), new Pair<String, String>("const mavenOutputFolderForResourceFiles", this.formatPathResolve(this.getEscapedRelativeWebpackPath(this.resourceOutputPath))), new Pair<String, String>("const fileNameOfTheFlowGeneratedMainEntryPoint", this.formatPathResolve(this.getEscapedRelativeWebpackPath(this.flowImportsFilePath))), new Pair<String, String>("const useClientSideIndexFileForBootstrapping", Boolean.toString(!this.useV14Bootstrapping)), new Pair<String, String>("const clientSideIndexHTML", "'./index.html'"), new Pair<String, String>("const clientSideIndexEntryPoint", this.getClientEntryPoint()), new Pair<String, String>("const pwaEnabled", Boolean.toString(this.pwaConfiguration.isEnabled())), new Pair<String, String>("const offlineEnabled", Boolean.toString(this.pwaConfiguration.isOfflineEnabled())), new Pair<String, String>("const offlinePath", this.getOfflinePath()), new Pair<String, String>("const clientServiceWorkerEntryPoint", this.getClientServiceWorker()), new Pair<String, String>("const flowFrontendFolder", this.formatPathResolve(this.getEscapedRelativeWebpackPath(this.getJarFrontendResourcesFolder()))), new Pair<String, String>("const projectStaticAssetsOutputFolder", this.formatPathResolve(this.getEscapedRelativeWebpackPath(this.resourceFolder))), new Pair<String, String>("const buildDirectory", this.formatPathResolve(this.getEscapedRelativeWebpackPath(Paths.get(this.buildFolder, new String[0])))));
    }

    private Path getJarFrontendResourcesFolder() {
        return this.frontendGeneratedFolder.resolve("jar-resources");
    }

    private String getClientEntryPoint() {
        return String.format("path.resolve(__dirname, '%s', '%s', '%s');", this.getEscapedRelativeWebpackPath(this.frontendDirectory), "generated/", "vaadin.ts");
    }

    private String getClientServiceWorker() {
        boolean exists;
        boolean bl = exists = new File(this.frontendDirectory.toFile(), "sw.ts").exists() || new File(this.frontendDirectory.toFile(), "sw.js").exists();
        if (!exists) {
            Path path = Paths.get(this.getEscapedRelativeWebpackPath(this.webpackConfigPath), this.buildFolder, "sw.ts");
            return this.formatPathResolve(this.getEscapedRelativeWebpackPath(path).replaceFirst("\\.[tj]s$", ""));
        }
        return "'./sw'";
    }

    private String getEscapedRelativeWebpackPath(Path path) {
        if (path.isAbsolute()) {
            return FrontendUtils.getUnixRelativePath(this.webpackConfigPath, path);
        }
        return FrontendUtils.getUnixPath(path);
    }

    private String getOfflinePath() {
        if (this.pwaConfiguration.isOfflinePathEnabled()) {
            return "'" + this.getEscapedRelativeWebpackPath(Paths.get(this.pwaConfiguration.getOfflinePath(), new String[0])) + "'";
        }
        return "'.'";
    }

    private String formatPathResolve(String path) {
        return String.format("path.resolve(__dirname, '%s')", path);
    }

    private Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

