/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.BootstrapListener;
import com.vaadin.flow.server.DependencyFilter;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class ServiceInitEvent
extends EventObject {
    private List<RequestHandler> addedRequestHandlers = new ArrayList<RequestHandler>();
    private List<BootstrapListener> addedBootstrapListeners = new ArrayList<BootstrapListener>();
    private List<IndexHtmlRequestListener> addedIndexHtmlRequestListeners = new ArrayList<IndexHtmlRequestListener>();
    private List<DependencyFilter> addedDependencyFilters = new ArrayList<DependencyFilter>();

    public ServiceInitEvent(VaadinService service) {
        super(service);
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        Objects.requireNonNull(requestHandler, "Request handler cannot be null");
        this.addedRequestHandlers.add(requestHandler);
    }

    @Deprecated
    public void addBootstrapListener(BootstrapListener bootstrapListener) {
        if (!this.getSource().getDeploymentConfiguration().useV14Bootstrap()) {
            throw new IllegalStateException("The BootstrapListener API is not supported in the client-side mode. Please use the IndexHtmlRequestListener API instead, or disable the client-side mode with-Dvaadin.useDeprecatedV14Bootstrapping=true to keep compatibility with V14.");
        }
        Objects.requireNonNull(bootstrapListener, "Bootstrap listener cannot be null");
        this.addedBootstrapListeners.add(bootstrapListener);
    }

    public void addIndexHtmlRequestListener(IndexHtmlRequestListener indexHtmlRequestListener) {
        Objects.requireNonNull(indexHtmlRequestListener, "Index HTML request listener cannot be null");
        this.addedIndexHtmlRequestListeners.add(indexHtmlRequestListener);
    }

    public void addDependencyFilter(DependencyFilter dependencyFilter) {
        Objects.requireNonNull(dependencyFilter, "Dependency filter cannot be null");
        this.addedDependencyFilters.add(dependencyFilter);
    }

    public Stream<RequestHandler> getAddedRequestHandlers() {
        return this.addedRequestHandlers.stream();
    }

    @Deprecated
    public Stream<BootstrapListener> getAddedBootstrapListeners() {
        return this.addedBootstrapListeners.stream();
    }

    public Stream<IndexHtmlRequestListener> getAddedIndexHtmlRequestListeners() {
        return this.addedIndexHtmlRequestListeners.stream();
    }

    public Stream<DependencyFilter> getAddedDependencyFilters() {
        return this.addedDependencyFilters.stream();
    }

    @Override
    public VaadinService getSource() {
        return (VaadinService)super.getSource();
    }
}

