/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import java.io.Serializable;
import java.util.Objects;

public final class PropertyData<P extends Serializable>
implements Serializable {
    private final String name;
    private final Class<P> type;
    private final P defaultValue;
    private final boolean readOnly;

    public PropertyData(String name, Class<P> type, boolean readOnly, P defaultValue) {
        Objects.requireNonNull(name, "Parameter 'name' must not be null!");
        Objects.requireNonNull(type, "Parameter 'type' must not be null!");
        this.name = name;
        this.type = type;
        this.readOnly = readOnly;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public Class<P> getType() {
        return this.type;
    }

    public P getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public PropertyData<P> updateReadOnly(boolean readOnly) {
        return new PropertyData<P>(this.name, this.type, readOnly, this.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropertyData) {
            PropertyData other = (PropertyData)obj;
            return this.name.equals(other.name) && this.type.equals(other.type);
        }
        return false;
    }
}

