/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class TaskGenerateTsDefinitions
extends AbstractTaskClientGenerator {
    private static final String TS_DEFINITIONS = "types.d.ts";
    private final File npmFolder;

    TaskGenerateTsDefinitions(File npmFolder) {
        this.npmFolder = npmFolder;
    }

    @Override
    protected String getFileContent() throws IOException {
        try (InputStream tsDefinitionStream = this.getClass().getResourceAsStream(TS_DEFINITIONS);){
            String string = IOUtils.toString((InputStream)tsDefinitionStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    @Override
    protected File getGeneratedFile() {
        return new File(this.npmFolder, TS_DEFINITIONS);
    }

    @Override
    protected boolean shouldGenerate() {
        File tsDefinitionsFile = new File(this.npmFolder, TS_DEFINITIONS);
        return !tsDefinitionsFile.exists() && new File(this.npmFolder, "tsconfig.json").exists();
    }
}

