/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.Version;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class TaskGenerateIndexTs
extends AbstractTaskClientGenerator {
    private final File frontendDirectory;
    private File generatedImports;
    private final File buildDirectory;

    TaskGenerateIndexTs(File frontendDirectory, File generatedImports, File buildDirectory) {
        this.frontendDirectory = frontendDirectory;
        this.generatedImports = generatedImports;
        this.buildDirectory = buildDirectory;
    }

    @Override
    protected File getGeneratedFile() {
        return new File(new File(this.frontendDirectory, "generated/"), "index.ts");
    }

    @Override
    protected boolean shouldGenerate() {
        File indexTs = new File(this.frontendDirectory, "index.ts");
        File indexJs = new File(this.frontendDirectory, "index.js");
        this.compareActualIndexTsOrJsWithIndexTempalate(indexTs, indexJs);
        return !indexTs.exists() && !indexJs.exists();
    }

    @Override
    protected String getFileContent() throws IOException {
        String indexTemplate;
        try (InputStream indexTsStream = this.getClass().getResourceAsStream("index.ts");){
            indexTemplate = IOUtils.toString((InputStream)indexTsStream, (Charset)StandardCharsets.UTF_8);
        }
        String relativizedImport = TaskGenerateIndexTs.ensureValidRelativePath(FrontendUtils.getUnixRelativePath(this.buildDirectory.toPath(), this.generatedImports.toPath()));
        String generatedDirRelativePathToBuildDir = FrontendUtils.getUnixRelativePath(this.getGeneratedFile().getParentFile().toPath(), this.buildDirectory.toPath());
        relativizedImport = relativizedImport.replaceFirst("^./", generatedDirRelativePathToBuildDir + "/");
        return indexTemplate.replace("[to-be-generated-by-flow]", relativizedImport);
    }

    static String ensureValidRelativePath(String relativePath) {
        if (!((String)relativePath).startsWith(".")) {
            relativePath = "./" + (String)relativePath;
        }
        return relativePath;
    }

    private void compareActualIndexTsOrJsWithIndexTempalate(File indexTs, File indexJs) {
        if (indexTs.exists() || indexJs.exists()) {
            File indexFileExist = indexTs.exists() ? indexTs : indexJs;
            String indexContent = null;
            String indexTemplate = null;
            try {
                indexContent = IOUtils.toString((URI)indexFileExist.toURI(), (Charset)StandardCharsets.UTF_8);
                indexTemplate = this.getFileContent();
            }
            catch (IOException e) {
                TaskGenerateIndexTs.log().warn("Failed to read file content", (Throwable)e);
            }
            if (indexContent != null && !indexContent.equals(indexTemplate)) {
                UsageStatistics.markAsUsed("routing/client", Version.getFullVersion());
            }
        }
    }
}

