/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.webcomponent.WebComponentExporterTagExtractor;
import com.vaadin.flow.server.webcomponent.WebComponentExporterUtils;
import com.vaadin.flow.server.webcomponent.WebComponentGenerator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public final class WebComponentModulesWriter
implements Serializable {
    private WebComponentModulesWriter() {
    }

    private static Set<File> writeWebComponentsToDirectory(Set<Class<?>> exporterClasses, File outputDirectory, boolean compatibilityMode, String themeName) {
        Objects.requireNonNull(exporterClasses, "Parameter 'exporterClasses' must not be null");
        Objects.requireNonNull(outputDirectory, "Parameter 'outputDirectory' must not be null");
        if (!outputDirectory.isDirectory()) {
            throw new IllegalArgumentException(String.format("Path provided by parameter 'outputDirectory' (%s) is not a directory", outputDirectory.getPath()));
        }
        return WebComponentExporterUtils.getFactories(exporterClasses).stream().map(factory -> WebComponentModulesWriter.writeWebComponentToDirectory(factory, outputDirectory, compatibilityMode, themeName)).collect(Collectors.toSet());
    }

    private static File writeWebComponentToDirectory(WebComponentExporterFactory<?> factory, File outputDirectory, boolean compatibilityMode, String themeName) {
        String tag = WebComponentModulesWriter.getTag(factory);
        String fileName = compatibilityMode ? tag + ".html" : tag + ".js";
        Path generatedFile = outputDirectory.toPath().resolve(fileName);
        try {
            FileUtils.forceMkdir((File)generatedFile.getParent().toFile());
            Files.write(generatedFile, Collections.singletonList(WebComponentModulesWriter.generateModule(factory, compatibilityMode, themeName)), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create web component module file '%s'", generatedFile), e);
        }
        return generatedFile.toFile();
    }

    private static String generateModule(WebComponentExporterFactory<? extends Component> factory, boolean compatibilityMode, String themeName) {
        return WebComponentGenerator.generateModule(factory, "../", compatibilityMode, themeName);
    }

    private static String getTag(WebComponentExporterFactory<? extends Component> factory) {
        WebComponentExporterTagExtractor exporterTagExtractor = new WebComponentExporterTagExtractor();
        return exporterTagExtractor.apply(factory);
    }

    public static final class DirectoryWriter
    implements Serializable {
        private static final String WRITE_MODULES_METHOD = "writeWebComponentsToDirectory";

        public static Set<File> generateWebComponentsToDirectory(Class<?> writerClass, Set<Class<?>> exporterClasses, File outputDirectory, boolean compatibilityMode, String themeName) {
            Objects.requireNonNull(writerClass, "Parameter 'writerClassSupplier' must not null");
            Objects.requireNonNull(exporterClasses, "Parameter 'exporterClasses' must not be null");
            Objects.requireNonNull(outputDirectory, "Parameter 'outputDirectory' must not be null");
            for (Class<?> exporterClass : exporterClasses) {
                if (ReflectTools.findClosestCommonClassLoaderAncestor(writerClass.getClassLoader(), exporterClass.getClassLoader()).isPresent()) continue;
                throw new IllegalArgumentException(String.format("Supplied writer '%s' and supplied exporter '%s' have different class loaders, '%s' and '%s', respectively. Writer and exporters must share a class loader.", writerClass.getName(), exporterClass.getName(), writerClass.getClassLoader().getClass().getName(), exporterClass.getClassLoader().getClass().getName()));
            }
            if (!WebComponentModulesWriter.class.getName().equals(writerClass.getName())) {
                throw new IllegalArgumentException("Argument 'writer' should be a class of '" + WebComponentModulesWriter.class.getName() + "' but it is '" + writerClass.getName() + "'");
            }
            Method writeMethod = DirectoryWriter.getMethod(writerClass, WRITE_MODULES_METHOD).orElseThrow(() -> new IllegalStateException(String.format("Could not locate locate method '%s' on the received writer '%s'.", WRITE_MODULES_METHOD, writerClass.getName())));
            try {
                boolean accessible = writeMethod.isAccessible();
                writeMethod.setAccessible(true);
                Set files = (Set)writeMethod.invoke(null, exporterClasses, outputDirectory, compatibilityMode, themeName);
                writeMethod.setAccessible(accessible);
                return files;
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException("Failed to call 'writeWebComponentsToDirectory' via reflection because Java language access control doesn't allow to call it", exception);
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException("Could not write exported web component module because of exception: " + exception.getCause().getMessage(), exception.getCause());
            }
        }

        private static Optional<Method> getMethod(Class<?> writerClass, String methodName) {
            return Stream.of(writerClass.getDeclaredMethods()).filter(method -> method.getName().equals(methodName)).findFirst();
        }
    }
}

