/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.installer;

import com.vaadin.flow.server.frontend.installer.DownloadException;
import com.vaadin.flow.server.frontend.installer.FileDownloader;
import com.vaadin.flow.server.frontend.installer.ProxyConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultFileDownloader
implements FileDownloader {
    public static final String HTTPS_PROTOCOLS = "https.protocols";
    private final ProxyConfig proxyConfig;
    private String userName;
    private String password;

    public DefaultFileDownloader(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    @Override
    public void download(URI downloadURI, File destination, String userName, String password) throws DownloadException {
        this.userName = userName;
        this.password = password;
        String oldProtocols = System.setProperty(HTTPS_PROTOCOLS, "TLSv1.2");
        try {
            if ("file".equalsIgnoreCase(downloadURI.getScheme())) {
                FileUtils.copyFile((File)new File(downloadURI), (File)destination);
            } else {
                this.downloadFile(destination, downloadURI);
            }
        }
        catch (IOException e) {
            throw new DownloadException("Could not download " + downloadURI, e);
        }
        finally {
            if (oldProtocols == null) {
                System.clearProperty(HTTPS_PROTOCOLS);
            } else {
                System.setProperty(HTTPS_PROTOCOLS, oldProtocols);
            }
        }
    }

    private void downloadFile(File destination, URI downloadUri) throws IOException, DownloadException {
        CloseableHttpResponse response = this.execute(downloadUri);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new DownloadException("Got error code " + statusCode + " from the server.");
        }
        new File(FilenameUtils.getFullPathNoEndSeparator((String)destination.toString())).mkdirs();
        HttpEntity responseEntity = response.getEntity();
        long expected = responseEntity.getContentLength();
        try (ReadableByteChannel rbc = Channels.newChannel(responseEntity.getContent());
             FileOutputStream fos = new FileOutputStream(destination);){
            long transferred = fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            if (expected > 0L && transferred != expected) {
                throw new DownloadException("Error downloading from " + downloadUri + ". Expected " + expected + " bytes but got " + transferred);
            }
        }
    }

    private CloseableHttpResponse execute(URI requestUri) throws IOException {
        CloseableHttpResponse response;
        ProxyConfig.Proxy proxy = this.proxyConfig.getProxyForUrl(requestUri.toString());
        if (proxy != null) {
            this.getLogger().info("Downloading via proxy {}", (Object)proxy.toString());
            return this.executeViaProxy(proxy, requestUri);
        }
        this.getLogger().info("No proxy was configured, downloading directly");
        if (this.userName != null && !this.userName.isEmpty() && this.password != null && !this.password.isEmpty()) {
            this.getLogger().info("Using credentials ({})", (Object)this.userName);
            URL aURL = requestUri.toURL();
            HttpClientContext localContext = this.makeLocalContext(aURL);
            CredentialsProvider credentialsProvider = this.makeCredentialsProvider(aURL.getHost(), aURL.getPort(), this.userName, this.password);
            response = this.buildHttpClient(credentialsProvider).execute((HttpUriRequest)new HttpGet(requestUri), (HttpContext)localContext);
        } else {
            response = this.buildHttpClient(null).execute((HttpUriRequest)new HttpGet(requestUri));
        }
        return response;
    }

    private CloseableHttpResponse executeViaProxy(ProxyConfig.Proxy proxy, URI requestUri) throws IOException {
        CloseableHttpClient proxyClient = proxy.useAuthentication() ? this.buildHttpClient(this.makeCredentialsProvider(proxy.host, proxy.port, proxy.username, proxy.password)) : this.buildHttpClient(null);
        HttpHost proxyHttpHost = new HttpHost(proxy.host, proxy.port);
        RequestConfig requestConfig = RequestConfig.custom().setProxy(proxyHttpHost).build();
        HttpGet request = new HttpGet(requestUri);
        request.setConfig(requestConfig);
        return proxyClient.execute((HttpUriRequest)request);
    }

    private CloseableHttpClient buildHttpClient(CredentialsProvider credentialsProvider) {
        return HttpClients.custom().disableContentCompression().useSystemProperties().setDefaultCredentialsProvider(credentialsProvider).build();
    }

    private CredentialsProvider makeCredentialsProvider(String host, int port, String username, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(username, password));
        return credentialsProvider;
    }

    private HttpClientContext makeLocalContext(URL requestUrl) {
        HttpHost target = new HttpHost(requestUrl.getHost(), requestUrl.getPort(), requestUrl.getProtocol());
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(target, (AuthScheme)basicAuth);
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setAuthCache((AuthCache)authCache);
        return localContext;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)"FileDownloader");
    }
}

