/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.PwaIcon;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskGeneratePWAIcons
implements FallibleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskGeneratePWAIcons.class);
    private static final String HEADLESS_PROPERTY = "java.awt.headless";
    private final Path generatedIconsPath;
    private final PwaConfiguration pwaConfiguration;
    private final ClassFinder classFinder;

    public TaskGeneratePWAIcons(Options options, PwaConfiguration pwaConfiguration) {
        this.pwaConfiguration = pwaConfiguration;
        this.generatedIconsPath = options.getWebappResourcesDirectory().toPath().resolve("pwa-icons/");
        this.classFinder = options.getClassFinder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ExecutionFailedException {
        if (!this.pwaConfiguration.isEnabled()) {
            return;
        }
        URL iconURL = this.findIcon(this.pwaConfiguration);
        if (iconURL == null) {
            LOGGER.warn("Skipping PWA icons generation because icon '{}' cannot be found in classpath", (Object)this.pwaConfiguration.getIconPath());
            return;
        }
        String headless = System.getProperty(HEADLESS_PROPERTY);
        if (headless == null) {
            System.setProperty(HEADLESS_PROPERTY, Boolean.TRUE.toString());
        }
        LOGGER.debug("Generating PWA icons from '{}'", (Object)this.pwaConfiguration.getIconPath());
        try {
            BufferedImage baseImage = TaskGeneratePWAIcons.loadBaseImage(iconURL);
            this.createGeneratedIconsFolder();
            ExecutorService executor = Executors.newFixedThreadPool(4);
            CompletableFuture[] iconsGenerators = (CompletableFuture[])PwaRegistry.getIconTemplates(this.pwaConfiguration.getIconPath()).stream().map(icon -> new InternalPwaIcon((PwaIcon)icon, baseImage)).map(this::generateIcon).map(task -> CompletableFuture.runAsync(task, executor)).toArray(CompletableFuture[]::new);
            try {
                CompletableFuture.allOf(iconsGenerators).join();
            }
            catch (CompletionException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof UncheckedIOException) {
                    throw new ExecutionFailedException("PWA icons generation failed", cause.getCause());
                }
                throw new ExecutionFailedException("PWA icons generation failed", cause);
            }
            catch (CancellationException ex) {
                throw new ExecutionFailedException("PWA icons generation failed", ex);
            }
            finally {
                executor.shutdown();
            }
        }
        finally {
            if (headless == null) {
                System.clearProperty(HEADLESS_PROPERTY);
            } else if (!headless.equals(Boolean.TRUE.toString())) {
                System.setProperty(HEADLESS_PROPERTY, headless);
            }
        }
        LOGGER.info("PWA icons generated");
    }

    private void createGeneratedIconsFolder() throws ExecutionFailedException {
        try {
            Path generatedPath = this.generatedIconsPath.resolve(Path.of(this.pwaConfiguration.getIconPath().replace('/', File.separatorChar), new String[0])).getParent();
            Files.createDirectories(generatedPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ExecutionFailedException("Cannot create PWA generated icons folder " + this.generatedIconsPath, e);
        }
    }

    private static BufferedImage loadBaseImage(URL iconURL) throws ExecutionFailedException {
        BufferedImage baseImage;
        try (InputStream inputStream = iconURL.openStream();){
            baseImage = ImageIO.read(inputStream);
        }
        catch (IOException e) {
            throw new ExecutionFailedException("Cannot load PWA icon from " + iconURL, e);
        }
        if (baseImage == null) {
            throw new ExecutionFailedException("Cannot load PWA icon from " + iconURL);
        }
        return baseImage;
    }

    private URL findIcon(PwaConfiguration pwaConfiguration) {
        URL iconURL = this.classFinder.getResource(pwaConfiguration.getIconPath());
        if (iconURL == null) {
            iconURL = this.classFinder.getResource("META-INF/resources/" + pwaConfiguration.getIconPath());
        }
        if (iconURL == null && (iconURL = BootstrapHandler.class.getResource("default-logo.png")) == null) {
            LOGGER.warn("PWA icon '{}' cannot be found in classpath, fallback to default icon.", (Object)pwaConfiguration.getIconPath());
        }
        return iconURL;
    }

    private Runnable generateIcon(InternalPwaIcon icon) {
        Path iconPath = this.generatedIconsPath.resolve(icon.getRelHref().substring(1).replace('/', File.separatorChar));
        return () -> {
            try (OutputStream os = Files.newOutputStream(iconPath, new OpenOption[0]);){
                icon.write(os);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private static class InternalPwaIcon
    extends PwaIcon {
        private final BufferedImage baseImage;

        public InternalPwaIcon(PwaIcon icon, BufferedImage baseImage) {
            super(icon);
            this.baseImage = baseImage;
        }

        @Override
        protected BufferedImage getBaseImage() {
            return this.baseImage;
        }
    }
}

