/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletService;
import java.util.Enumeration;
import java.util.function.Supplier;
import javax.servlet.ServletContext;

public class VaadinServletContext
implements VaadinContext {
    private transient ServletContext context;

    public VaadinServletContext(ServletContext context) {
        this.context = context;
    }

    public ServletContext getContext() {
        return this.context;
    }

    private void ensureServletContext() {
        if (this.getContext() == null && VaadinService.getCurrent() instanceof VaadinServletService) {
            this.context = ((VaadinServletService)VaadinService.getCurrent()).getServlet().getServletContext();
        } else if (this.getContext() == null) {
            throw new IllegalStateException("The underlying ServletContext of VaadinServletContext is null and there is no VaadinServletService to obtain it from.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getAttribute(Class<T> type, Supplier<T> defaultValueSupplier) {
        this.ensureServletContext();
        ServletContext servletContext = this.getContext();
        synchronized (servletContext) {
            Object result = this.getContext().getAttribute(type.getName());
            if (result == null && defaultValueSupplier != null) {
                result = defaultValueSupplier.get();
                this.getContext().setAttribute(type.getName(), result);
            }
            return type.cast(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void setAttribute(Class<T> clazz, T value) {
        if (value == null) {
            this.removeAttribute(clazz);
        } else {
            ServletContext servletContext = this.getContext();
            synchronized (servletContext) {
                this.checkLookupDuplicate(clazz);
                this.getContext().setAttribute(clazz.getName(), value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(Class<?> clazz) {
        ServletContext servletContext = this.getContext();
        synchronized (servletContext) {
            this.checkLookupDuplicate(clazz);
            this.getContext().removeAttribute(clazz.getName());
        }
    }

    @Override
    public Enumeration<String> getContextParameterNames() {
        this.ensureServletContext();
        return this.getContext().getInitParameterNames();
    }

    @Override
    public String getContextParameter(String name) {
        this.ensureServletContext();
        return this.getContext().getInitParameter(name);
    }

    private Object doGetAttribute(Class<?> clazz) {
        this.ensureServletContext();
        return this.getContext().getAttribute(clazz.getName());
    }

    private void checkLookupDuplicate(Class<?> type) {
        Object attribute = this.doGetAttribute(type);
        if (attribute != null && Lookup.class.equals(type)) {
            throw new IllegalArgumentException("The attribute " + Lookup.class + " has been already set once. It's not possible to everride its value");
        }
    }
}

