/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.TaskInstallWebpackPlugins;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;

class WebpackPluginsUtil {
    protected static final String PLUGIN_TARGET = "plugins";

    private WebpackPluginsUtil() {
    }

    protected static List<String> getPlugins() {
        try {
            JsonObject jsonFile = WebpackPluginsUtil.getJsonFile("plugins/webpack-plugins.json");
            if (jsonFile == null) {
                LoggerFactory.getLogger((String)"WebpackPlugins").error("Couldn't locate plugins/webpack-plugins.json, no Webpack plugins for Flow will be installed.If webpack build fails validate flow-server jar content.");
                return Collections.emptyList();
            }
            JsonArray plugins = jsonFile.getArray(PLUGIN_TARGET);
            ArrayList<String> pluginsToInstall = new ArrayList<String>(plugins.length());
            for (int i = 0; i < plugins.length(); ++i) {
                pluginsToInstall.add(plugins.getString(i));
            }
            return pluginsToInstall;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Couldn't load webpack-plugins.json file", ioe);
        }
    }

    protected static JsonObject getJsonFile(String jsonFilePath) throws IOException {
        String jsonString;
        block9: {
            URL urlResource = WebpackPluginsUtil.getResourceUrl(jsonFilePath);
            if (urlResource == null) {
                return null;
            }
            File jsonFile = new File(urlResource.getFile());
            if (!jsonFile.exists()) {
                try (InputStream resourceAsStream = WebpackPluginsUtil.getResourceAsStream(jsonFilePath);){
                    if (resourceAsStream != null) {
                        jsonString = FrontendUtils.streamToString(resourceAsStream);
                        break block9;
                    }
                    JsonObject jsonObject = null;
                    return jsonObject;
                }
            }
            jsonString = FileUtils.readFileToString((File)jsonFile, (Charset)StandardCharsets.UTF_8);
        }
        return Json.parse((String)jsonString);
    }

    protected static URL getResourceUrl(String resource) {
        ClassLoader cl = TaskInstallWebpackPlugins.class.getClassLoader();
        return cl.getResource(resource);
    }

    protected static InputStream getResourceAsStream(String resource) {
        ClassLoader cl = TaskInstallWebpackPlugins.class.getClassLoader();
        return cl.getResourceAsStream(resource);
    }
}

