/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;

public final class LocaleUtil {
    private LocaleUtil() {
    }

    public static Optional<Locale> getExactLocaleMatch(VaadinRequest request, List<Locale> providedLocales) {
        Locale foundLocale = null;
        Enumeration<Locale> locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = locales.nextElement();
            if (!providedLocales.contains(locale)) continue;
            foundLocale = locale;
            break;
        }
        return Optional.ofNullable(foundLocale);
    }

    public static Optional<Locale> getLocaleMatchByLanguage(VaadinRequest request, List<Locale> providedLocales) {
        Locale foundLocale = null;
        Enumeration<Locale> locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = locales.nextElement();
            Optional<Locale> matching = providedLocales.stream().filter(providedLocale -> providedLocale.getLanguage().equals(locale.getLanguage())).findFirst();
            if (!matching.isPresent()) continue;
            foundLocale = matching.get();
            break;
        }
        return Optional.ofNullable(foundLocale);
    }

    public static Optional<I18NProvider> getI18NProvider() {
        return Optional.ofNullable(VaadinService.getCurrent().getInstantiator().getI18NProvider());
    }

    public static Locale getLocale(Supplier<Optional<I18NProvider>> i18NProvider) {
        return Optional.ofNullable(UI.getCurrent()).map(UI::getLocale).or(() -> ((Optional)i18NProvider.get()).map(I18NProvider::getProvidedLocales).flatMap(locales -> locales.stream().findFirst())).orElseGet(Locale::getDefault);
    }
}

