/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.EndpointGeneratorTaskFactory;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendWebComponentGenerator;
import com.vaadin.flow.server.frontend.TaskCopyFrontendFiles;
import com.vaadin.flow.server.frontend.TaskCopyLocalFrontendFiles;
import com.vaadin.flow.server.frontend.TaskCopyTemplateFiles;
import com.vaadin.flow.server.frontend.TaskGenerateBootstrap;
import com.vaadin.flow.server.frontend.TaskGenerateEndpoint;
import com.vaadin.flow.server.frontend.TaskGenerateFeatureFlags;
import com.vaadin.flow.server.frontend.TaskGenerateHilla;
import com.vaadin.flow.server.frontend.TaskGenerateIndexHtml;
import com.vaadin.flow.server.frontend.TaskGenerateIndexTs;
import com.vaadin.flow.server.frontend.TaskGenerateOpenAPI;
import com.vaadin.flow.server.frontend.TaskGeneratePackageJson;
import com.vaadin.flow.server.frontend.TaskGenerateServiceWorker;
import com.vaadin.flow.server.frontend.TaskGenerateTsConfig;
import com.vaadin.flow.server.frontend.TaskGenerateTsDefinitions;
import com.vaadin.flow.server.frontend.TaskGenerateViteDevMode;
import com.vaadin.flow.server.frontend.TaskGenerateWebComponentBootstrap;
import com.vaadin.flow.server.frontend.TaskGenerateWebComponentHtml;
import com.vaadin.flow.server.frontend.TaskInstallWebpackPlugins;
import com.vaadin.flow.server.frontend.TaskNotifyWebpackConfExistenceWhileUsingVite;
import com.vaadin.flow.server.frontend.TaskRunNpmInstall;
import com.vaadin.flow.server.frontend.TaskUpdateImports;
import com.vaadin.flow.server.frontend.TaskUpdatePackages;
import com.vaadin.flow.server.frontend.TaskUpdateSettingsFile;
import com.vaadin.flow.server.frontend.TaskUpdateThemeImport;
import com.vaadin.flow.server.frontend.TaskUpdateVite;
import com.vaadin.flow.server.frontend.TaskUpdateWebpack;
import com.vaadin.flow.server.frontend.UnknownTaskException;
import com.vaadin.flow.server.frontend.installer.Platform;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import elemental.json.JsonObject;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class NodeTasks
implements FallibleCommand {
    private static final String V14_BOOTSTRAPPING_VITE_ERROR_MESSAGE = "\n\n************************************************************************************\n*  Vite build tool is not supported when 'useDeprecatedV14Bootstrapping' is used.  *\n*  Please fallback to Webpack build tool via setting the                           *\n*  'com.vaadin.experimental.webpackForFrontendBuild=true' feature flag             *\n*  in [project-root]/src/main/resources/vaadin-featureflags.properties             *\n*  (you may create the file if not exists) and restart the application.            *\n************************************************************************************\n\n";
    private static final List<Class<? extends FallibleCommand>> commandOrder = Collections.unmodifiableList(Arrays.asList(TaskNotifyWebpackConfExistenceWhileUsingVite.class, TaskGeneratePackageJson.class, TaskGenerateIndexHtml.class, TaskGenerateIndexTs.class, TaskGenerateViteDevMode.class, TaskGenerateTsConfig.class, TaskGenerateTsDefinitions.class, TaskGenerateServiceWorker.class, TaskGenerateOpenAPI.class, TaskGenerateEndpoint.class, TaskGenerateBootstrap.class, TaskGenerateWebComponentHtml.class, TaskGenerateWebComponentBootstrap.class, TaskGenerateFeatureFlags.class, TaskInstallWebpackPlugins.class, TaskUpdatePackages.class, TaskRunNpmInstall.class, TaskGenerateHilla.class, TaskCopyFrontendFiles.class, TaskCopyLocalFrontendFiles.class, TaskUpdateSettingsFile.class, TaskUpdateWebpack.class, TaskUpdateVite.class, TaskUpdateImports.class, TaskUpdateThemeImport.class, TaskCopyTemplateFiles.class));
    private final List<FallibleCommand> commands = new ArrayList<FallibleCommand>();

    public NodeTasks(Options options) {
        ClassFinder.CachedClassFinder classFinder = new ClassFinder.CachedClassFinder(options.classFinder);
        FrontendDependenciesScanner frontendDependencies = null;
        FeatureFlags featureFlags = options.getFeatureFlags();
        if (options.enablePackagesUpdate || options.enableImportsUpdate || options.enableWebpackConfigUpdate) {
            FrontendWebComponentGenerator generator;
            Set<File> webComponents;
            frontendDependencies = new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(!options.useByteCodeScanner, classFinder, options.generateEmbeddableWebComponents, options.useLegacyV14Bootstrap, featureFlags);
            if (options.generateEmbeddableWebComponents && (webComponents = (generator = new FrontendWebComponentGenerator(classFinder)).generateWebComponents(options.generatedFolder, frontendDependencies.getThemeDefinition())).size() > 0) {
                this.commands.add(new TaskGenerateWebComponentHtml(options.frontendDirectory));
                this.commands.add(new TaskGenerateWebComponentBootstrap(options.frontendDirectory, new File(options.generatedFolder, "generated-flow-imports.js")));
            }
            TaskUpdatePackages packageUpdater = null;
            if (options.enablePackagesUpdate && options.jarFrontendResourcesFolder != null) {
                packageUpdater = new TaskUpdatePackages(classFinder, frontendDependencies, options.npmFolder, options.generatedFolder, options.jarFrontendResourcesFolder, options.cleanNpmFiles, options.enablePnpm, options.buildDirectory, featureFlags);
                this.commands.add(packageUpdater);
            }
            if (packageUpdater != null && options.runNpmInstall) {
                this.commands.add(new TaskRunNpmInstall(packageUpdater, options.enablePnpm, options.requireHomeNodeExec, options.nodeVersion, options.nodeDownloadRoot, options.useGlobalPnpm, options.nodeAutoUpdate, options.postinstallPackages));
                this.commands.add(new TaskInstallWebpackPlugins(new File(options.npmFolder, options.buildDirectory)));
            }
        }
        if (options.createMissingPackageJson) {
            TaskGeneratePackageJson packageCreator = new TaskGeneratePackageJson(options.npmFolder, options.generatedFolder, options.buildDirectory, featureFlags);
            this.commands.add(packageCreator);
        }
        if (frontendDependencies != null) {
            this.addGenerateServiceWorkerTask(options, frontendDependencies.getPwaConfiguration());
            this.addGenerateTsConfigTask(options);
        }
        if (options.useLegacyV14Bootstrap) {
            if (!featureFlags.isEnabled(FeatureFlags.WEBPACK)) {
                throw new IllegalStateException(V14_BOOTSTRAPPING_VITE_ERROR_MESSAGE);
            }
        } else {
            TaskGenerateHilla hillaTask;
            this.addBootstrapTasks(options);
            if (options.endpointGeneratedOpenAPIFile != null && featureFlags.isEnabled(FeatureFlags.HILLA_ENGINE) && (hillaTask = options.lookup.lookup(TaskGenerateHilla.class)) != null) {
                hillaTask.configure(options.getNpmFolder(), options.getBuildDirectory());
                this.commands.add(hillaTask);
            } else if (options.endpointGeneratedOpenAPIFile != null && options.endpointSourceFolder != null && options.endpointSourceFolder.exists()) {
                this.addEndpointServicesTasks(options);
            }
            this.commands.add(new TaskGenerateBootstrap(frontendDependencies, options.frontendDirectory, options.productionMode));
            this.commands.add(new TaskGenerateFeatureFlags(options.frontendDirectory, featureFlags));
        }
        if (options.jarFiles != null && options.jarFrontendResourcesFolder != null) {
            this.commands.add(new TaskCopyFrontendFiles(options.jarFrontendResourcesFolder, options.jarFiles));
        }
        if (options.localResourcesFolder != null && options.jarFrontendResourcesFolder != null) {
            this.commands.add(new TaskCopyLocalFrontendFiles(options.jarFrontendResourcesFolder, options.localResourcesFolder));
        }
        if (!featureFlags.isEnabled(FeatureFlags.WEBPACK)) {
            PwaConfiguration pwa;
            String themeName = "";
            if (frontendDependencies != null) {
                if (frontendDependencies.getThemeDefinition() != null) {
                    themeName = frontendDependencies.getThemeDefinition().getName();
                }
                pwa = frontendDependencies.getPwaConfiguration();
            } else {
                pwa = new PwaConfiguration();
            }
            this.commands.add(new TaskNotifyWebpackConfExistenceWhileUsingVite(options.npmFolder));
            this.commands.add(new TaskUpdateSettingsFile(options, themeName, pwa));
            this.commands.add(new TaskUpdateVite(options.npmFolder, options.buildDirectory));
        } else if (options.enableWebpackConfigUpdate) {
            PwaConfiguration pwaConfiguration = frontendDependencies.getPwaConfiguration();
            this.commands.add(new TaskUpdateWebpack(options.frontendDirectory, options.npmFolder, options.webappResourcesDirectory, options.resourceOutputDirectory, new File(options.generatedFolder, "generated-flow-imports.js"), options.useLegacyV14Bootstrap, pwaConfiguration, options.buildDirectory));
        }
        if (options.enableImportsUpdate) {
            this.commands.add(new TaskUpdateImports(classFinder, frontendDependencies, finder -> this.getFallbackScanner(options, (ClassFinder)finder, featureFlags), options.npmFolder, options.generatedFolder, options.frontendDirectory, options.tokenFile, options.tokenFileData, options.enablePnpm, options.buildDirectory, options.productionMode, options.useLegacyV14Bootstrap, featureFlags));
            this.commands.add(new TaskUpdateThemeImport(options.npmFolder, frontendDependencies.getThemeDefinition(), options.frontendDirectory));
        }
        if (options.copyTemplates) {
            this.commands.add(new TaskCopyTemplateFiles(classFinder, options.npmFolder, options.resourceOutputDirectory, options.frontendDirectory));
        }
    }

    private void addBootstrapTasks(Options builder) {
        TaskGenerateIndexHtml taskGenerateIndexHtml = new TaskGenerateIndexHtml(builder.frontendDirectory);
        this.commands.add(taskGenerateIndexHtml);
        File buildDirectory = new File(builder.npmFolder, builder.buildDirectory);
        TaskGenerateIndexTs taskGenerateIndexTs = new TaskGenerateIndexTs(builder.frontendDirectory, new File(builder.generatedFolder, "generated-flow-imports.js"), buildDirectory);
        this.commands.add(taskGenerateIndexTs);
        if (!builder.getFeatureFlags().isEnabled(FeatureFlags.WEBPACK) && !builder.productionMode) {
            this.commands.add(new TaskGenerateViteDevMode(builder.frontendDirectory));
        }
    }

    private void addGenerateTsConfigTask(Options builder) {
        TaskGenerateTsConfig taskGenerateTsConfig = new TaskGenerateTsConfig(builder.npmFolder, builder.getFeatureFlags());
        this.commands.add(taskGenerateTsConfig);
        TaskGenerateTsDefinitions taskGenerateTsDefinitions = new TaskGenerateTsDefinitions(builder.npmFolder);
        this.commands.add(taskGenerateTsDefinitions);
    }

    private void addGenerateServiceWorkerTask(Options builder, PwaConfiguration pwaConfiguration) {
        File outputDirectory = new File(builder.npmFolder, builder.buildDirectory);
        if (pwaConfiguration.isEnabled()) {
            this.commands.add(new TaskGenerateServiceWorker(builder.frontendDirectory, outputDirectory));
        }
    }

    private void addEndpointServicesTasks(Options builder) {
        Lookup lookup = builder.lookup;
        EndpointGeneratorTaskFactory endpointGeneratorTaskFactory = lookup.lookup(EndpointGeneratorTaskFactory.class);
        if (endpointGeneratorTaskFactory != null) {
            TaskGenerateOpenAPI taskGenerateOpenAPI = endpointGeneratorTaskFactory.createTaskGenerateOpenAPI(builder.applicationProperties, builder.endpointSourceFolder, builder.classFinder.getClassLoader(), builder.endpointGeneratedOpenAPIFile);
            this.commands.add(taskGenerateOpenAPI);
            if (builder.frontendGeneratedFolder != null) {
                TaskGenerateEndpoint taskGenerateEndpoint = endpointGeneratorTaskFactory.createTaskGenerateEndpoint(builder.applicationProperties, builder.endpointGeneratedOpenAPIFile, builder.frontendGeneratedFolder, builder.frontendDirectory);
                this.commands.add(taskGenerateEndpoint);
            }
        }
    }

    private FrontendDependenciesScanner getFallbackScanner(Options builder, ClassFinder finder, FeatureFlags featureFlags) {
        if (builder.useByteCodeScanner) {
            return new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(true, finder, builder.generateEmbeddableWebComponents, builder.useLegacyV14Bootstrap, featureFlags, true);
        }
        return null;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        this.sortCommands(this.commands);
        for (FallibleCommand command : this.commands) {
            command.execute();
        }
    }

    private void sortCommands(List<FallibleCommand> commandList) {
        commandList.sort((c1, c2) -> {
            int indexOf1 = this.getIndex((FallibleCommand)c1);
            int indexOf2 = this.getIndex((FallibleCommand)c2);
            if (indexOf1 == -1 || indexOf2 == -1) {
                return 0;
            }
            return indexOf1 - indexOf2;
        });
    }

    private int getIndex(FallibleCommand command) {
        int index = commandOrder.indexOf(command.getClass());
        if (index != -1) {
            return index;
        }
        for (int i = 0; i < commandOrder.size(); ++i) {
            if (!commandOrder.get(i).isAssignableFrom(command.getClass())) continue;
            return i;
        }
        throw new UnknownTaskException(command);
    }

    public static class Options
    implements Serializable {
        private final String buildDirectory;
        private final ClassFinder classFinder;
        private final File frontendDirectory;
        private File webappResourcesDirectory = null;
        private File resourceOutputDirectory = null;
        private boolean enablePackagesUpdate = false;
        private boolean createMissingPackageJson = false;
        private boolean enableImportsUpdate = false;
        private boolean enableWebpackConfigUpdate = false;
        private boolean runNpmInstall = false;
        private Set<File> jarFiles = null;
        private boolean generateEmbeddableWebComponents = true;
        private boolean cleanNpmFiles = false;
        private File jarFrontendResourcesFolder = null;
        private File localResourcesFolder = null;
        private boolean useByteCodeScanner = false;
        private JsonObject tokenFileData;
        private File tokenFile;
        private boolean enablePnpm = false;
        private boolean useGlobalPnpm = false;
        private File endpointSourceFolder;
        private File endpointGeneratedOpenAPIFile;
        private File applicationProperties;
        private File frontendGeneratedFolder;
        private boolean requireHomeNodeExec;
        private boolean copyTemplates = false;
        private final File npmFolder;
        private final File generatedFolder;
        private boolean useLegacyV14Bootstrap;
        private String nodeVersion = "v18.12.1";
        private URI nodeDownloadRoot = URI.create(Platform.guess().getNodeDownloadRoot());
        private boolean nodeAutoUpdate = false;
        private Lookup lookup;
        private boolean productionMode = true;
        private File javaResourceFolder;
        private List<String> postinstallPackages;

        public Options(Lookup lookup, File npmFolder, String buildDirectory) {
            this(lookup, npmFolder, new File(npmFolder, System.getProperty("vaadin.frontend.generated.folder", Paths.get(buildDirectory, "frontend/").toString())), buildDirectory);
        }

        public Options(Lookup lookup, File npmFolder, File generatedPath, String buildDirectory) {
            this(lookup, npmFolder, generatedPath, new File(npmFolder, System.getProperty("vaadin.frontend.frontend.folder", "./frontend/")), buildDirectory);
        }

        public Options(Lookup lookup, File npmFolder, File generatedPath, File frontendDirectory, String buildDirectory) {
            this.lookup = lookup;
            this.classFinder = lookup.lookup(ClassFinder.class);
            this.npmFolder = npmFolder;
            this.generatedFolder = generatedPath.isAbsolute() ? generatedPath : new File(npmFolder, generatedPath.getPath());
            this.frontendDirectory = frontendDirectory.isAbsolute() ? frontendDirectory : new File(npmFolder, frontendDirectory.getPath());
            this.buildDirectory = buildDirectory;
        }

        public Options withWebpack(File webappResourcesDirectory, File resourceOutputDirectory) {
            this.enableWebpackConfigUpdate = true;
            this.webappResourcesDirectory = webappResourcesDirectory;
            this.resourceOutputDirectory = resourceOutputDirectory;
            return this;
        }

        public Options enablePackagesUpdate(boolean enablePackagesUpdate) {
            this.enablePackagesUpdate = enablePackagesUpdate;
            return this;
        }

        Options enableNpmFileCleaning(boolean forceClean) {
            this.cleanNpmFiles = forceClean;
            return this;
        }

        public Options enableImportsUpdate(boolean enableImportsUpdate) {
            this.enableImportsUpdate = enableImportsUpdate;
            this.createMissingPackageJson = enableImportsUpdate || this.createMissingPackageJson;
            return this;
        }

        public Options runNpmInstall(boolean runNpmInstall) {
            this.runNpmInstall = runNpmInstall;
            return this;
        }

        public Options withJarFrontendResourcesFolder(File jarFrontendResourcesFolder) {
            this.jarFrontendResourcesFolder = jarFrontendResourcesFolder.isAbsolute() ? jarFrontendResourcesFolder : new File(this.npmFolder, jarFrontendResourcesFolder.getPath());
            return this;
        }

        public Options copyResources(Set<File> jars) {
            Objects.requireNonNull(jars, "Parameter 'jars' must not be null!");
            this.jarFiles = jars;
            return this;
        }

        public Options copyTemplates(boolean copyTemplates) {
            this.copyTemplates = copyTemplates;
            return this;
        }

        public Options withEmbeddableWebComponents(boolean generateEmbeddableWebComponents) {
            this.generateEmbeddableWebComponents = generateEmbeddableWebComponents;
            return this;
        }

        public Options createMissingPackageJson(boolean create) {
            this.createMissingPackageJson = create;
            return this;
        }

        public Options copyLocalResources(File localResourcesFolder) {
            this.localResourcesFolder = localResourcesFolder;
            return this;
        }

        public Options useV14Bootstrap(boolean useDeprecatedV14Bootstrapping) {
            this.useLegacyV14Bootstrap = useDeprecatedV14Bootstrapping;
            return this;
        }

        public Options withFrontendGeneratedFolder(File frontendGeneratedFolder) {
            this.frontendGeneratedFolder = frontendGeneratedFolder;
            return this;
        }

        public Options withApplicationProperties(File applicationProperties) {
            this.applicationProperties = applicationProperties;
            return this;
        }

        public Options withEndpointGeneratedOpenAPIFile(File endpointGeneratedOpenAPIFile) {
            this.endpointGeneratedOpenAPIFile = endpointGeneratedOpenAPIFile;
            return this;
        }

        public Options withEndpointSourceFolder(File endpointSourceFolder) {
            this.endpointSourceFolder = endpointSourceFolder;
            return this;
        }

        public Options useByteCodeScanner(boolean byteCodeScanner) {
            this.useByteCodeScanner = byteCodeScanner;
            return this;
        }

        public Options populateTokenFileData(JsonObject object) {
            this.tokenFileData = object;
            return this;
        }

        public Options withTokenFile(File tokenFile) {
            this.tokenFile = tokenFile;
            return this;
        }

        public Options enablePnpm(boolean enable) {
            this.enablePnpm = enable;
            return this;
        }

        public Options useGlobalPnpm(boolean useGlobalPnpm) {
            this.useGlobalPnpm = useGlobalPnpm;
            return this;
        }

        public Options withHomeNodeExecRequired(boolean requireHomeNodeExec) {
            this.requireHomeNodeExec = requireHomeNodeExec;
            return this;
        }

        public Options withNodeVersion(String nodeVersion) {
            this.nodeVersion = Objects.requireNonNull(nodeVersion);
            return this;
        }

        public Options withNodeDownloadRoot(URI nodeDownloadRoot) {
            this.nodeDownloadRoot = Objects.requireNonNull(nodeDownloadRoot);
            return this;
        }

        public Options withProductionMode(boolean productionMode) {
            this.productionMode = productionMode;
            return this;
        }

        public Options setNodeAutoUpdate(boolean update) {
            this.nodeAutoUpdate = update;
            return this;
        }

        public File getNpmFolder() {
            return this.npmFolder;
        }

        public File getGeneratedFolder() {
            return this.generatedFolder;
        }

        public File getWebappResourcesDirectory() {
            return this.webappResourcesDirectory;
        }

        public File getFrontendDirectory() {
            return this.frontendDirectory;
        }

        public String getBuildDirectory() {
            return this.buildDirectory;
        }

        public Options setJavaResourceFolder(File javaResourceFolder) {
            this.javaResourceFolder = javaResourceFolder;
            return this;
        }

        protected FeatureFlags getFeatureFlags() {
            FeatureFlags featureFlags = new FeatureFlags(this.lookup);
            if (this.javaResourceFolder != null) {
                featureFlags.setPropertiesLocation(this.javaResourceFolder);
            }
            return featureFlags;
        }

        public Options withPostinstallPackages(List<String> postinstallPackages) {
            this.postinstallPackages = postinstallPackages;
            return this;
        }

        public File getJarFrontendResourcesFolder() {
            return this.jarFrontendResourcesFolder;
        }
    }
}

