/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HeartbeatEvent;
import com.vaadin.flow.component.HeartbeatListener;
import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.internal.ComponentMetaData;
import com.vaadin.flow.component.internal.DependencyList;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternalUpdater;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.dom.impl.BasicElementStateProvider;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.ConstantPool;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.UrlUtil;
import com.vaadin.flow.internal.nodefeature.LoadingIndicatorConfigurationMap;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.PollConfigurationMap;
import com.vaadin.flow.internal.nodefeature.PushConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ReconnectDialogConfigurationMap;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveListener;
import com.vaadin.flow.router.ListenerPriority;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AfterNavigationHandler;
import com.vaadin.flow.router.internal.BeforeEnterHandler;
import com.vaadin.flow.router.internal.BeforeLeaveHandler;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.PushConnection;
import com.vaadin.flow.server.frontend.FallbackChunk;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.communication.PushMode;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIInternals
implements Serializable {
    private int lastProcessedClientToServerId = -1;
    private int serverSyncId = 0;
    private final StateTree stateTree;
    private PushConnection pushConnection = null;
    private long lastHeartbeatTimestamp = System.currentTimeMillis();
    private List<PendingJavaScriptInvocation> pendingJsInvocations = new ArrayList<PendingJavaScriptInvocation>();
    private final UI ui;
    private final UIInternalUpdater internalsHandler;
    private String title;
    private String appShellTitle;
    private PendingJavaScriptInvocation pendingTitleUpdateCanceler;
    private Location viewLocation = new Location("");
    private ArrayList<HasElement> routerTargetChain = new ArrayList();
    private HashMap<Class<?>, List<?>> listeners = new HashMap();
    private Location lastHandledNavigation = null;
    private BeforeLeaveEvent.ContinueNavigationAction continueNavigationAction = null;
    private volatile VaadinSession session;
    private final DependencyList dependencyList = new DependencyList();
    private final ConstantPool constantPool = new ConstantPool();
    private byte[] lastProcessedMessageHash = null;
    private String contextRootRelativePath;
    private String appId;
    private Component activeDragSourceComponent;
    private ExtendedClientDetails extendedClientDetails = null;
    private boolean isFallbackChunkLoaded;
    private ArrayDeque<Component> modalComponentStack;

    public UIInternals(UI ui) {
        this(ui, new UIInternalUpdater(){});
    }

    public UIInternals(UI ui, UIInternalUpdater internalsHandler) {
        this.internalsHandler = internalsHandler;
        this.ui = ui;
        this.stateTree = new StateTree(this, UIInternals.getRootNodeFeatures());
    }

    public StateTree getStateTree() {
        return this.stateTree;
    }

    public int getLastProcessedClientToServerId() {
        return this.lastProcessedClientToServerId;
    }

    public byte[] getLastProcessedMessageHash() {
        return this.lastProcessedMessageHash;
    }

    public void setLastProcessedClientToServerId(int lastProcessedClientToServerId, byte[] lastProcessedMessageHash) {
        this.lastProcessedClientToServerId = lastProcessedClientToServerId;
        this.lastProcessedMessageHash = lastProcessedMessageHash;
    }

    public int getServerSyncId() {
        return this.serverSyncId;
    }

    public void incrementServerId() {
        ++this.serverSyncId;
        if (UIInternals.getLogger().isTraceEnabled()) {
            UIInternals.getLogger().trace("Increment syncId:\n{}", (Object)Arrays.stream(Thread.currentThread().getStackTrace()).skip(1L).map(String::valueOf).collect(Collectors.joining(System.lineSeparator())));
        }
    }

    public long getLastHeartbeatTimestamp() {
        return this.lastHeartbeatTimestamp;
    }

    public void setLastHeartbeatTimestamp(long lastHeartbeat) {
        this.lastHeartbeatTimestamp = lastHeartbeat;
        HeartbeatEvent heartbeatEvent = new HeartbeatEvent(this.ui, lastHeartbeat);
        this.getListeners(HeartbeatListener.class).forEach(listener -> listener.heartbeat(heartbeatEvent));
    }

    private static Class<? extends NodeFeature>[] getRootNodeFeatures() {
        ArrayList<Class<? extends NodeFeature>> features = new ArrayList<Class<? extends NodeFeature>>(BasicElementStateProvider.getFeatures());
        features.add(PushConfigurationMap.class);
        features.add(PollConfigurationMap.class);
        features.add(ReconnectDialogConfigurationMap.class);
        features.add(LoadingIndicatorConfigurationMap.class);
        assert (features.size() == new HashSet<Class<? extends NodeFeature>>(features).size()) : "There are duplicates";
        return features.toArray(new Class[0]);
    }

    private static String getSessionDetails(VaadinSession session) {
        if (session == null) {
            return null;
        }
        return session + " for " + session.getService().getServiceName();
    }

    public void setSession(VaadinSession session) {
        if (session == null && this.session == null) {
            throw new IllegalStateException("Session should never be set to null when UI.session is already null");
        }
        if (session != null && this.session != null) {
            throw new IllegalStateException("Session has already been set. Old session: " + UIInternals.getSessionDetails(this.session) + ". New session: " + UIInternals.getSessionDetails(session) + ".");
        }
        if (session == null) {
            this.ui.getElement().getNode().setParent(null);
            this.ui.getPushConfiguration().setPushMode(PushMode.DISABLED);
            this.setPushConnection(null);
        }
        this.session = session;
        if (session != null) {
            ComponentUtil.onComponentAttach(this.ui, true);
        }
    }

    public PushConnection getPushConnection() {
        assert (!this.ui.getPushConfiguration().getPushMode().isEnabled() || this.pushConnection != null);
        return this.pushConnection;
    }

    public void setPushConnection(PushConnection pushConnection) {
        assert (pushConnection == null ^ this.ui.getPushConfiguration().getPushMode().isEnabled());
        if (pushConnection == this.pushConnection) {
            return;
        }
        if (this.pushConnection != null && this.pushConnection.isConnected()) {
            this.pushConnection.disconnect();
        }
        this.pushConnection = pushConnection;
    }

    public Registration addBeforeEnterListener(BeforeEnterListener listener) {
        return this.addListener(BeforeEnterHandler.class, listener);
    }

    public Registration addBeforeLeaveListener(BeforeLeaveListener listener) {
        return this.addListener(BeforeLeaveHandler.class, listener);
    }

    public Registration addAfterNavigationListener(AfterNavigationListener listener) {
        return this.addListener(AfterNavigationHandler.class, listener);
    }

    public Registration addHeartbeatListener(HeartbeatListener listener) {
        return this.addListener(HeartbeatListener.class, listener);
    }

    private <E> Registration addListener(Class<E> handler, E listener) {
        this.session.checkHasLock();
        List list = this.listeners.computeIfAbsent(handler, key -> new ArrayList());
        list.add(listener);
        list.sort((o1, o2) -> {
            Class<?> o1Class = o1.getClass();
            Class<?> o2Class = o2.getClass();
            ListenerPriority listenerPriority1 = o1Class.getAnnotation(ListenerPriority.class);
            ListenerPriority listenerPriority2 = o2Class.getAnnotation(ListenerPriority.class);
            int priority1 = listenerPriority1 != null ? listenerPriority1.value() : 0;
            int priority2 = listenerPriority2 != null ? listenerPriority2.value() : 0;
            return Integer.compare(priority2, priority1);
        });
        return () -> list.remove(listener);
    }

    public <E> List<E> getListeners(Class<E> handler) {
        List registeredListeners = this.listeners.computeIfAbsent(handler, key -> new ArrayList());
        return Collections.unmodifiableList(new ArrayList(registeredListeners));
    }

    public void addJavaScriptInvocation(PendingJavaScriptInvocation invocation) {
        this.session.checkHasLock();
        this.pendingJsInvocations.add(invocation);
    }

    public List<PendingJavaScriptInvocation> dumpPendingJavaScriptInvocations() {
        this.pendingTitleUpdateCanceler = null;
        if (this.pendingJsInvocations.isEmpty()) {
            return Collections.emptyList();
        }
        List<PendingJavaScriptInvocation> currentList = this.getPendingJavaScriptInvocations().peek(PendingJavaScriptInvocation::setSentToBrowser).collect(Collectors.toList());
        this.pendingJsInvocations = new ArrayList<PendingJavaScriptInvocation>();
        return currentList;
    }

    Stream<PendingJavaScriptInvocation> getPendingJavaScriptInvocations() {
        return this.pendingJsInvocations.stream().filter(invocation -> !invocation.isCanceled());
    }

    public void setTitle(String title) {
        assert (title != null);
        JavaScriptInvocation invocation = new JavaScriptInvocation("document.title = $0", new Serializable[]{title});
        this.pendingTitleUpdateCanceler = new PendingJavaScriptInvocation(this.getStateTree().getRootNode(), invocation);
        this.addJavaScriptInvocation(this.pendingTitleUpdateCanceler);
        this.title = title;
    }

    public void setAppShellTitle(String appShellTitle) {
        this.appShellTitle = appShellTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAppShellTitle() {
        return this.appShellTitle;
    }

    public boolean cancelPendingTitleUpdate() {
        if (this.pendingTitleUpdateCanceler == null) {
            return false;
        }
        boolean result = this.pendingTitleUpdateCanceler.cancelExecution();
        this.pendingTitleUpdateCanceler = null;
        return result;
    }

    public void showRouteTarget(Location viewLocation, Component target, List<RouterLayout> layouts) {
        assert (target != null);
        assert (viewLocation != null);
        HasElement oldRoot = null;
        if (!this.routerTargetChain.isEmpty()) {
            oldRoot = this.routerTargetChain.get(this.routerTargetChain.size() - 1);
        }
        this.viewLocation = viewLocation;
        IdentityHashMap<RouterLayout, HasElement> oldChildren = new IdentityHashMap<RouterLayout, HasElement>();
        for (int i = 0; i < this.routerTargetChain.size() - 1; ++i) {
            HasElement child = this.routerTargetChain.get(i);
            RouterLayout parent = (RouterLayout)this.routerTargetChain.get(i + 1);
            oldChildren.put(parent, child);
        }
        this.routerTargetChain = new ArrayList();
        this.routerTargetChain.add(target);
        if (layouts != null) {
            this.routerTargetChain.addAll(layouts);
        }
        if (oldRoot != null && !this.routerTargetChain.contains(oldRoot)) {
            oldChildren.forEach(RouterLayout::removeRouterLayoutContent);
        }
        HasElement previous = null;
        for (HasElement current : this.routerTargetChain) {
            if (previous != null || oldChildren.containsKey(current)) {
                HasElement newContent;
                assert (current instanceof RouterLayout) : "All parts of the chain except the first must implement " + RouterLayout.class.getSimpleName();
                HasElement oldContent = (HasElement)oldChildren.get(current);
                if (oldContent != (newContent = previous)) {
                    RouterLayout layout = (RouterLayout)current;
                    this.removeChildrenContentFromRouterLayout(layout, oldChildren);
                    layout.showRouterLayoutContent(newContent);
                }
            }
            previous = current;
        }
        HasElement root = previous;
        if (root == null) {
            throw new IllegalArgumentException("Root can't be null here since we know there's at least one item in the chain");
        }
        this.configurePush(root);
        this.internalsHandler.updateRoot(this.ui, oldRoot, root);
    }

    public void moveElementsFrom(UI otherUI) {
        this.internalsHandler.moveToNewUI(otherUI, this.ui);
    }

    public List<HasElement> getActiveRouterTargetsChain() {
        return Collections.unmodifiableList(this.routerTargetChain);
    }

    public Location getActiveViewLocation() {
        return this.viewLocation;
    }

    public VaadinSession getSession() {
        return this.session;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)UIInternals.class.getName());
    }

    public DependencyList getDependencyList() {
        return this.dependencyList;
    }

    public void addComponentDependencies(Class<? extends Component> componentClass) {
        Page page = this.ui.getPage();
        ComponentMetaData.DependencyInfo dependencies = ComponentUtil.getDependencies(this.session.getService(), componentClass);
        this.addExternalDependencies(dependencies);
        this.addFallbackDependencies(dependencies);
        dependencies.getStyleSheets().forEach(styleSheet -> page.addStyleSheet(styleSheet.value(), styleSheet.loadMode()));
    }

    private void addFallbackDependencies(ComponentMetaData.DependencyInfo dependency) {
        if (this.isFallbackChunkLoaded) {
            return;
        }
        VaadinContext context = this.ui.getSession().getService().getContext();
        FallbackChunk chunk = context.getAttribute(FallbackChunk.class);
        if (chunk == null) {
            if (UIInternals.getLogger().isDebugEnabled()) {
                UIInternals.getLogger().debug("Fallback chunk is not available, skipping fallback dependencies load");
            }
            return;
        }
        Set<String> modules = chunk.getModules();
        Set<FallbackChunk.CssImportData> cssImportsData = chunk.getCssImports();
        if (modules.isEmpty() && cssImportsData.isEmpty()) {
            UIInternals.getLogger().debug("Fallback chunk is empty, skipping fallback dependencies load");
            return;
        }
        List<CssImport> cssImports = dependency.getCssImports();
        List<JavaScript> javaScripts = dependency.getJavaScripts();
        List<JsModule> jsModules = dependency.getJsModules();
        if (jsModules.stream().map(JsModule::value).anyMatch(modules::contains)) {
            this.loadFallbackChunk();
            return;
        }
        if (javaScripts.stream().map(JavaScript::value).anyMatch(modules::contains)) {
            this.loadFallbackChunk();
            return;
        }
        if (cssImports.stream().map(this::buildData).anyMatch(cssImportsData::contains)) {
            this.loadFallbackChunk();
            return;
        }
    }

    private FallbackChunk.CssImportData buildData(CssImport imprt) {
        Function<String, String> converter = str -> str.isEmpty() ? null : str;
        return new FallbackChunk.CssImportData(converter.apply(imprt.value()), converter.apply(imprt.id()), converter.apply(imprt.include()), converter.apply(imprt.themeFor()));
    }

    private void loadFallbackChunk() {
        if (this.isFallbackChunkLoaded) {
            return;
        }
        this.ui.getPage().addDynamicImport("var fallback = window.Vaadin.Flow.fallbacks['" + this.getAppId() + "']; if (fallback.loadFallback) { return fallback.loadFallback(); } else { return Promise.resolve(0); }");
        this.isFallbackChunkLoaded = true;
    }

    private void addExternalDependencies(ComponentMetaData.DependencyInfo dependency) {
        Page page = this.ui.getPage();
        dependency.getJavaScripts().stream().filter(js -> UrlUtil.isExternal(js.value())).forEach(js -> page.addJavaScript(js.value(), js.loadMode()));
        dependency.getJsModules().stream().filter(js -> UrlUtil.isExternal(js.value())).forEach(js -> page.addJsModule(js.value()));
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Location getLastHandledLocation() {
        return this.lastHandledNavigation;
    }

    public void setLastHandledNavigation(Location location) {
        this.lastHandledNavigation = location;
    }

    public boolean hasLastHandledLocation() {
        return this.lastHandledNavigation != null;
    }

    public void clearLastHandledNavigation() {
        this.setLastHandledNavigation(null);
    }

    public BeforeLeaveEvent.ContinueNavigationAction getContinueNavigationAction() {
        return this.continueNavigationAction;
    }

    public void setContinueNavigationAction(BeforeLeaveEvent.ContinueNavigationAction continueNavigationAction) {
        this.continueNavigationAction = continueNavigationAction;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public Router getRouter() {
        return this.ui.isNavigationSupported() ? this.getSession().getService().getRouter() : null;
    }

    public boolean isDirty() {
        return this.getStateTree().isDirty() || this.getPendingJavaScriptInvocations().count() != 0L;
    }

    public void setContextRoot(String contextRootRelativePath) {
        this.contextRootRelativePath = contextRootRelativePath;
    }

    public String getContextRootRelativePath() {
        return this.contextRootRelativePath;
    }

    public void setActiveDragSourceComponent(Component activeDragSourceComponent) {
        this.activeDragSourceComponent = activeDragSourceComponent;
    }

    public Component getActiveDragSourceComponent() {
        return this.activeDragSourceComponent;
    }

    public UI getUI() {
        return this.ui;
    }

    public ExtendedClientDetails getExtendedClientDetails() {
        return this.extendedClientDetails;
    }

    public void setExtendedClientDetails(ExtendedClientDetails details) {
        this.extendedClientDetails = details;
    }

    public boolean hasModalComponent() {
        return this.modalComponentStack != null && !this.modalComponentStack.isEmpty();
    }

    public Component getActiveModalComponent() {
        if (this.hasModalComponent()) {
            return this.modalComponentStack.peek();
        }
        return null;
    }

    public void setChildModal(Component child) {
        if (this.modalComponentStack == null) {
            this.modalComponentStack = new ArrayDeque();
        } else if (this.isTopMostModal(child)) {
            return;
        }
        ElementUtil.setIgnoreParentInert(child.getElement(), true);
        if (this.modalComponentStack.isEmpty()) {
            ElementUtil.setInert(this.ui.getElement(), true);
        } else {
            ElementUtil.setIgnoreParentInert(this.modalComponentStack.peek().getElement(), false);
        }
        boolean needsListener = !this.modalComponentStack.remove(child);
        this.modalComponentStack.push(child);
        if (needsListener) {
            AtomicReference<Registration> registrationCombination = new AtomicReference<Registration>();
            Registration componentRemoval = () -> this.setChildModeless(child);
            Registration listenerRegistration = child.getElement().addDetachListener(event -> ((Registration)registrationCombination.get()).remove());
            registrationCombination.set(Registration.combine(componentRemoval, listenerRegistration));
        }
    }

    public void setChildModeless(Component child) {
        if (this.modalComponentStack == null) {
            return;
        }
        boolean isTopmostModal = this.isTopMostModal(child);
        if (this.modalComponentStack.remove(child) && isTopmostModal) {
            ElementUtil.setIgnoreParentInert(child.getElement(), false);
            if (this.modalComponentStack.isEmpty()) {
                ElementUtil.setInert(this.ui.getElement(), false);
            } else {
                ElementUtil.setIgnoreParentInert(this.modalComponentStack.peek().getElement(), true);
            }
        }
    }

    private boolean isTopMostModal(Component child) {
        return !this.modalComponentStack.isEmpty() && this.modalComponentStack.peek() == child;
    }

    private void configurePush(HasElement root) {
        DeploymentConfiguration deploymentConfiguration = this.getSession().getService().getDeploymentConfiguration();
        if (!deploymentConfiguration.useV14Bootstrap()) {
            return;
        }
        PushConfiguration pushConfiguration = this.ui.getPushConfiguration();
        Optional<Push> push = AnnotationReader.getAnnotationFor(root.getClass(), Push.class);
        PushMode pushMode = push.map(Push::value).orElseGet(deploymentConfiguration::getPushMode);
        pushConfiguration.setPushMode(pushMode);
        if (push.isPresent()) {
            pushConfiguration.setTransport(push.get().transport());
        }
    }

    private void removeChildrenContentFromRouterLayout(RouterLayout targetRouterLayout, Map<RouterLayout, HasElement> oldChildren) {
        HasElement oldContent = oldChildren.get(targetRouterLayout);
        RouterLayout removeFrom = targetRouterLayout;
        while (oldContent != null) {
            removeFrom.removeRouterLayoutContent(oldContent);
            if (oldContent instanceof RouterLayout) {
                removeFrom = (RouterLayout)oldContent;
            }
            oldContent = oldChildren.get(oldContent);
        }
    }

    public static class JavaScriptInvocation
    implements Serializable {
        private final String expression;
        private final List<Serializable> parameters = new ArrayList<Serializable>();

        public JavaScriptInvocation(String expression, Serializable ... parameters) {
            for (Serializable argument : parameters) {
                JsonCodec.encodeWithTypeInfo(argument);
            }
            this.expression = expression;
            Collections.addAll(this.parameters, parameters);
        }

        public String getExpression() {
            return this.expression;
        }

        public List<Object> getParameters() {
            return Collections.unmodifiableList(this.parameters);
        }
    }
}

