/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.di.AbstractLookupInitializer;
import com.vaadin.flow.di.InstantiatorFactory;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.LookupInitializer;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import com.vaadin.flow.server.startup.DeferredServletContextInitializers;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;

@HandlesTypes(value={ResourceProvider.class, InstantiatorFactory.class, AbstractLookupInitializer.class})
public class LookupServletContainerInitializer
implements ClassLoaderAwareServletContainerInitializer {
    @Override
    public void process(Set<Class<?>> classSet, ServletContext servletContext) throws ServletException {
        if (classSet == null) {
            throw new ServletException(ServletContainerInitializer.class.getSimpleName() + " is called but the provided set of classes is 'null'. " + LookupInitializer.class + " always presents and has to be passed to the 'onStartup' method as an argument in the set of classes if the servlet container supports Servlet 3.0 specification. The propject configuration is broken somehow or you are using Servlet 3.0 incompatible container.");
        }
        if (!classSet.contains(LookupInitializer.class)) {
            return;
        }
        VaadinServletContext vaadinContext = new VaadinServletContext(servletContext);
        HashMap services = new HashMap();
        this.collectSubclasses(AbstractLookupInitializer.class, classSet, services);
        AbstractLookupInitializer initializer = this.getLookupInitializer(services);
        services.remove(AbstractLookupInitializer.class);
        this.collectServiceImplementations(classSet, services);
        initializer.initialize(vaadinContext, services, lookup -> {
            DeferredServletContextInitializers deferredInitializers;
            vaadinContext.setAttribute(Lookup.class, lookup);
            ServletContext servletContext2 = servletContext;
            synchronized (servletContext2) {
                deferredInitializers = vaadinContext.getAttribute(DeferredServletContextInitializers.class);
                vaadinContext.removeAttribute(DeferredServletContextInitializers.class);
            }
            if (deferredInitializers != null) {
                deferredInitializers.runInitializers(servletContext);
            }
        });
    }

    @Override
    public boolean requiresLookup() {
        return false;
    }

    protected Collection<Class<?>> getServiceTypes() {
        HandlesTypes annotation = this.getClass().getAnnotation(HandlesTypes.class);
        if (annotation == null) {
            throw new IllegalStateException("Cannot collect service types based on " + HandlesTypes.class.getSimpleName() + " annotation. The default 'getServiceTypes' method implementation can't be used.");
        }
        return Stream.of(annotation.value()).filter(clazz -> !clazz.equals(LookupInitializer.class)).collect(Collectors.toSet());
    }

    private void collectServiceImplementations(Set<Class<?>> classSet, Map<Class<?>, Collection<Class<?>>> services) {
        for (Class<?> serviceType : this.getServiceTypes()) {
            this.collectSubclasses(serviceType, classSet, services);
        }
    }

    private void collectSubclasses(Class<?> clazz, Set<Class<?>> classSet, Map<Class<?>, Collection<Class<?>>> services) {
        services.put(clazz, this.filterSubClasses(clazz, classSet).stream().collect(Collectors.toList()));
    }

    private Set<Class<?>> filterSubClasses(Class<?> clazz, Set<Class<?>> classes) {
        return classes == null ? Collections.emptySet() : classes.stream().filter(clazz::isAssignableFrom).filter(this::isInstantiableService).filter(cls -> !clazz.equals(cls)).collect(Collectors.toSet());
    }

    private boolean isInstantiableService(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        if (clazz.isSynthetic()) {
            return false;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return false;
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            return false;
        }
        Optional<Constructor> constructor = Stream.of(clazz.getConstructors()).filter(ctor -> ctor.getParameterCount() == 0).findFirst();
        if (!constructor.isPresent() || !Modifier.isPublic(constructor.get().getModifiers())) {
            return false;
        }
        return clazz.getEnclosingClass() == null || Modifier.isStatic(clazz.getModifiers());
    }

    private AbstractLookupInitializer getLookupInitializer(Map<Class<?>, Collection<Class<?>>> services) throws ServletException {
        AbstractLookupInitializer initializer;
        Collection<Class<?>> initializers = services.remove(AbstractLookupInitializer.class);
        if (initializers == null) {
            initializers = Collections.emptyList();
        } else {
            initializers.remove(LookupInitializer.class);
        }
        if (initializers.isEmpty()) {
            initializer = new LookupInitializer();
        } else {
            if (initializers.size() > 1) {
                throw new ServletException("Several implementation of " + AbstractLookupInitializer.class.getSimpleName() + " are found in the claspath: " + initializers);
            }
            initializer = (AbstractLookupInitializer)AbstractLookupInitializer.class.cast(ReflectTools.createInstance(initializers.iterator().next()));
        }
        return initializer;
    }
}

