/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUpdateWebpack
implements FallibleCommand {
    private final String webpackTemplate;
    private final String webpackGeneratedTemplate;
    private final Path webpackOutputPath;
    private final Path flowImportsFilePath;
    private final Path webpackConfigPath;
    private final Path frontendDirectory;
    private final Path flowResourcesFolder;
    private final Path resourceFolder;

    TaskUpdateWebpack(File frontendDirectory, File webpackConfigFolder, File webpackOutputDirectory, String webpackTemplate, String webpackGeneratedTemplate, File generatedFlowImports) {
        this.frontendDirectory = frontendDirectory.toPath();
        this.webpackTemplate = webpackTemplate;
        this.webpackGeneratedTemplate = webpackGeneratedTemplate;
        this.webpackOutputPath = webpackOutputDirectory.toPath();
        this.flowImportsFilePath = generatedFlowImports.toPath();
        this.webpackConfigPath = webpackConfigFolder.toPath();
        this.flowResourcesFolder = new File(webpackConfigFolder, System.getProperty("vaadin.frontend.generated.folder", "target/frontend/")).toPath();
        this.resourceFolder = new File(webpackOutputDirectory.getParentFile(), "VAADIN/static/").toPath();
    }

    @Override
    public void execute() {
        try {
            this.createWebpackConfig();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void createWebpackConfig() throws IOException {
        if (this.webpackTemplate == null || this.webpackTemplate.trim().isEmpty()) {
            return;
        }
        File configFile = new File(this.webpackConfigPath.toFile(), "webpack.config.js");
        if (configFile.exists()) {
            String contents;
            if (!FrontendUtils.isWebpackConfigFile(configFile)) {
                this.log().warn("Flow generated webpack configuration was not mentioned in the configuration file: {}.Please verify that './webpack.generated.js' is used in the merge or remove the file to generate a new one.", (Object)configFile);
            }
            if ((contents = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8)).contains("const merge = require('webpack-merge');")) {
                this.log().debug("Updating " + configFile.getName() + " to new webpack-merge syntax");
                contents = contents.replace("const merge = require('webpack-merge');", "const { merge } = require('webpack-merge');");
                FileUtils.write((File)configFile, (CharSequence)contents, (Charset)StandardCharsets.UTF_8);
            }
        } else {
            URL resource = this.getClass().getClassLoader().getResource(this.webpackTemplate);
            FileUtils.copyURLToFile((URL)resource, (File)configFile);
            this.log().debug("Created webpack configuration file: " + configFile);
        }
        File generatedFile = new File(this.webpackConfigPath.toFile(), "webpack.generated.js");
        URL resource = this.getClass().getClassLoader().getResource(this.webpackGeneratedTemplate);
        FileUtils.copyURLToFile((URL)resource, (File)generatedFile);
        List lines = FileUtils.readLines((File)generatedFile, (String)"UTF-8");
        String frontendLine = "const frontendFolder = require('path').resolve(__dirname, '" + this.getEscapedRelativeWebpackPath(this.frontendDirectory) + "');";
        String outputLine = "const mavenOutputFolderForFlowBundledFiles = require('path').resolve(__dirname, '" + this.getEscapedRelativeWebpackPath(this.webpackOutputPath) + "');";
        String mainLine = "const fileNameOfTheFlowGeneratedMainEntryPoint = require('path').resolve(__dirname, '" + this.getEscapedRelativeWebpackPath(this.flowImportsFilePath) + "');";
        String devmodeGizmoJSLine = "const devmodeGizmoJS = '@vaadin/flow-frontend/VaadinDevmodeGizmo.js'";
        String frontendFolder = "const flowFrontendFolder = require('path').resolve(__dirname, '" + this.getEscapedRelativeWebpackPath(this.flowResourcesFolder) + "');";
        String assetsResourceFolder = "const projectStaticAssetsOutputFolder = require('path').resolve(__dirname, '" + this.getEscapedRelativeWebpackPath(this.resourceFolder) + "');";
        for (int i = 0; i < lines.size(); ++i) {
            String line = ((String)lines.get(i)).trim();
            if (((String)lines.get(i)).startsWith("const fileNameOfTheFlowGeneratedMainEntryPoint") && !line.equals(mainLine)) {
                lines.set(i, mainLine);
            }
            if (((String)lines.get(i)).startsWith("const mavenOutputFolderForFlowBundledFiles") && !line.equals(outputLine)) {
                lines.set(i, outputLine);
            }
            if (((String)lines.get(i)).startsWith("const frontendFolder")) {
                lines.set(i, frontendLine);
            }
            if (((String)lines.get(i)).startsWith("const devmodeGizmoJS")) {
                lines.set(i, devmodeGizmoJSLine);
            }
            if (((String)lines.get(i)).startsWith("const flowFrontendFolder")) {
                lines.set(i, frontendFolder);
            }
            if (!((String)lines.get(i)).startsWith("const projectStaticAssetsOutputFolder")) continue;
            lines.set(i, assetsResourceFolder);
        }
        FileUtils.writeLines((File)generatedFile, (Collection)lines);
    }

    private String getEscapedRelativeWebpackPath(Path path) {
        Path relativePath = path.isAbsolute() ? this.webpackConfigPath.relativize(path) : path;
        return relativePath.toString().replaceAll("\\\\", "/");
    }

    private Logger log() {
        return LoggerFactory.getLogger((String)"dev-updater");
    }
}

