/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.BootstrapListener;
import com.vaadin.flow.server.DependencyFilter;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.VaadinService;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class ServiceInitEvent
extends EventObject {
    private List<RequestHandler> addedRequestHandlers = new ArrayList<RequestHandler>();
    private List<BootstrapListener> addedBootstrapListeners = new ArrayList<BootstrapListener>();
    private List<DependencyFilter> addedDependencyFilters = new ArrayList<DependencyFilter>();

    public ServiceInitEvent(VaadinService service) {
        super(service);
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        Objects.requireNonNull(requestHandler, "Request handler cannot be null");
        this.addedRequestHandlers.add(requestHandler);
    }

    public void addBootstrapListener(BootstrapListener bootstrapListener) {
        Objects.requireNonNull(bootstrapListener, "Bootstrap listener cannot be null");
        this.addedBootstrapListeners.add(bootstrapListener);
    }

    public void addDependencyFilter(DependencyFilter dependencyFilter) {
        Objects.requireNonNull(dependencyFilter, "Dependency filter cannot be null");
        this.addedDependencyFilters.add(dependencyFilter);
    }

    public Stream<RequestHandler> getAddedRequestHandlers() {
        return this.addedRequestHandlers.stream();
    }

    public Stream<BootstrapListener> getAddedBootstrapListeners() {
        return this.addedBootstrapListeners.stream();
    }

    public Stream<DependencyFilter> getAddedDependencyFilters() {
        return this.addedDependencyFilters.stream();
    }

    @Override
    public VaadinService getSource() {
        return (VaadinService)super.getSource();
    }
}

