/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.DebugWindowData;
import com.vaadin.flow.internal.DebugWindowMessage;
import com.vaadin.flow.internal.ProductAndMessage;
import com.vaadin.flow.internal.ServerInfo;
import com.vaadin.flow.server.DevModeHandler;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.Product;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugWindowConnection
implements BrowserLiveReload {
    private final ClassLoader classLoader;
    private final ConcurrentLinkedQueue<WeakReference<AtmosphereResource>> atmosphereResources = new ConcurrentLinkedQueue();
    private BrowserLiveReload.Backend backend = null;
    private static final EnumMap<BrowserLiveReload.Backend, List<String>> IDENTIFIER_CLASSES = new EnumMap(BrowserLiveReload.Backend.class);

    DebugWindowConnection() {
        this(DebugWindowConnection.class.getClassLoader());
    }

    DebugWindowConnection(ClassLoader classLoader) {
        this.classLoader = classLoader;
        DevModeHandler devModeHandler = DevModeHandler.getDevModeHandler();
        if (devModeHandler != null) {
            devModeHandler.setLiveReload(this);
        }
    }

    @Override
    public BrowserLiveReload.Backend getBackend() {
        if (this.backend != null) {
            return this.backend;
        }
        for (Map.Entry<BrowserLiveReload.Backend, List<String>> entry : IDENTIFIER_CLASSES.entrySet()) {
            BrowserLiveReload.Backend backendCandidate = entry.getKey();
            boolean found = true;
            for (String clazz : entry.getValue()) {
                try {
                    this.classLoader.loadClass(clazz);
                }
                catch (ClassNotFoundException e) {
                    DebugWindowConnection.getLogger().debug("Class {} not found, excluding {}", (Object)clazz, (Object)backendCandidate);
                    found = false;
                    break;
                }
            }
            if (!found) continue;
            this.backend = backendCandidate;
            break;
        }
        return this.backend;
    }

    @Override
    public void setBackend(BrowserLiveReload.Backend backend) {
        assert (backend != null);
        this.backend = backend;
    }

    @Override
    public void onConnect(AtmosphereResource resource) {
        resource.suspend(-1L);
        this.atmosphereResources.add(new WeakReference<AtmosphereResource>(resource));
        resource.getBroadcaster().broadcast((Object)"{\"command\": \"hello\"}", resource);
        this.send(resource, "serverInfo", new ServerInfo());
    }

    private void send(AtmosphereResource resource, String command, DebugWindowData data) {
        try {
            DebugWindowMessage message = new DebugWindowMessage(command, data);
            resource.getBroadcaster().broadcast((Object)message.toJson(), resource);
        }
        catch (Exception e) {
            DebugWindowConnection.getLogger().error("Error sending message", (Throwable)e);
        }
    }

    @Override
    public void onDisconnect(AtmosphereResource resource) {
        if (!this.atmosphereResources.removeIf(resourceRef -> resource.equals(resourceRef.get()))) {
            String uuid = resource.uuid();
            DebugWindowConnection.getLogger().warn("Push connection {} is not a live-reload connection or already closed", (Object)uuid);
        }
    }

    @Override
    public boolean isLiveReload(AtmosphereResource resource) {
        return this.atmosphereResources.stream().anyMatch(resourceRef -> resource.equals(resourceRef.get()));
    }

    @Override
    public void reload() {
        this.atmosphereResources.forEach((Consumer<WeakReference<AtmosphereResource>>)((Consumer<WeakReference>)resourceRef -> {
            AtmosphereResource resource = (AtmosphereResource)resourceRef.get();
            if (resource != null) {
                resource.getBroadcaster().broadcast((Object)"{\"command\": \"reload\"}", resource);
            }
        }));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)DebugWindowConnection.class.getName());
    }

    @Override
    public void onMessage(AtmosphereResource resource, String message) {
        if (message.isEmpty()) {
            DebugWindowConnection.getLogger().debug("Received live reload heartbeat");
            return;
        }
        JsonObject json = Json.parse((String)message);
        String command = json.getString("command");
        if ("checkLicense".equals(command)) {
            boolean ok;
            JsonObject data = json.getObject("data");
            String name = data.getString("name");
            String version = data.getString("version");
            Product product = new Product(name, version);
            String errorMessage = "";
            try {
                LicenseChecker.checkLicense((String)product.getName(), (String)product.getVersion(), (BuildType)BuildType.DEVELOPMENT, keyUrl -> this.send(resource, "license-check-nokey", new ProductAndMessage(product, (String)keyUrl)));
                ok = true;
            }
            catch (Exception e) {
                ok = false;
                errorMessage = e.getMessage();
            }
            if (ok) {
                this.send(resource, "license-check-ok", this.getProductJson(product));
            } else {
                ProductAndMessage pm = new ProductAndMessage(product, errorMessage);
                this.send(resource, "license-check-failed", pm);
            }
        } else {
            DebugWindowConnection.getLogger().info("Unknown command from the browser: " + command);
        }
    }

    private DebugWindowData getProductJson(Product product) {
        return () -> String.format("{\"name\": \"%s\", \"version\": \"%s\"}", product.getName(), product.getVersion());
    }

    static {
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.JREBEL, Collections.singletonList("org.zeroturnaround.jrebel.vaadin.JRebelClassEventListener"));
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.HOTSWAP_AGENT, Collections.singletonList("org.hotswap.agent.plugin.vaadin.VaadinIntegration"));
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.SPRING_BOOT_DEVTOOLS, Arrays.asList("com.vaadin.flow.spring.SpringServlet", "org.springframework.boot.devtools.livereload.LiveReloadServer"));
    }
}

