/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.polymertemplate;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.templatemodel.BeanModelType;
import com.vaadin.flow.templatemodel.ComplexModelType;
import com.vaadin.flow.templatemodel.ListModelType;
import com.vaadin.flow.templatemodel.ModelDescriptor;
import com.vaadin.flow.templatemodel.ModelType;
import com.vaadin.flow.templatemodel.TemplateModel;
import com.vaadin.flow.templatemodel.TemplateModelProxyHandler;
import elemental.json.Json;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractTemplate<M extends TemplateModel>
extends Component {
    private final StateNode stateNode;
    private transient M model;

    protected AbstractTemplate() {
        this.stateNode = this.getElement().getNode();
    }

    protected AbstractTemplate(StateNode stateNode) {
        super(null);
        this.stateNode = stateNode;
    }

    protected M getModel() {
        if (this.model == null) {
            this.model = this.createTemplateModelInstance();
        }
        return this.model;
    }

    protected Class<? extends M> getModelType() {
        Type type = GenericTypeReflector.getTypeParameter((Type)this.getClass().getGenericSuperclass(), AbstractTemplate.class.getTypeParameters()[0]);
        if (type instanceof Class || type instanceof ParameterizedType) {
            return GenericTypeReflector.erase((Type)type);
        }
        throw new IllegalStateException(AbstractTemplate.getExceptionMessage(type));
    }

    private static String getExceptionMessage(Type type) {
        if (type == null) {
            return "AbstractTemplate is used as raw type: either add type information or override getModelType().";
        }
        if (type instanceof TypeVariable) {
            return String.format("Could not determine the composite content type for TypeVariable '%s'. Either specify exact type or override getModelType().", type.getTypeName());
        }
        return String.format("Could not determine the composite content type for %s. Override getModelType().", type.getTypeName());
    }

    protected StateNode getStateNode() {
        return this.stateNode;
    }

    public boolean isSupportedClass(Class<?> type) {
        List modelTypes = ModelDescriptor.get(this.getModelType()).getPropertyNames().map(this::getModelType).collect(Collectors.toList());
        boolean result = false;
        for (ModelType modelType : modelTypes) {
            if (type.equals(modelType.getJavaType())) {
                result = true;
            } else if (modelType instanceof ListModelType) {
                result = AbstractTemplate.checkListType(type, modelType);
            }
            if (!result) continue;
            break;
        }
        return result;
    }

    private static boolean checkListType(Class<?> type, ModelType modelType) {
        if (type.isAssignableFrom(List.class)) {
            return true;
        }
        ComplexModelType model = modelType;
        while (model instanceof ListModelType) {
            model = ((ListModelType)model).getItemType();
        }
        return type.equals(model.getJavaType());
    }

    private ModelType getModelType(String type) {
        return ModelDescriptor.get(this.getModelType()).getPropertyType(type);
    }

    public ModelType getModelType(Type type) {
        List modelTypes = ModelDescriptor.get(this.getModelType()).getPropertyNames().map(this::getModelType).collect(Collectors.toList());
        for (ModelType mtype : modelTypes) {
            ModelType modelType;
            if (type.equals(mtype.getJavaType())) {
                return mtype;
            }
            if (!(mtype instanceof ListModelType) || (modelType = AbstractTemplate.getModelTypeForListModel(type, mtype)) == null) continue;
            return modelType;
        }
        String msg = String.format("Couldn't find ModelType for requested class %s", type.getTypeName());
        throw new IllegalArgumentException(msg);
    }

    private M createTemplateModelInstance() {
        ModelDescriptor<M> descriptor = ModelDescriptor.get(this.getModelType());
        return (M)((TemplateModel)TemplateModelProxyHandler.createModelProxy(this.getStateNode(), descriptor));
    }

    private static ModelType getModelTypeForListModel(Type type, ModelType mtype) {
        ComplexModelType modelType = mtype;
        while (modelType instanceof ListModelType) {
            if (type.equals(modelType.getJavaType())) {
                return modelType;
            }
            modelType = ((ListModelType)modelType).getItemType();
        }
        if (type.equals(modelType.getJavaType())) {
            return modelType;
        }
        return null;
    }

    protected void initModel(Set<String> twoWayBindingPaths) {
        this.getModel();
        BeanModelType<?> modelType = TemplateModelProxyHandler.getModelTypeForProxy(this.model);
        Map<String, Boolean> allowedProperties = modelType.getClientUpdateAllowedProperties(twoWayBindingPaths);
        Set allowedPropertyName = Collections.emptySet();
        if (!allowedProperties.isEmpty()) {
            allowedPropertyName = new HashSet<String>(allowedProperties.keySet());
        }
        ElementPropertyMap.getModel(this.getStateNode()).setUpdateFromClientFilter(allowedPropertyName::contains);
        List<String> propertyNames = this.removeSimpleProperties();
        this.getStateNode().runWhenAttached(ui -> ui.getInternals().getStateTree().beforeClientResponse(this.getStateNode(), context -> context.getUI().getPage().executeJs("this.registerUpdatableModelProperties($0, $1)", new Serializable[]{this.getElement(), this.filterUpdatableProperties(allowedProperties)})));
        this.getStateNode().runWhenAttached(ui -> ui.getInternals().getStateTree().beforeClientResponse(this.getStateNode(), context -> context.getUI().getPage().executeJs("this.populateModelProperties($0, $1)", new Serializable[]{this.getElement(), this.filterUnsetProperties(propertyNames)})));
    }

    private JsonArray filterUnsetProperties(List<String> properties) {
        JsonArray array = Json.createArray();
        ElementPropertyMap map = this.getStateNode().getFeature(ElementPropertyMap.class);
        int i = 0;
        for (String property : properties) {
            if (map.hasProperty(property)) continue;
            array.set(i, property);
            ++i;
        }
        return array;
    }

    private JsonArray filterUpdatableProperties(Map<String, Boolean> allowedProperties) {
        JsonArray array = Json.createArray();
        int i = 0;
        for (Map.Entry<String, Boolean> entry : allowedProperties.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            array.set(i, entry.getKey());
            ++i;
        }
        return array;
    }

    private List<String> removeSimpleProperties() {
        ElementPropertyMap map = this.getStateNode().getFeature(ElementPropertyMap.class);
        List<String> props = map.getPropertyNames().filter(name -> !(map.getProperty((String)name) instanceof StateNode)).collect(Collectors.toList());
        props.forEach(map::removeProperty);
        return props;
    }
}

