/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventBusUtil;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DebounceSettings;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.dom.DebouncePhase;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class ComponentEventBus
implements Serializable {
    HashMap<Class<? extends ComponentEvent<?>>, ArrayList<ListenerWrapper<?>>> componentEventData = new HashMap(2);
    private Component component;

    public ComponentEventBus(Component component) {
        this.component = component;
    }

    public <T extends ComponentEvent<?>> Registration addListener(Class<T> eventType, ComponentEventListener<T> listener) {
        return this.addListenerInternal(eventType, listener, null);
    }

    public <T extends ComponentEvent<?>> Registration addListener(Class<T> eventType, ComponentEventListener<T> listener, Consumer<DomListenerRegistration> domListenerConsumer) {
        Objects.requireNonNull(domListenerConsumer, "DOM listener consumer cannot be null");
        return this.addListenerInternal(eventType, listener, domListenerConsumer);
    }

    private <T extends ComponentEvent<?>> Registration addListenerInternal(Class<T> eventType, ComponentEventListener<T> listener, Consumer<DomListenerRegistration> domListenerConsumer) {
        ListenerWrapper wrapper = new ListenerWrapper(listener);
        boolean isDomEvent = this.addDomTriggerIfNeeded(eventType, wrapper);
        if (domListenerConsumer != null) {
            if (!isDomEvent) {
                throw new IllegalArgumentException(String.format("DomListenerConsumer can be used only for DOM events. The given event type %s is not annotated with %s.", eventType.getSimpleName(), com.vaadin.flow.dom.DomEvent.class.getSimpleName()));
            }
            domListenerConsumer.accept(wrapper.domRegistration);
        }
        this.componentEventData.computeIfAbsent(eventType, t -> new ArrayList(1)).add(wrapper);
        return Registration.once(() -> this.removeListener(eventType, wrapper));
    }

    public boolean hasListener(Class<? extends ComponentEvent> eventType) {
        if (eventType == null) {
            throw new IllegalArgumentException("Event type cannot be null");
        }
        return this.componentEventData.containsKey(eventType);
    }

    public void fireEvent(ComponentEvent event) {
        Class<?> eventType = event.getClass();
        if (!this.hasListener(eventType)) {
            return;
        }
        for (ListenerWrapper wrapper : new ArrayList(this.componentEventData.get(event.getClass()))) {
            this.fireEventForListener(event, wrapper);
        }
    }

    private <T extends ComponentEvent<?>> void fireEventForListener(T event, ListenerWrapper<T> wrapper) {
        Class<?> eventType = event.getClass();
        event.setUnregisterListenerCommand(() -> this.removeListener(eventType, wrapper));
        wrapper.listener.onComponentEvent(event);
        event.setUnregisterListenerCommand(null);
    }

    private <T extends ComponentEvent<?>> boolean addDomTriggerIfNeeded(Class<T> eventType, ListenerWrapper<T> wrapper) {
        return AnnotationReader.getAnnotationFor(eventType, DomEvent.class).map(annotation -> {
            this.addDomTrigger(eventType, (DomEvent)annotation, wrapper);
            return true;
        }).orElse(false);
    }

    private <T extends ComponentEvent<?>> void addDomTrigger(Class<T> eventType, DomEvent annotation, ListenerWrapper<T> wrapper) {
        assert (eventType != null);
        assert (annotation != null);
        String domEventType = annotation.value();
        DisabledUpdateMode mode = annotation.allowUpdates();
        String filter = annotation.filter();
        DebounceSettings debounce = annotation.debounce();
        int debounceTimeout = debounce.timeout();
        if (domEventType == null || domEventType.isEmpty()) {
            throw new IllegalArgumentException("The DOM event type cannot be null or empty");
        }
        Element element = this.component.getElement();
        DomListenerRegistration registration = element.addEventListener(domEventType, event -> this.handleDomEvent(eventType, event, wrapper));
        wrapper.domRegistration = registration;
        registration.setDisabledUpdateMode(mode);
        LinkedHashMap<String, Class<?>> eventDataExpressions = ComponentEventBusUtil.getEventDataExpressions(eventType);
        eventDataExpressions.forEach((expression, type) -> {
            if (Component.class.isAssignableFrom((Class<?>)type) || type == Element.class) {
                registration.addEventDataElement((String)expression);
            } else {
                registration.addEventData((String)expression);
            }
        });
        if (!"".equals(filter)) {
            registration.setFilter(filter);
        }
        if (debounceTimeout != 0) {
            DebouncePhase[] phases = debounce.phases();
            if (phases.length == 0) {
                throw new IllegalStateException("There must be at least one debounce phase");
            }
            DebouncePhase[] rest = new DebouncePhase[phases.length - 1];
            System.arraycopy(phases, 1, rest, 0, rest.length);
            registration.debounce(debounceTimeout, phases[0], rest);
        }
    }

    private List<Object> createEventDataObjects(com.vaadin.flow.dom.DomEvent domEvent, Class<? extends ComponentEvent<?>> eventType) {
        ArrayList<Object> eventDataObjects = new ArrayList<Object>();
        LinkedHashMap<String, Class<?>> expressions = ComponentEventBusUtil.getEventDataExpressions(eventType);
        expressions.forEach((expression, type) -> {
            if (Component.class.isAssignableFrom((Class<?>)type) || type == Element.class) {
                eventDataObjects.add(this.parseStateNodeIdToComponentReference(domEvent, (Class<?>)type, (String)expression));
            } else {
                JsonValue jsonValue = domEvent.getEventData().get(expression);
                if (jsonValue == null) {
                    jsonValue = Json.createNull();
                }
                Object value = JsonCodec.decodeAs(jsonValue, type);
                eventDataObjects.add(value);
            }
        });
        return eventDataObjects;
    }

    private Object parseStateNodeIdToComponentReference(com.vaadin.flow.dom.DomEvent event, Class<?> expectedEventDataType, String eventDataExpression) {
        assert (Component.class.isAssignableFrom(expectedEventDataType) || Element.class == expectedEventDataType);
        Element mappedElement = event.getEventDataElement(eventDataExpression).orElse(null);
        if (expectedEventDataType == Element.class || mappedElement == null) {
            return mappedElement;
        }
        Optional<Component> componentMaybe = mappedElement.getComponent();
        if (componentMaybe.isPresent()) {
            Component mappedComponent = componentMaybe.get();
            if (expectedEventDataType.isAssignableFrom(mappedComponent.getClass())) {
                return mappedComponent;
            }
            throw new IllegalStateException(String.format("Error when trying to map event data for event '%s' in component %s from browser: the event data expression '%s' was mapped to an element with tag '%s' and node-id '%s', but it is mapped to a component of type '%s' instead of the expected type of %s.%nEither the event data expression returns the wrong element, or the type for the '@EventType(\"%s\")' should be changed from %s to %s", event.getType(), this.component.getClass().getSimpleName(), eventDataExpression, mappedElement.getTag(), mappedElement.getNode().getId(), mappedComponent.getClass().getSimpleName(), expectedEventDataType.getSimpleName(), eventDataExpression, mappedComponent.getClass().getSimpleName(), expectedEventDataType.getSimpleName()));
        }
        throw new IllegalStateException(String.format("Error when trying to map event data for event '%s' in component %s from browser: the event data expression '%s' was mapped to an element with tag '%s' and node-id '%s', but it doesn't have a component instance mapped to it.%nEither the event data expression returns the wrong element, or the type for the '@EventType(\"%s\")' should be changed from %s to Element", event.getType(), this.component.getClass().getSimpleName(), eventDataExpression, mappedElement.getTag(), mappedElement.getNode().getId(), eventDataExpression, expectedEventDataType));
    }

    private <T extends ComponentEvent<?>> void removeListener(Class<T> eventType, ListenerWrapper<T> wrapper) {
        assert (eventType != null);
        assert (wrapper != null);
        assert (((ListenerWrapper)wrapper).listener != null);
        ArrayList<ListenerWrapper<?>> eventData = this.componentEventData.get(eventType);
        if (eventData == null) {
            throw new IllegalArgumentException("No listener of the given type is registered");
        }
        if (!eventData.remove(wrapper)) {
            throw new IllegalArgumentException("The given listener is not registered");
        }
        if (((ListenerWrapper)wrapper).domRegistration != null) {
            ((ListenerWrapper)wrapper).domRegistration.remove();
        }
        if (eventData.isEmpty()) {
            this.componentEventData.remove(eventType);
        }
    }

    private <T extends ComponentEvent<?>> void handleDomEvent(Class<T> eventType, com.vaadin.flow.dom.DomEvent domEvent, ListenerWrapper<T> wrapper) {
        T event = this.createEventForDomEvent(eventType, domEvent, this.component);
        this.fireEventForListener(event, wrapper);
    }

    private <T extends ComponentEvent<?>> T createEventForDomEvent(Class<T> eventType, com.vaadin.flow.dom.DomEvent domEvent, Component source) {
        try {
            Constructor<T> c = ComponentEventBusUtil.getEventConstructor(eventType);
            if (!c.getParameterTypes()[0].isAssignableFrom(source.getClass())) {
                Class<?> definedSourceType = c.getParameterTypes()[0];
                throw new IllegalArgumentException(String.format("The event type %s define the source type to be %s, which is not compatible with the used source of type %s", eventType.getName(), definedSourceType.getName(), source.getClass().getName()));
            }
            List<Object> eventData = this.createEventDataObjects(domEvent, eventType);
            Object[] params = new Object[eventData.size() + 2];
            params[0] = source;
            params[1] = Boolean.TRUE;
            for (int i = 0; i < eventData.size(); ++i) {
                params[i + 2] = eventData.get(i);
            }
            return (T)((ComponentEvent)c.newInstance(params));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to create an event object of type " + eventType.getName(), e);
        }
    }

    private static class ListenerWrapper<T extends ComponentEvent<?>>
    implements Serializable {
        private ComponentEventListener<T> listener;
        private DomListenerRegistration domRegistration;

        public ListenerWrapper(ComponentEventListener<T> listener) {
            this.listener = listener;
        }
    }
}

