/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.scanner.AbstractDependenciesScanner;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.ThemeData;
import com.vaadin.flow.server.frontend.scanner.ThemeWrapper;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.Theme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FullDependenciesScanner
extends AbstractDependenciesScanner {
    protected static final String ERROR_INVALID_PWA_ANNOTATION = "There can only be one @PWA annotation per application and it must be set on the application's parent layout, or in a view annotated with @Route";
    private static final String COULD_NOT_LOAD_ERROR_MSG = "Could not load annotation class ";
    private static final String VALUE = "value";
    private static final String VERSION = "version";
    private ThemeDefinition themeDefinition;
    private AbstractTheme themeInstance;
    private PwaConfiguration pwaConfiguration;
    private Set<String> classes = new HashSet<String>();
    private Map<String, String> packages;
    private Set<String> scripts = new LinkedHashSet<String>();
    private Set<CssData> cssData;
    private List<String> modules;
    private final Class<?> abstractTheme;
    private final SerializableBiFunction<Class<?>, Class<? extends Annotation>, List<? extends Annotation>> annotationFinder;
    private final boolean fallback;

    FullDependenciesScanner(ClassFinder finder, boolean fallback) {
        this(finder, AnnotationReader::getAnnotationsFor, fallback);
    }

    FullDependenciesScanner(ClassFinder finder, SerializableBiFunction<Class<?>, Class<? extends Annotation>, List<? extends Annotation>> annotationFinder, boolean fallback) {
        super(finder);
        this.fallback = fallback;
        long start = System.currentTimeMillis();
        this.annotationFinder = annotationFinder;
        try {
            this.abstractTheme = finder.loadClass(AbstractTheme.class.getName());
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("Could not load " + AbstractTheme.class.getName() + " class", exception);
        }
        this.packages = this.discoverPackages();
        HashMap<String, Set<String>> themeModules = new HashMap<String, Set<String>>();
        LinkedHashSet<String> regularModules = new LinkedHashSet<String>();
        this.collectAnnotationValues((clazz, module) -> this.handleModule((Class<?>)clazz, (String)module, (Set<String>)regularModules, (Map<String, Set<String>>)themeModules), JsModule.class, module -> this.invokeAnnotationMethodAsString((Annotation)module, VALUE));
        this.collectAnnotationValues((clazz, script) -> {
            this.classes.add(clazz.getName());
            this.scripts.add((String)script);
        }, JavaScript.class, module -> this.invokeAnnotationMethodAsString((Annotation)module, VALUE));
        this.cssData = this.discoverCss();
        this.discoverTheme();
        this.pwaConfiguration = this.discoverPwa();
        this.modules = this.calculateModules(regularModules, themeModules);
        this.getLogger().info("Visited {} classes. Took {} ms.", (Object)this.getClasses().size(), (Object)(System.currentTimeMillis() - start));
    }

    @Override
    public Map<String, String> getPackages() {
        return Collections.unmodifiableMap(this.packages);
    }

    @Override
    public List<String> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    @Override
    public Set<String> getScripts() {
        return Collections.unmodifiableSet(this.scripts);
    }

    @Override
    public Set<CssData> getCss() {
        return Collections.unmodifiableSet(this.cssData);
    }

    @Override
    public ThemeDefinition getThemeDefinition() {
        return this.themeDefinition;
    }

    @Override
    public AbstractTheme getTheme() {
        return this.themeInstance;
    }

    @Override
    public PwaConfiguration getPwaConfiguration() {
        return this.pwaConfiguration;
    }

    @Override
    public Set<String> getClasses() {
        return Collections.unmodifiableSet(this.classes);
    }

    private CssData createCssData(Annotation cssImport) {
        CssData data = new CssData();
        data.id = this.adaptCssValue(cssImport, "id");
        data.include = this.adaptCssValue(cssImport, "include");
        data.themefor = this.adaptCssValue(cssImport, "themeFor");
        data.value = this.adaptCssValue(cssImport, VALUE);
        return data;
    }

    private String adaptCssValue(Annotation cssImport, String method) {
        String value = this.invokeAnnotationMethodAsString(cssImport, method);
        if (value == null) {
            return value;
        }
        return value.isEmpty() ? null : value;
    }

    private Map<String, String> discoverPackages() {
        try {
            Class loadedAnnotation = this.getFinder().loadClass(NpmPackage.class.getName());
            Set<Class<?>> annotatedClasses = this.getFinder().getAnnotatedClasses(loadedAnnotation);
            HashMap<String, String> result = new HashMap<String, String>();
            HashSet<String> logs = new HashSet<String>();
            for (Class<?> clazz : annotatedClasses) {
                this.classes.add(clazz.getName());
                List packageAnnotations = (List)this.annotationFinder.apply(clazz, loadedAnnotation);
                packageAnnotations.forEach(annotation -> {
                    String value = this.invokeAnnotationMethodAsString((Annotation)annotation, VALUE);
                    String version = this.invokeAnnotationMethodAsString((Annotation)annotation, VERSION);
                    logs.add(value + " " + version + " " + clazz.getName());
                    if (result.containsKey(value) && !((String)result.get(value)).equals(version)) {
                        if (!this.fallback) {
                            String foundVersions = "[" + (String)result.get(value) + ", " + version + "]";
                            this.getLogger().warn("Multiple npm versions for {} found:  {}. First version found '{}' will be considered.", new Object[]{value, foundVersions, result.get(value)});
                        }
                    } else {
                        result.put(value, version);
                    }
                });
            }
            this.debug("npm dependencies", logs);
            return result;
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException(COULD_NOT_LOAD_ERROR_MSG + NpmPackage.class.getName(), exception);
        }
    }

    private Set<CssData> discoverCss() {
        try {
            Class loadedAnnotation = this.getFinder().loadClass(CssImport.class.getName());
            Set<Class<?>> annotatedClasses = this.getFinder().getAnnotatedClasses(loadedAnnotation);
            LinkedHashSet<CssData> result = new LinkedHashSet<CssData>();
            for (Class<?> clazz : annotatedClasses) {
                this.classes.add(clazz.getName());
                List imports = (List)this.annotationFinder.apply(clazz, loadedAnnotation);
                imports.stream().forEach(imp -> result.add(this.createCssData((Annotation)imp)));
            }
            return result;
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException(COULD_NOT_LOAD_ERROR_MSG + CssData.class.getName(), exception);
        }
    }

    private <T extends Annotation> void collectAnnotationValues(BiConsumer<Class<?>, String> valueHandler, Class<T> annotationType, Function<Annotation, String> valueExtractor) {
        try {
            HashSet<String> logs = new HashSet<String>();
            Class loadedAnnotation = this.getFinder().loadClass(annotationType.getName());
            Set<Class<?>> annotatedClasses = this.getFinder().getAnnotatedClasses(loadedAnnotation);
            annotatedClasses.stream().forEach(clazz -> ((List)this.annotationFinder.apply((Class<?>)clazz, loadedAnnotation)).forEach(ann -> {
                String value = (String)valueExtractor.apply((Annotation)ann);
                valueHandler.accept((Class<?>)clazz, value);
                logs.add(value + " " + clazz);
            }));
            this.debug("@" + annotationType.getSimpleName(), logs);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException(COULD_NOT_LOAD_ERROR_MSG + annotationType.getName(), exception);
        }
    }

    private void debug(String label, Set<String> log) {
        if (this.getLogger().isDebugEnabled()) {
            log.add("\n List of " + label + " found in the project:");
            this.getLogger().debug(log.stream().sorted().collect(Collectors.joining("\n  - ")));
        }
    }

    private void discoverTheme() {
        ThemeData data = this.verifyTheme();
        if (data == null) {
            this.setupTheme(this.getLumoTheme(), "", "");
            return;
        }
        if (data.isNotheme()) {
            return;
        }
        try {
            Class theme = this.getFinder().loadClass(data.getThemeClass());
            this.setupTheme(theme, data.getVariant(), data.getThemeName());
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("Could not load theme class " + data.getThemeClass(), exception);
        }
    }

    private void setupTheme(Class<? extends AbstractTheme> theme, String variant, String name) {
        if (theme != null) {
            this.themeDefinition = new ThemeDefinition(theme, variant, name);
            try {
                this.themeInstance = new ThemeWrapper(theme);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Unable to create a new '" + theme.getName() + "' theme instance", e);
            }
        }
    }

    private ThemeData verifyTheme() {
        try {
            Class loadedThemeAnnotation = this.getFinder().loadClass(Theme.class.getName());
            Set<Class<?>> annotatedClasses = this.getFinder().getAnnotatedClasses(loadedThemeAnnotation);
            Set<ThemeData> themes = annotatedClasses.stream().flatMap(clazz -> ((List)this.annotationFinder.apply((Class<?>)clazz, loadedThemeAnnotation)).stream()).map(theme -> new ThemeData(((Class)this.invokeAnnotationMethod((Annotation)theme, VALUE)).getName(), this.invokeAnnotationMethodAsString((Annotation)theme, "variant"), this.invokeAnnotationMethodAsString((Annotation)theme, "themeFolder"))).collect(Collectors.toSet());
            Class loadedNoThemeAnnotation = this.getFinder().loadClass(NoTheme.class.getName());
            Set notThemeClasses = this.getFinder().getAnnotatedClasses(loadedNoThemeAnnotation).stream().collect(Collectors.toSet());
            if (themes.size() > 1) {
                throw new IllegalStateException("Using multiple different Theme configurations is not supported. The list of found themes:\n" + this.getThemesList(themes));
            }
            if (!themes.isEmpty() && !notThemeClasses.isEmpty()) {
                throw new IllegalStateException("@" + Theme.class.getSimpleName() + " (" + this.getThemesList(themes) + ") and @" + NoTheme.class.getSimpleName() + " annotations can't be used simultaneously.");
            }
            if (!notThemeClasses.isEmpty()) {
                return ThemeData.createNoTheme();
            }
            return themes.isEmpty() ? null : themes.iterator().next();
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("Could not load theme annotation class", exception);
        }
    }

    private String getThemesList(Collection<ThemeData> themes) {
        return themes.stream().map(theme -> "themeClass = '" + theme.getThemeClass() + "' and variant = '" + theme.getVariant() + "' and name = '" + theme.getThemeName() + "'").collect(Collectors.joining(", "));
    }

    private void handleModule(Class<?> clazz, String module, Set<String> modules, Map<String, Set<String>> themeModules) {
        if (this.abstractTheme.isAssignableFrom(clazz)) {
            Set themingModules = themeModules.computeIfAbsent(clazz.getName(), cl -> new LinkedHashSet());
            themingModules.add(module);
        } else {
            this.classes.add(clazz.getName());
            modules.add(module);
        }
    }

    private List<String> calculateModules(Set<String> modules, Map<String, Set<String>> themeModules) {
        Set<String> themingModules = themeModules.get(this.getThemeDefinition() == null ? null : this.getThemeDefinition().getTheme().getName());
        if (themingModules == null) {
            return new ArrayList<String>(modules);
        }
        if (this.getThemeDefinition() != null) {
            this.classes.add(this.getThemeDefinition().getTheme().getName());
        }
        ArrayList<String> result = new ArrayList<String>(themingModules.size() + modules.size());
        result.addAll(themingModules);
        result.addAll(modules);
        return result;
    }

    private String invokeAnnotationMethodAsString(Annotation target, String methodName) {
        Object result = this.invokeAnnotationMethod(target, methodName);
        return result == null ? null : result.toString();
    }

    private Object invokeAnnotationMethod(Annotation target, String methodName) {
        try {
            return target.getClass().getDeclaredMethod(methodName, new Class[0]).invoke((Object)target, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(String.format("Failed to access method '%s' in annotation interface '%s', should not be happening due to JLS definition of annotation interface", methodName, target), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(String.format("Got an exception by invoking method '%s' from annotation '%s'", methodName, target), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Annotation '%s' has no method named `%s", target, methodName), e);
        }
    }

    private PwaConfiguration discoverPwa() {
        try {
            Class loadedPWAAnnotation = this.getFinder().loadClass(PWA.class.getName());
            Set<Class<?>> annotatedClasses = this.getFinder().getAnnotatedClasses(loadedPWAAnnotation);
            if (annotatedClasses.isEmpty()) {
                return new PwaConfiguration();
            }
            if (annotatedClasses.size() != 1) {
                throw new IllegalStateException("There can only be one @PWA annotation per application and it must be set on the application's parent layout, or in a view annotated with @Route. Found " + annotatedClasses.size() + " implementations: " + annotatedClasses);
            }
            Class<?> hopefullyCorrectPWAHolder = annotatedClasses.iterator().next();
            Class routeAnnotationClass = this.getFinder().loadClass(Route.class.getName());
            Class routeLayoutClass = this.getFinder().loadClass(RouterLayout.class.getName());
            if (!hopefullyCorrectPWAHolder.isAnnotationPresent(routeAnnotationClass) && !routeLayoutClass.isAssignableFrom(hopefullyCorrectPWAHolder)) {
                throw new IllegalStateException("There can only be one @PWA annotation per application and it must be set on the application's parent layout, or in a view annotated with @Route but was found on " + hopefullyCorrectPWAHolder.getName());
            }
            Annotation pwa = (Annotation)((List)this.annotationFinder.apply(hopefullyCorrectPWAHolder, loadedPWAAnnotation)).get(0);
            String name = this.invokeAnnotationMethodAsString(pwa, "name");
            String shortName = this.invokeAnnotationMethodAsString(pwa, "shortName");
            String description = this.invokeAnnotationMethodAsString(pwa, "description");
            String backgroundColor = this.invokeAnnotationMethodAsString(pwa, "backgroundColor");
            String themeColor = this.invokeAnnotationMethodAsString(pwa, "themeColor");
            String iconPath = this.invokeAnnotationMethodAsString(pwa, "iconPath");
            String manifestPath = this.invokeAnnotationMethodAsString(pwa, "manifestPath");
            String offlinePath = this.invokeAnnotationMethodAsString(pwa, "offlinePath");
            String display = this.invokeAnnotationMethodAsString(pwa, "display");
            String startPath = this.invokeAnnotationMethodAsString(pwa, "startPath");
            String[] offlineResources = (String[])this.invokeAnnotationMethod(pwa, "offlineResources");
            boolean enableInstallPrompt = (Boolean)this.invokeAnnotationMethod(pwa, "enableInstallPrompt");
            assert (shortName != null);
            return new PwaConfiguration(true, "/", name, shortName, description, backgroundColor, themeColor, iconPath, manifestPath, offlinePath, display, startPath, offlineResources, enableInstallPrompt);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("Could not load PWA annotation class", exception);
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)"dev-updater");
    }
}

