/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.utils;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.io.FileUtils;

public final class FlowFileUtils {
    private FlowFileUtils() {
    }

    public static void forceMkdir(File directory) {
        try {
            FileUtils.forceMkdir((File)Objects.requireNonNull(directory));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create directory '%s'", directory), e);
        }
    }

    public static URL convertToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Failed to convert file '%s' to URL", file), e);
        }
    }
}

