/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.plugin.base.PluginAdapterBuild;
import com.vaadin.flow.plugin.maven.Reflector;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.installer.Platform;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.scanner.ReflectionsClassFinder;
import com.vaadin.flow.utils.FlowFileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

@org.apache.maven.plugins.annotations.Mojo(name="build-dev-bundle", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class BuildDevBundleMojo
extends AbstractMojo
implements PluginAdapterBuild,
PluginAdapterBase {
    @Parameter(defaultValue="true")
    private boolean generateEmbeddableWebComponents;
    public static final String INCLUDE_FROM_COMPILE_DEPS_REGEX = ".*(/|\\\\)(portlet-api|javax\\.servlet-api)-.+jar$";
    @Parameter(defaultValue="${vaadin.eagerServerLoad}")
    private boolean eagerServerLoad;
    @Parameter(property="node.download.root")
    private String nodeDownloadRoot;
    @Parameter(property="node.version", defaultValue="v22.15.1")
    private String nodeVersion;
    @Parameter(property="node.auto.update", defaultValue="true")
    private boolean nodeAutoUpdate;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${mojoExecution}")
    MojoExecution mojoExecution;
    @Parameter(defaultValue="${project.basedir}")
    private File projectBasedir;
    @Parameter(property="require.home.node", defaultValue="false")
    private boolean requireHomeNodeExec;
    @Parameter(property="build.folder", defaultValue="${project.build.directory}")
    private String projectBuildDir;
    @Parameter(property="npm.postinstallPackages", defaultValue="")
    private List<String> postinstallPackages;
    @Parameter(property="react.enable", defaultValue="true")
    private boolean reactEnable;
    @Parameter(defaultValue="${project.basedir}/src/main/frontend/")
    private File frontendDirectory;
    @Parameter(property="npm.excludeWebComponents", defaultValue="false")
    private boolean npmExcludeWebComponents;
    @Parameter(property="vaadin.ignoreVersionChecks", defaultValue="false")
    private boolean frontendIgnoreVersionChecks;
    static final String CLASSFINDER_FIELD_NAME = "classFinder";
    private ClassFinder classFinder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PluginDescriptor pluginDescriptor = this.mojoExecution.getMojoDescriptor().getPluginDescriptor();
        this.checkFlowCompatibility(pluginDescriptor);
        Reflector reflector = this.getOrCreateReflector();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(reflector.getIsolatedClassLoader());
        try {
            Mojo task = reflector.createMojo(this);
            this.findExecuteMethod(task.getClass()).invoke((Object)task, new Object[0]);
            reflector.logIncompatibilities(arg_0 -> ((Log)this.getLog()).debug(arg_0));
        }
        catch (MojoExecutionException | MojoFailureException e) {
            this.logTroubleshootingHints(reflector, e);
            throw e;
        }
        catch (Exception e) {
            this.logTroubleshootingHints(reflector, e);
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private void logTroubleshootingHints(Reflector reflector, Throwable ex) {
        reflector.logIncompatibilities(arg_0 -> ((Log)this.getLog()).warn(arg_0));
        if (ex instanceof InvocationTargetException) {
            ex = ex.getCause();
        }
        StringBuilder errorMessage = new StringBuilder(ex.getMessage());
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            if (cause.getMessage() == null) continue;
            errorMessage.append(" ").append(cause.getMessage());
        }
        this.getLog().error((CharSequence)("The build process encountered an error: " + errorMessage));
        this.logError("To diagnose the issue, please re-run Maven with the -X option to enable detailed debug logging and identify the root cause.");
    }

    public void executeInternal() throws MojoFailureException {
        long start = System.nanoTime();
        try {
            BuildFrontendUtil.runDevBuildNodeUpdater((PluginAdapterBuild)this);
            BuildFrontendUtil.removeBuildFile((PluginAdapterBuild)this);
        }
        catch (ExecutionFailedException | IOException | URISyntaxException exception) {
            throw new MojoFailureException("Could not execute build-dev-bundle goal", exception);
        }
        long ms = (System.nanoTime() - start) / 1000000L;
        this.getLog().info((CharSequence)("Dev-bundle build completed in " + ms + " ms."));
    }

    public File frontendResourcesDirectory() {
        return new File(this.projectBasedir, "src/main/resources/META-INF/resources/frontend");
    }

    public boolean generateBundle() {
        return true;
    }

    public boolean generateEmbeddableWebComponents() {
        return this.generateEmbeddableWebComponents;
    }

    public boolean optimizeBundle() {
        return false;
    }

    public boolean runNpmInstall() {
        return true;
    }

    public boolean ciBuild() {
        return false;
    }

    public boolean forceProductionBuild() {
        return false;
    }

    public boolean compressBundle() {
        return false;
    }

    @Deprecated(forRemoval=true)
    public static List<String> getClasspathElements(MavenProject project) {
        try {
            Stream classpathElements = Stream.of(project.getRuntimeClasspathElements().stream(), project.getSystemClasspathElements().stream(), project.getCompileClasspathElements().stream().filter(s -> s.matches(INCLUDE_FROM_COMPILE_DEPS_REGEX))).flatMap(Function.identity());
            return classpathElements.collect(Collectors.toList());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException(String.format("Failed to retrieve runtime classpath elements from project '%s'", project), e);
        }
    }

    public File applicationProperties() {
        return new File(this.projectBasedir, "/src/main/resources/application.properties");
    }

    public boolean eagerServerLoad() {
        return this.eagerServerLoad;
    }

    public File frontendDirectory() {
        return this.frontendDirectory;
    }

    public File generatedTsFolder() {
        return new File(this.frontendDirectory(), "generated");
    }

    public ClassFinder getClassFinder() {
        if (this.classFinder == null) {
            URLClassLoader classLoader = this.getOrCreateReflector().getIsolatedClassLoader();
            this.classFinder = new ReflectionsClassFinder((ClassLoader)classLoader, classLoader.getURLs());
        }
        return this.classFinder;
    }

    public Set<File> getJarFiles() {
        return this.project.getArtifacts().stream().filter(artifact -> "jar".equals(artifact.getType())).map(Artifact::getFile).collect(Collectors.toSet());
    }

    public boolean isDebugEnabled() {
        return this.getLog().isDebugEnabled();
    }

    public File javaSourceFolder() {
        return new File(this.projectBasedir, "/src/main/java");
    }

    public File javaResourceFolder() {
        return new File(this.projectBasedir, "/src/main/resources");
    }

    public void logDebug(CharSequence debugMessage) {
        this.getLog().debug(debugMessage);
    }

    public void logDebug(CharSequence debugMessage, Throwable e) {
        this.getLog().debug(debugMessage, e);
    }

    public void logInfo(CharSequence infoMessage) {
        this.getLog().info(infoMessage);
    }

    public void logWarn(CharSequence warning) {
        this.getLog().warn(warning);
    }

    public void logError(CharSequence error) {
        this.getLog().error(error);
    }

    public void logWarn(CharSequence warning, Throwable e) {
        this.getLog().warn(warning, e);
    }

    public void logError(CharSequence error, Throwable e) {
        this.getLog().error(error, e);
    }

    public URI nodeDownloadRoot() throws URISyntaxException {
        if (this.nodeDownloadRoot == null) {
            this.nodeDownloadRoot = Platform.guess().getNodeDownloadRoot();
        }
        try {
            return new URI(this.nodeDownloadRoot);
        }
        catch (URISyntaxException e) {
            this.logError("Failed to parse nodeDownloadRoot uri", e);
            throw new URISyntaxException(this.nodeDownloadRoot, "Failed to parse nodeDownloadRoot uri");
        }
    }

    public boolean nodeAutoUpdate() {
        return this.nodeAutoUpdate;
    }

    public String nodeVersion() {
        return this.nodeVersion;
    }

    public File npmFolder() {
        return this.projectBasedir;
    }

    public File openApiJsonFile() {
        return new File(this.projectBuildDir, "/generated-resources/openapi.json");
    }

    public boolean pnpmEnable() {
        return false;
    }

    public boolean bunEnable() {
        return false;
    }

    public boolean useGlobalPnpm() {
        return false;
    }

    public Path projectBaseDirectory() {
        return this.projectBasedir.toPath();
    }

    public boolean requireHomeNodeExec() {
        return this.requireHomeNodeExec;
    }

    public File servletResourceOutputDirectory() {
        return new File(this.project.getBuild().getOutputDirectory(), "META-INF/VAADIN/");
    }

    public File webpackOutputDirectory() {
        return new File(this.project.getBuild().getOutputDirectory(), "META-INF/VAADIN/webapp/");
    }

    public boolean isJarProject() {
        return "jar".equals(this.project.getPackaging());
    }

    public String buildFolder() {
        if (this.projectBuildDir.startsWith(this.projectBasedir.toString())) {
            return this.projectBaseDirectory().relativize(Paths.get(this.projectBuildDir, new String[0])).toString();
        }
        return this.projectBuildDir;
    }

    public List<String> postinstallPackages() {
        return this.postinstallPackages;
    }

    public boolean isFrontendHotdeploy() {
        return false;
    }

    public boolean skipDevBundleBuild() {
        return false;
    }

    public boolean isPrepareFrontendCacheDisabled() {
        return false;
    }

    public boolean isReactEnabled() {
        return this.reactEnable;
    }

    public String applicationIdentifier() {
        return this.project.getGroupId() + ":" + this.project.getArtifactId();
    }

    public List<String> frontendExtraFileExtensions() {
        return Collections.emptyList();
    }

    public boolean checkRuntimeDependency(String groupId, String artifactId, Consumer<String> missingDependencyMessageConsumer) {
        return false;
    }

    public boolean isNpmExcludeWebComponents() {
        return this.npmExcludeWebComponents;
    }

    public boolean isFrontendIgnoreVersionChecks() {
        return this.frontendIgnoreVersionChecks;
    }

    private static URLClassLoader createIsolatedClassLoader(MavenProject project, MojoExecution mojoExecution) {
        ClassLoader mavenApiClassLoader;
        ArrayList<URL> urls = new ArrayList<URL>();
        String outputDirectory = project.getBuild().getOutputDirectory();
        if (outputDirectory != null) {
            urls.add(FlowFileUtils.convertToUrl((File)new File(outputDirectory)));
        }
        Function<Artifact, String> keyMapper = artifact -> artifact.getGroupId() + ":" + artifact.getArtifactId();
        HashMap projectDependencies = new HashMap(project.getArtifacts().stream().filter(artifact -> artifact.getFile() != null && artifact.getArtifactHandler().isAddedToClasspath() && ("compile".equals(artifact.getScope()) || "runtime".equals(artifact.getScope()) || "system".equals(artifact.getScope()) || "provided".equals(artifact.getScope()) && artifact.getFile().getPath().matches(INCLUDE_FROM_COMPILE_DEPS_REGEX))).collect(Collectors.toMap(keyMapper, Function.identity())));
        if (mojoExecution != null) {
            mojoExecution.getMojoDescriptor().getPluginDescriptor().getArtifacts().stream().filter(artifact -> !projectDependencies.containsKey(keyMapper.apply((Artifact)artifact))).forEach(artifact -> projectDependencies.put((String)keyMapper.apply((Artifact)artifact), artifact));
        }
        projectDependencies.values().stream().map(artifact -> FlowFileUtils.convertToUrl((File)artifact.getFile())).forEach(urls::add);
        if (mojoExecution != null) {
            ClassRealm pluginClassRealm = mojoExecution.getMojoDescriptor().getPluginDescriptor().getClassRealm();
            try {
                mavenApiClassLoader = pluginClassRealm.getWorld().getRealm("maven.api");
            }
            catch (NoSuchRealmException e) {
                throw new RuntimeException(e);
            }
        }
        mavenApiClassLoader = Mojo.class.getClassLoader();
        if (mavenApiClassLoader instanceof ClassRealm) {
            ClassRealm classRealm = (ClassRealm)mavenApiClassLoader;
            try {
                mavenApiClassLoader = classRealm.getWorld().getRealm("maven.api");
            }
            catch (NoSuchRealmException noSuchRealmException) {
                // empty catch block
            }
        }
        return new URLClassLoader((URL[])urls.toArray(URL[]::new), mavenApiClassLoader);
    }

    private void checkFlowCompatibility(PluginDescriptor pluginDescriptor) {
        Predicate<Artifact> isFlowServer = artifact -> "com.vaadin".equals(artifact.getGroupId()) && "flow-server".equals(artifact.getArtifactId());
        String projectFlowVersion = this.project.getArtifacts().stream().filter(isFlowServer).map(Artifact::getVersion).findFirst().orElse(null);
        String pluginFlowVersion = pluginDescriptor.getArtifacts().stream().filter(isFlowServer).map(Artifact::getVersion).findFirst().orElse(null);
        if (projectFlowVersion != null && !Objects.equals(projectFlowVersion, pluginFlowVersion)) {
            this.getLog().warn((CharSequence)("Vaadin Flow used in project does not match the version expected by the Vaadin plugin. Flow version for project is " + projectFlowVersion + ", Vaadin plugin is built for Flow version " + pluginFlowVersion + "."));
        }
    }

    private Reflector getOrCreateReflector() {
        Map pluginContext = this.getPluginContext();
        String pluginKey = this.mojoExecution.getPlugin().getKey();
        String reflectorKey = Reflector.class.getName() + "-" + pluginKey + "-" + this.mojoExecution.getLifecyclePhase();
        if (pluginContext != null && pluginContext.containsKey(reflectorKey)) {
            this.getLog().debug((CharSequence)("Using cached Reflector for plugin " + pluginKey + " and phase " + this.mojoExecution.getLifecyclePhase()));
            return Reflector.adapt(pluginContext.get(reflectorKey));
        }
        Reflector reflector = Reflector.of(this.project, this.mojoExecution);
        if (pluginContext != null) {
            pluginContext.put(reflectorKey, reflector);
            this.getLog().debug((CharSequence)("Cached Reflector for plugin " + pluginKey + " and phase " + this.mojoExecution.getLifecyclePhase()));
        }
        return reflector;
    }

    private Method findExecuteMethod(Class<?> taskClass) throws NoSuchMethodException {
        while (taskClass != null && taskClass != Object.class) {
            try {
                Method executeInternal = taskClass.getDeclaredMethod("executeInternal", new Class[0]);
                executeInternal.setAccessible(true);
                return executeInternal;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                taskClass = taskClass.getSuperclass();
            }
        }
        throw new NoSuchMethodException("Method executeInternal not found in " + ((Object)((Object)this)).getClass().getName());
    }
}

