/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.binder.BindingException;
import com.vaadin.flow.data.binder.BindingExceptionHandler;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.NodeOwner;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.util.Optional;

public class DefaultBindingExceptionHandler
implements BindingExceptionHandler {
    private static final String ID = "id";
    private static final String LABEL = "label";

    @Override
    public Optional<BindingException> handleException(HasValue<?, ?> field, Exception exception) {
        String id;
        if (!(field instanceof HasElement)) {
            return Optional.empty();
        }
        Element element = ((HasElement)field).getElement();
        StringBuilder majorProperties = new StringBuilder();
        String label = element.getProperty(LABEL);
        if (label != null) {
            this.appendProperty(majorProperties, LABEL, label);
        }
        if ((id = element.getProperty(ID)) != null) {
            this.appendProperty(majorProperties, ID, id);
        }
        UI ui = this.getUI(element);
        if (majorProperties.length() == 0 && ui != null && ui.getSession() != null && !ApplicationConfiguration.get((VaadinContext)ui.getSession().getService().getContext()).isProductionMode()) {
            element.getAttributeNames().forEach(attribute -> this.appendProperty(majorProperties, (String)attribute, element.getAttribute(attribute)));
            element.getPropertyNames().forEach(property -> this.appendProperty(majorProperties, (String)property, element.getProperty(property)));
        }
        if (majorProperties.length() > 0) {
            majorProperties.insert(0, "An exception has been thrown inside binding logic for the field element [").append("]");
        }
        if (majorProperties.length() > 0) {
            return Optional.of(new BindingException(majorProperties.toString(), exception));
        }
        return Optional.empty();
    }

    private UI getUI(Element element) {
        NodeOwner owner = element.getNode().getOwner();
        UI ui = null;
        if (element.getNode().isAttached()) {
            ui = ((StateTree)owner).getUI();
        }
        if (ui == null) {
            ui = UI.getCurrent();
        }
        return ui;
    }

    private void appendProperty(StringBuilder builder, String name, String value) {
        if (builder.length() > 0) {
            builder.append(", ");
        }
        builder.append(name).append("='").append(value).append("'");
    }
}

