/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.data.provider.AbstractDataView;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.provider.InMemoryDataProviderHelpers;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.ListDataView;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class AbstractListDataView<T>
extends AbstractDataView<T>
implements ListDataView<T, AbstractListDataView<T>> {
    private static final String COLLECTION_TYPE_ERROR_MESSAGE_PATTERN = "DataProvider collection '%s' is not a list.";
    private static final String NULL_COLLECTION_ERROR_MESSAGE = "Items collection cannot be null";
    private static final String NULL_ITEM_ERROR_MESSAGE = "Item cannot be null";
    private final SerializableBiConsumer<SerializablePredicate<T>, SerializableComparator<T>> filterOrSortingChangedCallback;

    public AbstractListDataView(SerializableSupplier<? extends DataProvider<T, ?>> dataProviderSupplier, Component component, SerializableBiConsumer<SerializablePredicate<T>, SerializableComparator<T>> filterOrSortingChangedCallback) {
        super(dataProviderSupplier, component);
        Objects.requireNonNull(filterOrSortingChangedCallback, "Filter or Sorting Change Callback cannot be empty");
        this.filterOrSortingChangedCallback = filterOrSortingChangedCallback;
    }

    @Override
    public int getItemCount() {
        return this.getDataProvider().size(DataViewUtils.getQuery(this.component, false));
    }

    @Override
    public T getItem(int index) {
        this.validateItemIndex(index);
        return this.getItems().skip(index).findFirst().orElse(null);
    }

    @Override
    public Stream<T> getItems() {
        return this.getDataProvider().fetch(DataViewUtils.getQuery(this.component));
    }

    @Override
    public Optional<T> getNextItem(T item) {
        int index = this.getItemIndex(item);
        if (index < 0) {
            return Optional.empty();
        }
        return this.getItems().skip(index + 1).findFirst();
    }

    @Override
    public Optional<T> getPreviousItem(T item) {
        int index = this.getItemIndex(item);
        if (index <= 0) {
            return Optional.empty();
        }
        return this.getItems().skip(index - 1).findFirst();
    }

    @Override
    public AbstractListDataView<T> addFilter(SerializablePredicate<T> filter) {
        Objects.requireNonNull(filter, "Filter to add cannot be null");
        SerializablePredicate<T> newFilter = DataViewUtils.getComponentFilter(this.component).map(originalFilter -> originalFilter.and((Predicate)filter)).orElse(filter);
        return this.setFilter((SerializablePredicate)newFilter);
    }

    @Override
    public AbstractListDataView<T> removeFilters() {
        return this.setFilter((SerializablePredicate)null);
    }

    @Override
    public AbstractListDataView<T> setFilter(SerializablePredicate<T> filter) {
        DataViewUtils.setComponentFilter(this.component, filter);
        this.fireFilteringOrSortingChangeEvent(filter, DataViewUtils.getComponentSortComparator(this.component).orElse(null));
        return this;
    }

    @Override
    public AbstractListDataView<T> setSortComparator(SerializableComparator<T> sortComparator) {
        DataViewUtils.setComponentSortComparator(this.component, sortComparator);
        this.fireFilteringOrSortingChangeEvent(DataViewUtils.getComponentFilter(this.component).orElse(null), sortComparator);
        return this;
    }

    @Override
    public AbstractListDataView<T> addSortComparator(SerializableComparator<T> sortComparator) {
        Objects.requireNonNull(sortComparator, "Comparator to add cannot be null");
        Optional originalComparator = DataViewUtils.getComponentSortComparator(this.component);
        if (originalComparator.isPresent()) {
            return this.setSortComparator((SerializableComparator & Serializable)(a, b) -> {
                int result = ((SerializableComparator)originalComparator.get()).compare(a, b);
                if (result == 0) {
                    result = sortComparator.compare(a, b);
                }
                return result;
            });
        }
        return this.setSortComparator((SerializableComparator)sortComparator);
    }

    @Override
    public AbstractListDataView<T> removeSorting() {
        return this.setSortComparator((SerializableComparator)null);
    }

    @Override
    public <V1 extends Comparable<? super V1>> AbstractListDataView<T> setSortOrder(ValueProvider<T, V1> valueProvider, SortDirection sortDirection) {
        SerializableComparator<T> sortComparator = InMemoryDataProviderHelpers.propertyComparator(valueProvider, sortDirection);
        return this.setSortComparator((SerializableComparator)sortComparator);
    }

    @Override
    public <V1 extends Comparable<? super V1>> AbstractListDataView<T> addSortOrder(ValueProvider<T, V1> valueProvider, SortDirection sortDirection) {
        SerializableComparator<T> sortComparator = InMemoryDataProviderHelpers.propertyComparator(valueProvider, sortDirection);
        return this.addSortComparator((SerializableComparator)sortComparator);
    }

    @Override
    public boolean contains(T item) {
        return this.getItems().anyMatch(nextItem -> this.equals(item, nextItem));
    }

    @Override
    protected Class<?> getSupportedDataProviderType() {
        return ListDataProvider.class;
    }

    protected ListDataProvider<T> getDataProvider() {
        DataProvider dataProvider = (DataProvider)this.dataProviderSupplier.get();
        Objects.requireNonNull(dataProvider, "DataProvider cannot be null");
        this.verifyDataProviderType(dataProvider.getClass());
        return (ListDataProvider)dataProvider;
    }

    @Override
    public AbstractListDataView<T> addItem(T item) {
        ListDataProvider<T> dataProvider = this.getDataProvider();
        if (!this.contains(item)) {
            dataProvider.getItems().add(item);
            dataProvider.refreshAll();
        }
        return this;
    }

    @Override
    public AbstractListDataView<T> addItems(Collection<T> items) {
        Objects.requireNonNull(items, NULL_COLLECTION_ERROR_MESSAGE);
        if (!items.isEmpty()) {
            ListDataProvider<T> dataProvider = this.getDataProvider();
            Collection<T> backendItems = dataProvider.getItems();
            items.stream().filter(this::contains).forEach(item -> this.removeItemIfPresent(item, dataProvider));
            backendItems.addAll(items);
            dataProvider.refreshAll();
        }
        return this;
    }

    @Override
    public AbstractListDataView<T> addItemAfter(T item, T after) {
        this.addItemOnTarget(item, after, "Item to insert after is not available in the data", (SerializableFunction<Integer, Integer>)(SerializableFunction & Serializable)index -> index + 1);
        return this;
    }

    @Override
    public AbstractListDataView<T> addItemBefore(T item, T before) {
        this.addItemOnTarget(item, before, "Item to insert before is not available in the data", (SerializableFunction<Integer, Integer>)(SerializableFunction & Serializable)index -> index);
        return this;
    }

    @Override
    public AbstractListDataView<T> addItemsAfter(Collection<T> items, T after) {
        this.addItemCollectionOnTarget(items, after, "Item to insert after is not available in the data", (SerializableBiFunction<Integer, Boolean, Integer>)(SerializableBiFunction & Serializable)(index, containsTarget) -> containsTarget != false ? index : index + 1);
        return this;
    }

    @Override
    public AbstractListDataView<T> addItemsBefore(Collection<T> items, T before) {
        this.addItemCollectionOnTarget(items, before, "Item to insert before is not available in the data", (SerializableBiFunction<Integer, Boolean, Integer>)(SerializableBiFunction & Serializable)(index, containsTarget) -> index);
        return this;
    }

    @Override
    public AbstractListDataView<T> removeItem(T item) {
        ListDataProvider<T> dataProvider = this.getDataProvider();
        this.removeItemIfPresent(item, dataProvider);
        dataProvider.refreshAll();
        return this;
    }

    @Override
    public AbstractListDataView<T> removeItems(Collection<T> items) {
        Objects.requireNonNull(items, NULL_COLLECTION_ERROR_MESSAGE);
        if (items.isEmpty()) {
            return this;
        }
        ListDataProvider<T> dataProvider = this.getDataProvider();
        items.forEach(item -> this.removeItemIfPresent(item, dataProvider));
        dataProvider.refreshAll();
        return this;
    }

    protected void validateItemIndex(int itemIndex) {
        int dataSize = this.getItemCount();
        if (dataSize == 0) {
            throw new IndexOutOfBoundsException(String.format("Requested index %d on empty data.", itemIndex));
        }
        if (itemIndex < 0 || itemIndex >= dataSize) {
            throw new IndexOutOfBoundsException(String.format("Given index %d is outside of the accepted range '0 - %d'", itemIndex, dataSize - 1));
        }
    }

    private int getItemIndex(T item, Stream<T> stream) {
        Objects.requireNonNull(item, NULL_ITEM_ERROR_MESSAGE);
        AtomicInteger index = new AtomicInteger(-1);
        if (!stream.peek(nextItem -> index.incrementAndGet()).filter(nextItem -> this.equals(item, nextItem)).findFirst().isPresent()) {
            return -1;
        }
        return index.get();
    }

    private int getItemIndex(T item) {
        return this.getItemIndex(item, this.getItems());
    }

    private void removeItemIfPresent(T item, ListDataProvider<T> dataProvider) {
        dataProvider.getItems().removeIf(nextItem -> this.equals(item, nextItem));
    }

    private void addItemOnTarget(T item, T target, String targetItemNotFoundErrorMessage, SerializableFunction<Integer, Integer> insertItemsIndexProvider) {
        ListDataProvider<T> dataProvider = this.getDataProvider();
        Collection<T> backendItems = dataProvider.getItems();
        if (!(backendItems instanceof List)) {
            throw new IllegalArgumentException(String.format(COLLECTION_TYPE_ERROR_MESSAGE_PATTERN, backendItems.getClass().getSimpleName()));
        }
        if (this.equals(item, target)) {
            return;
        }
        if (!this.contains(target)) {
            throw new IllegalArgumentException(targetItemNotFoundErrorMessage);
        }
        List itemList = (List)backendItems;
        this.removeItemIfPresent(item, dataProvider);
        itemList.add((Integer)insertItemsIndexProvider.apply((Object)this.getItemIndex(target, itemList.stream())), item);
        dataProvider.refreshAll();
    }

    private void addItemCollectionOnTarget(Collection<T> items, T target, String targetItemNotFoundErrorMessage, SerializableBiFunction<Integer, Boolean, Integer> insertItemsIndexProvider) {
        Objects.requireNonNull(items, NULL_COLLECTION_ERROR_MESSAGE);
        if (items.isEmpty()) {
            return;
        }
        ListDataProvider<T> dataProvider = this.getDataProvider();
        Collection<T> backendItems = dataProvider.getItems();
        if (!(backendItems instanceof List)) {
            throw new IllegalArgumentException(String.format(COLLECTION_TYPE_ERROR_MESSAGE_PATTERN, backendItems.getClass().getSimpleName()));
        }
        if (!this.contains(target)) {
            throw new IllegalArgumentException(targetItemNotFoundErrorMessage);
        }
        List itemList = (List)backendItems;
        AtomicBoolean containsTargetItem = new AtomicBoolean(false);
        items.forEach(item -> {
            if (this.equals(target, item)) {
                containsTargetItem.set(true);
            } else {
                this.removeItemIfPresent(item, dataProvider);
            }
        });
        int targetItemIndex = this.getItemIndex(target, itemList.stream());
        if (containsTargetItem.get()) {
            itemList.remove(targetItemIndex);
        }
        int indexToInsertItems = (Integer)insertItemsIndexProvider.apply((Object)targetItemIndex, (Object)containsTargetItem.get());
        itemList.addAll(indexToInsertItems, items);
        dataProvider.refreshAll();
    }

    private void fireFilteringOrSortingChangeEvent(SerializablePredicate<T> filter, SerializableComparator<T> sortComparator) {
        this.filterOrSortingChangedCallback.accept(filter, sortComparator);
    }
}

