/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.BindingValidationStatus;
import com.vaadin.flow.data.binder.ValidationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ValidationException
extends Exception {
    private final List<BindingValidationStatus<?>> fieldValidationErrors;
    private final List<ValidationResult> beanValidationErrors;

    public ValidationException(List<BindingValidationStatus<?>> fieldValidationErrors, List<ValidationResult> beanValidationErrors) {
        super("Validation has failed for some fields");
        this.fieldValidationErrors = Collections.unmodifiableList(fieldValidationErrors);
        this.beanValidationErrors = Collections.unmodifiableList(beanValidationErrors);
    }

    public List<ValidationResult> getValidationErrors() {
        ArrayList<ValidationResult> errors = new ArrayList<ValidationResult>(this.getFieldValidationErrors().stream().map(s -> s.getResult().get()).collect(Collectors.toList()));
        errors.addAll(this.getBeanValidationErrors());
        return errors;
    }

    public List<BindingValidationStatus<?>> getFieldValidationErrors() {
        return this.fieldValidationErrors;
    }

    public List<ValidationResult> getBeanValidationErrors() {
        return this.beanValidationErrors;
    }
}

