/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;

public class StringToDateConverter
implements Converter<String, Date> {
    protected DateFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormat format = DateFormat.getDateTimeInstance(2, 2, locale);
        format.setLenient(false);
        return format;
    }

    @Override
    public Result<Date> convertToModel(String value, ValueContext context) {
        if (value == null) {
            return Result.ok(null);
        }
        value = value.trim();
        ParsePosition parsePosition = new ParsePosition(0);
        Date parsedValue = this.getFormat(context.getLocale().orElse(null)).parse(value, parsePosition);
        if (parsePosition.getIndex() != value.length()) {
            return Result.error("Could not convert '" + value);
        }
        return Result.ok(parsedValue);
    }

    @Override
    public String convertToPresentation(Date value, ValueContext context) {
        if (value == null) {
            return null;
        }
        return this.getFormat(context.getLocale().orElse(null)).format(value);
    }
}

