import { LitElement } from 'lit-element';
import { Product } from './License';
interface ServerInfo {
    vaadinVersion: string;
    flowVersion: string;
    javaVersion: string;
    osVersion: string;
}
export declare class VaadinDevmodeGizmo extends LitElement {
    static BLUE_HSL: import("lit-element").CSSResult;
    static GREEN_HSL: import("lit-element").CSSResult;
    static GREY_HSL: import("lit-element").CSSResult;
    static YELLOW_HSL: import("lit-element").CSSResult;
    static RED_HSL: import("lit-element").CSSResult;
    static MAX_LOG_ROWS: number;
    static copyLogo: import("lit-element").SVGTemplateResult;
    static get styles(): import("lit-element").CSSResult;
    static DISMISSED_NOTIFICATIONS_IN_LOCAL_STORAGE: string;
    static ACTIVE_KEY_IN_SESSION_STORAGE: string;
    static TRIGGERED_KEY_IN_SESSION_STORAGE: string;
    static TRIGGERED_COUNT_KEY_IN_SESSION_STORAGE: string;
    static AUTO_DEMOTE_NOTIFICATION_DELAY: number;
    static HOTSWAP_AGENT: string;
    static JREBEL: string;
    static SPRING_BOOT_DEVTOOLS: string;
    static BACKEND_DISPLAY_NAME: Record<string, string>;
    static get isActive(): boolean;
    static notificationDismissed(persistentId: string): boolean;
    url?: string;
    liveReloadDisabled?: boolean;
    backend?: string;
    springBootLiveReloadPort?: number;
    expanded: boolean;
    messages: Message[];
    splashMessage?: string;
    notifications: Message[];
    frontendStatus: ConnectionStatus;
    javaStatus: ConnectionStatus;
    activeTab: string;
    serverInfo: ServerInfo;
    javaConnection?: Connection;
    frontendConnection?: Connection;
    nextMessageId: number;
    disableEventListener?: EventListener;
    transitionDuration: number;
    constructor();
    openWebSocketConnection(): void;
    getDedicatedWebSocketUrl(): string | undefined;
    getSpringBootWebSocketUrl(location: any): string;
    connectedCallback(): void;
    format(o: any): string;
    catchErrors(): void;
    disconnectedCallback(): void;
    toggleExpanded(): void;
    showSplashMessage(msg: string | undefined): void;
    demoteSplashMessage(): void;
    checkLicense(productInfo: Product): void;
    log(type: MessageType, message: string, details?: string, link?: string): void;
    showNotification(type: MessageType, message: string, details?: string, link?: string, persistentId?: string): void;
    dismissNotification(id: number): void;
    findNotificationIndex(id: number): number;
    toggleDontShowAgain(id: number): void;
    setActive(yes: boolean): void;
    getStatusColor(status: ConnectionStatus | undefined): import("lit-element").CSSResult;
    renderMessage(messageObject: Message): import("lit-element").TemplateResult;
    render(): import("lit-element").TemplateResult;
    copyInfoToClipboard(): void;
}
declare enum ConnectionStatus {
    ACTIVE = "active",
    INACTIVE = "inactive",
    UNAVAILABLE = "unavailable",
    ERROR = "error"
}
declare class Connection extends Object {
    static HEARTBEAT_INTERVAL: number;
    status: ConnectionStatus;
    webSocket?: WebSocket;
    constructor(url?: string);
    onHandshake(): void;
    onReload(): void;
    onConnectionError(_: string): void;
    onStatusChange(_: ConnectionStatus): void;
    onMessage(message: any): void;
    handleMessage(msg: any): void;
    handleError(msg: any): void;
    private send;
    setActive(yes: boolean): void;
    setStatus(status: ConnectionStatus): void;
    sendLicenseCheck(product: Product): void;
}
declare enum MessageType {
    LOG = "log",
    INFORMATION = "information",
    WARNING = "warning",
    ERROR = "error"
}
interface Message {
    id: number;
    type: MessageType;
    message: string;
    details?: string;
    link?: string;
    persistentId?: string;
    dontShowAgain: boolean;
    deleted: boolean;
}
export {};
