/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectFileHandler
implements CopilotCommand {
    private static final String COPILOT_UNDO_LABEL = CopilotIDEPlugin.undoLabel("File Update");
    private final ProjectManager projectManager;

    public ProjectFileHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-project-file")) {
            String filename = data.getString("filename");
            String reqId = data.getString("reqId");
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", reqId);
            try {
                responseData.put("content", this.projectManager.readFile(filename));
                devToolsInterface.send("copilot-project-file", responseData);
            }
            catch (IOException e) {
                responseData.put("error", true);
                devToolsInterface.send("copilot-project-file", responseData);
                this.getLogger().error("Unable to read project file {}", (Object)filename, (Object)e);
            }
            return true;
        }
        if (command.equals("write-project-file")) {
            String filename = data.getString("filename");
            String reqId = data.getString("reqId");
            String content = data.getString("content");
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", reqId);
            try {
                this.projectManager.writeFile(filename, COPILOT_UNDO_LABEL, content);
                devToolsInterface.send("copilot-project-file-written", responseData);
            }
            catch (IOException e) {
                responseData.put("error", true);
                devToolsInterface.send("copilot-project-file-written", responseData);
                this.getLogger().error("Unable to write project file {}", (Object)filename, (Object)e);
            }
            return true;
        }
        return false;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

