/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.themeeditor;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.plugins.themeeditor.Editor;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class CopilotEditor
extends Editor {
    private static final String COPILOT_FILE_UPDATE_UNDO_LABEL = CopilotIDEPlugin.undoLabel("File Update");
    protected final ProjectManager projectManager;

    public CopilotEditor(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Override
    public int modifyClass(File f, Function<CompilationUnit, List<Editor.Modification>> modifier) {
        try {
            String source = this.projectManager.readFile(f);
            CompilationUnit cu = this.parseSource(source);
            List<Editor.Modification> mods = modifier.apply(cu);
            Collections.sort(mods);
            int sourceOffset = 0;
            for (Editor.Modification mod : mods) {
                mod.apply();
                sourceOffset += mod.sourceOffset();
            }
            String newSource = LexicalPreservingPrinter.print((Node)cu);
            if (newSource.equals(source)) {
                throw new UnsupportedOperationException("Unable to edit file");
            }
            this.projectManager.writeFile(f, COPILOT_FILE_UPDATE_UNDO_LABEL, newSource);
            return sourceOffset;
        }
        catch (IOException var13) {
            throw new UnsupportedOperationException(var13);
        }
    }
}

