/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.vaadin.collaborationengine.AbstractCollaborationManager;
import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.CollaborationEngineServiceInitListener;
import com.vaadin.collaborationengine.CollaborationList;
import com.vaadin.collaborationengine.CollaborationMap;
import com.vaadin.collaborationengine.ComponentConnectionContext;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.EntryScope;
import com.vaadin.collaborationengine.HasExpirationTimeout;
import com.vaadin.collaborationengine.HighlightHandler;
import com.vaadin.collaborationengine.ListChangeEvent;
import com.vaadin.collaborationengine.ListKey;
import com.vaadin.collaborationengine.ListOperation;
import com.vaadin.collaborationengine.MapChangeEvent;
import com.vaadin.collaborationengine.PropertyChangeHandler;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.Registration;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FormManager
extends AbstractCollaborationManager
implements HasExpirationTimeout {
    static final String COLLECTION_NAME;
    private transient CollaborationMap map;
    private transient CollaborationList list;
    private ConnectionContext context;
    private final Map<FocusedEditor, UserEntry> userEntries = new LinkedHashMap<FocusedEditor, UserEntry>();
    private PropertyChangeHandler propertyChangeHandler;
    private HighlightHandler highlightHandler;
    private transient Registration subscribeRegistration;
    private Duration expirationTimeout;

    @Deprecated(since="6.1", forRemoval=true)
    public FormManager(ConnectionContext context, UserInfo localUser, String topicId, CollaborationEngine collaborationEngine) {
        this(context, localUser, topicId, (SerializableSupplier<CollaborationEngine>)(SerializableSupplier & Serializable)() -> collaborationEngine);
    }

    public FormManager(ConnectionContext context, UserInfo localUser, String topicId, SerializableSupplier<CollaborationEngine> ceSupplier) {
        super(localUser, topicId, ceSupplier);
        this.context = context;
        this.openTopicConnection(context, (SerializableFunction<TopicConnection, Registration>)((SerializableFunction & Serializable)this::onConnectionActivate));
    }

    public FormManager(Component component, UserInfo localUser, String topicId) {
        this((ConnectionContext)new ComponentConnectionContext(component), localUser, topicId, (SerializableSupplier<CollaborationEngine>)((SerializableSupplier & Serializable)CollaborationEngine::getInstance));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        CollaborationEngineServiceInitListener.addReinitializer(this::reinitialize);
    }

    private void reinitialize(VaadinService service) {
        this.openTopicConnection(this.context, (SerializableFunction<TopicConnection, Registration>)((SerializableFunction & Serializable)this::onConnectionActivate));
    }

    public void setValue(String propertyName, Object value) {
        Objects.requireNonNull(propertyName, "Property name can't be null.");
        if (this.map != null) {
            this.map.put(propertyName, value);
        }
    }

    <T> T getValue(String propertyName, Class<T> type) {
        if (this.map != null) {
            return this.map.get(propertyName, type);
        }
        return null;
    }

    <T> T getValue(String propertyName, TypeReference<T> typeReference) {
        if (this.map != null) {
            return this.map.get(propertyName, typeReference);
        }
        return null;
    }

    public void highlight(String propertyName, boolean highlight) {
        this.highlight(propertyName, highlight, this.getLocalUser());
    }

    public void highlight(String propertyName, boolean highlight, int fieldIndex) {
        this.highlight(propertyName, highlight, this.getLocalUser(), fieldIndex);
    }

    void highlight(String propertyName, boolean highlight, UserInfo user) {
        this.highlight(propertyName, highlight, user, 0);
    }

    void highlight(String propertyName, boolean highlight, UserInfo user, int fieldIndex) {
        Objects.requireNonNull(propertyName, "Property name can't be null.");
        Objects.requireNonNull(user, "User can't be null.");
        if (this.list != null) {
            if (highlight) {
                ListOperation operation = ListOperation.insertLast(new FocusedEditor(user, fieldIndex, propertyName)).withScope(EntryScope.CONNECTION);
                this.list.apply(operation);
            } else {
                this.list.getKeys().forEach(key -> {
                    FocusedEditor editor = this.list.getItem((ListKey)key, FocusedEditor.class);
                    if (editor.propertyName.equals(propertyName) && editor.user.equals(user)) {
                        ListOperation operation = ListOperation.set(key, null).withScope(EntryScope.CONNECTION);
                        this.list.apply(operation);
                    }
                });
            }
        }
    }

    boolean isHighlight(String propertyName) {
        if (this.list != null) {
            for (FocusedEditor editor : this.list.getItems(FocusedEditor.class)) {
                if (!editor.propertyName.equals(propertyName)) continue;
                return true;
            }
        }
        return false;
    }

    public void setPropertyChangeHandler(PropertyChangeHandler handler) {
        this.propertyChangeHandler = handler;
        if (handler != null && this.map != null) {
            this.map.subscribe(this::onMapChange);
        }
    }

    public void setHighlightHandler(HighlightHandler handler) {
        this.resetEntries();
        this.highlightHandler = handler;
        if (handler != null && this.list != null) {
            this.subscribeRegistration = this.list.subscribe(this::onListChange);
        }
    }

    @Override
    public void setExpirationTimeout(Duration expirationTimeout) {
        this.expirationTimeout = expirationTimeout;
        if (this.map != null) {
            this.map.setExpirationTimeout(expirationTimeout);
        }
    }

    @Override
    public Optional<Duration> getExpirationTimeout() {
        return Optional.ofNullable(this.expirationTimeout);
    }

    private Registration onConnectionActivate(TopicConnection topicConnection) {
        this.map = topicConnection.getNamedMap(COLLECTION_NAME);
        this.map.subscribe(this::onMapChange);
        this.list = topicConnection.getNamedList(COLLECTION_NAME);
        if (this.highlightHandler != null && this.subscribeRegistration == null) {
            this.subscribeRegistration = this.list.subscribe(this::onListChange);
        }
        if (this.expirationTimeout != null) {
            this.map.setExpirationTimeout(this.expirationTimeout);
        }
        return this::onConnectionDeactivate;
    }

    private void onConnectionDeactivate() {
        this.map = null;
        this.list = null;
        this.resetEntries();
    }

    private void onMapChange(MapChangeEvent event) {
        this.applyPropertyChangeHandler(event.getKey(), event.getValue(Object.class));
    }

    private void onListChange(ListChangeEvent event) {
        switch (event.getType()) {
            case INSERT: {
                FocusedEditor editor = event.getValue(FocusedEditor.class);
                this.handleNewHighlight(editor);
                break;
            }
            case SET: {
                if (event.getValue(FocusedEditor.class) != null) break;
                FocusedEditor oldEditor = event.getOldValue(FocusedEditor.class);
                this.handleRemovedHighlight(oldEditor);
                break;
            }
        }
    }

    private void applyPropertyChangeHandler(String propertyName, Object value) {
        if (this.propertyChangeHandler != null) {
            DefaultPropertyChangeEvent event = new DefaultPropertyChangeEvent(propertyName, value);
            this.propertyChangeHandler.handlePropertyChange(event);
        }
    }

    private void handleNewHighlight(FocusedEditor editor) {
        UserEntry userEntry = this.userEntries.computeIfAbsent(editor, ignore -> new UserEntry());
        if (userEntry.count++ == 0 && this.highlightHandler != null) {
            assert (userEntry.registration == null);
            userEntry.registration = this.highlightHandler.handleHighlight(new DefaultHighlightContext(editor.user, editor.propertyName, editor.fieldIndex));
        }
    }

    private void handleRemovedHighlight(FocusedEditor editor) {
        UserEntry userEntry = this.userEntries.get(editor);
        assert (userEntry != null);
        if (--userEntry.count == 0) {
            this.removeRegistration(userEntry);
            this.userEntries.remove(editor);
        }
    }

    private void removeRegistration(UserEntry entry) {
        Registration registration = entry.registration;
        if (registration != null) {
            registration.remove();
            entry.registration = null;
        }
    }

    private void resetEntries() {
        if (this.subscribeRegistration != null) {
            this.subscribeRegistration.remove();
            this.subscribeRegistration = null;
        }
        this.userEntries.values().forEach(this::removeRegistration);
        this.userEntries.clear();
    }

    static {
        UsageStatistics.markAsUsed((String)"vaadin-collaboration-engine/FormManager", (String)"6.4");
        COLLECTION_NAME = FormManager.class.getName();
    }

    static final class FocusedEditor
    implements Serializable {
        public final UserInfo user;
        public final int fieldIndex;
        public final String propertyName;

        @JsonCreator
        public FocusedEditor(@JsonProperty(value="user") UserInfo user, @JsonProperty(value="fieldIndex") int fieldIndex, @JsonProperty(value="propertyName") String propertyName) {
            this.user = user;
            this.fieldIndex = fieldIndex;
            this.propertyName = propertyName;
        }

        public boolean equals(Object other) {
            if (other instanceof FocusedEditor) {
                FocusedEditor otherEditor = (FocusedEditor)other;
                return Objects.equals(otherEditor.user.getId(), this.user.getId()) && Objects.equals(otherEditor.propertyName, this.propertyName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.user.getId(), this.propertyName);
        }
    }

    static class DefaultPropertyChangeEvent
    implements PropertyChangeHandler.PropertyChangeEvent {
        private final String propertyName;
        private final Object value;

        public DefaultPropertyChangeEvent(String propertyName, Object value) {
            this.propertyName = propertyName;
            this.value = value;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static class UserEntry
    implements Serializable {
        private int count = 0;
        private Registration registration;

        private UserEntry() {
        }
    }

    static class DefaultHighlightContext
    implements HighlightHandler.HighlightContext {
        private final UserInfo user;
        private final String propertyName;
        private final int fieldIndex;

        public DefaultHighlightContext(UserInfo user, String propertyName, int fieldIndex) {
            this.user = user;
            this.propertyName = propertyName;
            this.fieldIndex = fieldIndex;
        }

        @Override
        public UserInfo getUser() {
            return this.user;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }
    }
}

