/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.tmdb2.services;

import com.uwetrottmann.tmdb2.entities.Account;
import com.uwetrottmann.tmdb2.entities.FavoriteMedia;
import com.uwetrottmann.tmdb2.entities.ListResultsPage;
import com.uwetrottmann.tmdb2.entities.MovieResultsPage;
import com.uwetrottmann.tmdb2.entities.Status;
import com.uwetrottmann.tmdb2.entities.TvEpisodeResultsPage;
import com.uwetrottmann.tmdb2.entities.TvShowResultsPage;
import com.uwetrottmann.tmdb2.entities.WatchlistMedia;
import com.uwetrottmann.tmdb2.enumerations.SortBy;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface AccountService {
    @GET(value="account")
    public Call<Account> summary();

    @GET(value="account/{account_id}/lists")
    public Call<ListResultsPage> lists(@Path(value="account_id") Integer var1);

    @GET(value="account/{account_id}/favorite/movies")
    public Call<MovieResultsPage> favoriteMovies(@Path(value="account_id") Integer var1, @Query(value="language") String var2, @Query(value="sort_by") SortBy var3, @Query(value="page") Integer var4);

    @GET(value="account/{account_id}/favorite/tv")
    public Call<TvShowResultsPage> favoriteTvShows(@Path(value="account_id") Integer var1, @Query(value="language") String var2, @Query(value="sort_by") SortBy var3, @Query(value="page") Integer var4);

    @POST(value="account/{account_id}/favorite")
    public Call<Status> favorite(@Path(value="account_id") Integer var1, @Body FavoriteMedia var2);

    @GET(value="account/{account_id}/rated/movies")
    public Call<MovieResultsPage> ratedMovies(@Path(value="account_id") Integer var1, @Query(value="language") String var2, @Query(value="sort_by") SortBy var3, @Query(value="page") Integer var4);

    @GET(value="account/{account_id}/rated/tv")
    public Call<TvShowResultsPage> ratedTvShows(@Path(value="account_id") Integer var1, @Query(value="language") String var2, @Query(value="sort_by") SortBy var3, @Query(value="page") Integer var4);

    @GET(value="account/{account_id}/rated/tv/episodes")
    public Call<TvEpisodeResultsPage> ratedTvShowEpisodes(@Path(value="account_id") Integer var1, @Query(value="language") String var2, @Query(value="sort_by") SortBy var3, @Query(value="page") Integer var4);

    @GET(value="account/{account_id}/watchlist/movies")
    public Call<MovieResultsPage> watchlistMovies(@Path(value="account_id") Integer var1, @Query(value="language") String var2, @Query(value="sort_by") SortBy var3, @Query(value="page") Integer var4);

    @GET(value="account/{account_id}/watchlist/tv")
    public Call<TvShowResultsPage> watchlistTvShows(@Path(value="account_id") Integer var1, @Query(value="language") String var2, @Query(value="sort_by") SortBy var3, @Query(value="page") Integer var4);

    @POST(value="account/{account_id}/watchlist")
    public Call<Status> watchlist(@Path(value="account_id") Integer var1, @Body WatchlistMedia var2);
}

