/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.reports.model.Precision;
import com.urbanairship.api.reports.model.WebResponseReportResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class WebResponseReportRequest
implements Request<WebResponseReportResponse> {
    private static final String API_WEB_RESPONSE_REPORT = "/api/reports/web/interaction";
    private final String path;
    private final String appKey;
    private final DateTime start;
    private DateTime end;
    private Precision precision;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private WebResponseReportRequest(String path, String appKey, DateTime start) {
        this.path = path;
        this.appKey = appKey;
        this.start = start;
    }

    public static WebResponseReportRequest newRequest(String appKey, DateTime start) {
        return new WebResponseReportRequest(API_WEB_RESPONSE_REPORT, appKey, start);
    }

    public WebResponseReportRequest setEndTime(DateTime end) {
        this.end = end;
        return this;
    }

    public WebResponseReportRequest setPrecision(Precision precision) {
        this.precision = precision;
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        URI uri;
        URIBuilder builder = new URIBuilder(RequestUtils.resolveURI(baseUri, this.path));
        Preconditions.checkNotNull((Object)this.start, (Object)"start cannot be null");
        builder.addParameter("app_key", this.appKey);
        builder.addParameter("start", this.start.toString(DateFormats.DATE_FORMATTER));
        if (this.precision != null) {
            builder.addParameter("precision", this.precision.toString());
        }
        if (this.end != null) {
            Preconditions.checkArgument((boolean)this.end.isAfter((ReadableInstant)this.start), (Object)"end date must occur after start date");
            builder.addParameter("end", this.end.toString(DateFormats.DATE_FORMATTER));
        }
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    @Override
    public ResponseParser<WebResponseReportResponse> getResponseParser() {
        return response -> (WebResponseReportResponse)MAPPER.readValue(response, WebResponseReportResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }

    static {
        MAPPER.registerModule((Module)new GuavaModule());
    }
}

