/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.richpush;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.notification.richpush.RichPushIcon;
import com.urbanairship.api.push.model.notification.richpush.RichPushTemplate;
import java.util.Map;
import java.util.Optional;

public final class RichPushMessage {
    public static final String CONTENT_TYPE_DEFAULT = "text/html";
    public static final String CONTENT_ENCODING_DEFAULT = "utf8";
    private final String title;
    private final String body;
    private final String contentType;
    private final String contentEncoding;
    private final Optional<ImmutableMap<String, String>> extra;
    private final Optional<PushExpiry> expiry;
    private final Optional<RichPushIcon> icons;
    private final Optional<RichPushTemplate> richPushTemplate;

    private RichPushMessage(String title, String body, String contentType, String contentEncoding, Optional<ImmutableMap<String, String>> extra, Optional<PushExpiry> expiry, Optional<RichPushIcon> icons, Optional<RichPushTemplate> richPushTemplate) {
        this.title = title;
        this.body = body;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.extra = extra;
        this.expiry = expiry;
        this.icons = icons;
        this.richPushTemplate = richPushTemplate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public Optional<ImmutableMap<String, String>> getExtra() {
        return this.extra;
    }

    public Optional<PushExpiry> getExpiry() {
        return this.expiry;
    }

    public Optional<RichPushIcon> getIcons() {
        return this.icons;
    }

    public Optional<RichPushTemplate> getRichPushTemplate() {
        return this.richPushTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RichPushMessage that = (RichPushMessage)o;
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) {
            return false;
        }
        if (this.contentEncoding != null ? !this.contentEncoding.equals(that.contentEncoding) : that.contentEncoding != null) {
            return false;
        }
        if (this.extra != null ? !this.extra.equals(that.extra) : that.extra != null) {
            return false;
        }
        if (this.expiry != null ? !this.expiry.equals(that.expiry) : that.expiry != null) {
            return false;
        }
        if (this.icons != null ? !this.icons.equals(that.icons) : that.icons != null) {
            return false;
        }
        return !(this.richPushTemplate != null ? !this.richPushTemplate.equals(that.richPushTemplate) : that.richPushTemplate != null);
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
        result = 31 * result + (this.contentEncoding != null ? this.contentEncoding.hashCode() : 0);
        result = 31 * result + (this.extra != null ? this.extra.hashCode() : 0);
        result = 31 * result + (this.expiry != null ? this.expiry.hashCode() : 0);
        result = 31 * result + (this.icons != null ? this.icons.hashCode() : 0);
        result = 31 * result + (this.richPushTemplate != null ? this.richPushTemplate.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RichPushMessage{title='" + this.title + "', body='" + this.body + "', contentType=" + this.contentType + ", contentEncoding=" + this.contentEncoding + ", extra=" + this.extra + ", expiry=" + this.expiry + ", icons=" + this.icons + ", richPushTemplate=" + this.richPushTemplate + '}';
    }

    public static final class Builder {
        private String title = null;
        private String body = null;
        private String contentType = null;
        private String contentEncoding = null;
        private ImmutableMap.Builder<String, String> extra = null;
        private PushExpiry expiry = null;
        private RichPushIcon icons = null;
        private RichPushTemplate richPushTemplate = null;

        private Builder() {
        }

        public Builder setTitle(String value) {
            this.title = value;
            return this;
        }

        public Builder setBody(String value) {
            this.body = value;
            return this;
        }

        public Builder setContentType(String value) {
            this.contentType = value;
            return this;
        }

        public Builder setContentEncoding(String value) {
            this.contentEncoding = value;
            return this;
        }

        public Builder addExtraEntry(String key, String value) {
            if (this.extra == null) {
                this.extra = ImmutableMap.builder();
            }
            this.extra.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllExtraEntries(Map<String, String> entries) {
            if (this.extra == null) {
                this.extra = ImmutableMap.builder();
            }
            this.extra.putAll(entries);
            return this;
        }

        public Builder setExpiry(PushExpiry value) {
            this.expiry = value;
            return this;
        }

        public Builder setIcons(RichPushIcon value) {
            this.icons = value;
            return this;
        }

        public Builder setRichPushTemplate(RichPushTemplate value) {
            this.richPushTemplate = value;
            return this;
        }

        public RichPushMessage build() {
            Preconditions.checkNotNull((Object)this.title, (Object)"Must supply a value for 'title'");
            Preconditions.checkNotNull((Object)this.body, (Object)"Must supply a value for 'body'");
            return new RichPushMessage(this.title, this.body, this.contentType != null ? this.contentType : RichPushMessage.CONTENT_TYPE_DEFAULT, this.contentEncoding != null ? this.contentEncoding : RichPushMessage.CONTENT_ENCODING_DEFAULT, this.extra != null ? Optional.ofNullable(this.extra.build()) : Optional.empty(), Optional.ofNullable(this.expiry), Optional.ofNullable(this.icons), Optional.ofNullable(this.richPushTemplate));
        }
    }
}

