/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.common.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.DateFormats;
import java.io.IOException;
import org.joda.time.DateTime;

public class DateTimeDeserializer
extends JsonDeserializer<DateTime> {
    public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String dateString = jp.getText();
        try {
            return DateFormats.DATE_PARSER.parseDateTime(dateString);
        }
        catch (Exception e) {
            throw new APIParsingException(String.format("Date string %s is not in accepted ISO 8601 UTC date format", dateString));
        }
    }
}

