/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.ios;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.Interactive;
import com.urbanairship.api.push.model.notification.actions.Actions;
import com.urbanairship.api.push.model.notification.ios.IOSAlertData;
import com.urbanairship.api.push.model.notification.ios.IOSBadgeData;
import com.urbanairship.api.push.model.notification.ios.IOSInterruptionLevel;
import com.urbanairship.api.push.model.notification.ios.IOSSoundData;
import com.urbanairship.api.push.model.notification.ios.IOSTemplate;
import com.urbanairship.api.push.model.notification.ios.MediaAttachment;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class IOSDevicePayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<IOSAlertData> alert;
    private final Optional<ImmutableMap<String, String>> extra;
    private final Optional<IOSBadgeData> badge;
    private final Optional<Boolean> contentAvailable;
    private final Optional<PushExpiry> expiry;
    private final Optional<Integer> priority;
    private final Optional<String> category;
    private final Optional<Interactive> interactive;
    private final Optional<String> title;
    private final Optional<String> subtitle;
    private final Optional<MediaAttachment> mediaAttachment;
    private final Optional<IOSSoundData> sound;
    private final Optional<Boolean> mutableContent;
    private final Optional<String> collapseId;
    private final Optional<String> threadId;
    private final Optional<Actions> actions;
    private final Optional<String> targetContentId;
    private final Optional<IOSTemplate> iosTemplate;
    private final Optional<IOSInterruptionLevel> iosInterruptionLevel;
    private final Optional<Double> relevanceScore;

    private IOSDevicePayload(Optional<IOSAlertData> alert, Optional<IOSBadgeData> badge, Optional<Boolean> contentAvailable, Optional<PushExpiry> expiry, Optional<Integer> priority, Optional<ImmutableMap<String, String>> extra, Optional<String> category, Optional<Interactive> interactive, Optional<String> title, Optional<String> subtitle, Optional<MediaAttachment> mediaAttachment, Optional<IOSSoundData> sound, Optional<Boolean> mutableContent, Optional<String> collapseId, Optional<String> threadId, Optional<Actions> actions, Optional<String> targetContentId, Optional<IOSTemplate> iosTemplate, Optional<IOSInterruptionLevel> iosInterruptionLevel, Optional<Double> relevanceScore) {
        this.alert = alert;
        this.badge = badge;
        this.contentAvailable = contentAvailable;
        this.extra = extra;
        this.expiry = expiry;
        this.priority = priority;
        this.category = category;
        this.interactive = interactive;
        this.title = title;
        this.subtitle = subtitle;
        this.mediaAttachment = mediaAttachment;
        this.sound = sound;
        this.mutableContent = mutableContent;
        this.collapseId = collapseId;
        this.threadId = threadId;
        this.actions = actions;
        this.targetContentId = targetContentId;
        this.iosTemplate = iosTemplate;
        this.iosInterruptionLevel = iosInterruptionLevel;
        this.relevanceScore = relevanceScore;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.IOS;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert.isPresent() ? this.alert.get().getBody() : Optional.empty();
    }

    public Optional<IOSAlertData> getAlertData() {
        return this.alert;
    }

    public Optional<IOSBadgeData> getBadge() {
        return this.badge;
    }

    public Optional<Boolean> getContentAvailable() {
        return this.contentAvailable;
    }

    public Optional<ImmutableMap<String, String>> getExtra() {
        return this.extra;
    }

    public Optional<PushExpiry> getExpiry() {
        return this.expiry;
    }

    public Optional<Integer> getPriority() {
        return this.priority;
    }

    public Optional<String> getCategory() {
        return this.category;
    }

    public Optional<Interactive> getInteractive() {
        return this.interactive;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<String> getSubtitle() {
        return this.subtitle;
    }

    public Optional<Boolean> getMutableContent() {
        return this.mutableContent;
    }

    public Optional<MediaAttachment> getMediaAttachment() {
        return this.mediaAttachment;
    }

    public Optional<IOSSoundData> getSoundData() {
        return this.sound;
    }

    @Deprecated
    public Optional<String> getSound() {
        if (!this.sound.isPresent()) {
            return Optional.empty();
        }
        return this.sound.get().getName();
    }

    public Optional<String> getCollapseId() {
        return this.collapseId;
    }

    public Optional<String> getThreadId() {
        return this.threadId;
    }

    public Optional<Actions> getActions() {
        return this.actions;
    }

    public Optional<String> getTargetContentId() {
        return this.targetContentId;
    }

    public Optional<IOSTemplate> getIosTemplate() {
        return this.iosTemplate;
    }

    public Optional<IOSInterruptionLevel> getIosInterruptionLevel() {
        return this.iosInterruptionLevel;
    }

    public Optional<Double> getRelevanceScore() {
        return this.relevanceScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOSDevicePayload that = (IOSDevicePayload)o;
        return Objects.equals(this.alert, that.alert) && Objects.equals(this.extra, that.extra) && Objects.equals(this.badge, that.badge) && Objects.equals(this.contentAvailable, that.contentAvailable) && Objects.equals(this.expiry, that.expiry) && Objects.equals(this.priority, that.priority) && Objects.equals(this.category, that.category) && Objects.equals(this.interactive, that.interactive) && Objects.equals(this.title, that.title) && Objects.equals(this.subtitle, that.subtitle) && Objects.equals(this.mediaAttachment, that.mediaAttachment) && Objects.equals(this.sound, that.sound) && Objects.equals(this.mutableContent, that.mutableContent) && Objects.equals(this.collapseId, that.collapseId) && Objects.equals(this.threadId, that.threadId) && Objects.equals(this.actions, that.actions) && Objects.equals(this.targetContentId, that.targetContentId) && Objects.equals(this.iosTemplate, that.iosTemplate) && Objects.equals(this.iosInterruptionLevel, that.iosInterruptionLevel) && Objects.equals(this.relevanceScore, that.relevanceScore);
    }

    public int hashCode() {
        return Objects.hash(this.alert, this.extra, this.badge, this.contentAvailable, this.expiry, this.priority, this.category, this.interactive, this.title, this.subtitle, this.mediaAttachment, this.sound, this.mutableContent, this.collapseId, this.threadId, this.actions, this.targetContentId, this.iosTemplate, this.iosInterruptionLevel, this.relevanceScore);
    }

    public String toString() {
        return "IOSDevicePayload{alert=" + this.alert + ", extra=" + this.extra + ", badge=" + this.badge + ", contentAvailable=" + this.contentAvailable + ", expiry=" + this.expiry + ", priority=" + this.priority + ", category=" + this.category + ", interactive=" + this.interactive + ", title=" + this.title + ", subtitle=" + this.subtitle + ", mediaAttachment=" + this.mediaAttachment + ", sound=" + this.sound + ", mutableContent=" + this.mutableContent + ", collapseId=" + this.collapseId + ", threadId=" + this.threadId + ", actions=" + this.actions + ", targetContentId=" + this.targetContentId + ", iosTemplate=" + this.iosTemplate + ", iosInterruptionLevel=" + this.iosInterruptionLevel + ", relevanceScore=" + this.relevanceScore + '}';
    }

    public static class Builder {
        private IOSAlertData alert = null;
        private IOSBadgeData badge = null;
        private Boolean contentAvailable = null;
        private ImmutableMap.Builder<String, String> extra = null;
        private PushExpiry expiry = null;
        private Integer priority = null;
        private String category = null;
        private Interactive interactive = null;
        private String title = null;
        private String subtitle = null;
        private MediaAttachment mediaAttachment = null;
        private IOSSoundData sound = null;
        private Boolean mutableContent = null;
        private String collapseId = null;
        private String threadId = null;
        private Actions actions;
        private String targetContentId;
        private IOSTemplate iosTemplate;
        private IOSInterruptionLevel iosInterruptionLevel;
        private Double relevanceScore;

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alert = IOSAlertData.newBuilder().setBody(alert).build();
            return this;
        }

        public Builder setAlert(IOSAlertData alert) {
            this.alert = alert;
            return this;
        }

        public Builder setBadge(IOSBadgeData badge) {
            this.badge = badge;
            return this;
        }

        public Builder setContentAvailable(boolean value) {
            this.contentAvailable = value;
            return this;
        }

        public Builder setExpiry(PushExpiry value) {
            this.expiry = value;
            return this;
        }

        public Builder setPriority(int value) {
            this.priority = value;
            return this;
        }

        public Builder addExtraEntry(String key, String value) {
            if (this.extra == null) {
                this.extra = ImmutableMap.builder();
            }
            this.extra.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllExtraEntries(Map<String, String> entries) {
            if (this.extra == null) {
                this.extra = ImmutableMap.builder();
            }
            this.extra.putAll(entries);
            return this;
        }

        public Builder setCategory(String value) {
            this.category = value;
            return this;
        }

        public Builder setInteractive(Interactive value) {
            this.interactive = value;
            return this;
        }

        public Builder setTitle(String value) {
            this.title = value;
            return this;
        }

        public Builder setSubtitle(String value) {
            this.subtitle = value;
            return this;
        }

        public Builder setMediaAttachment(MediaAttachment value) {
            this.mediaAttachment = value;
            return this;
        }

        public Builder setSoundData(IOSSoundData value) {
            this.sound = value;
            return this;
        }

        @Deprecated
        public Builder setSound(String name) {
            this.sound = IOSSoundData.newBuilder().setName(name).build();
            return this;
        }

        public Builder setMutableContent(Boolean value) {
            this.mutableContent = value;
            return this;
        }

        public Builder setCollapseId(String value) {
            this.collapseId = value;
            return this;
        }

        public Builder setThreadId(String value) {
            this.threadId = value;
            return this;
        }

        public Builder setActions(Actions actions) {
            this.actions = actions;
            return this;
        }

        public Builder setTargetContentId(String targetContentId) {
            this.targetContentId = targetContentId;
            return this;
        }

        public Builder setIosTemplate(IOSTemplate iosTemplate) {
            this.iosTemplate = iosTemplate;
            return this;
        }

        public Builder setIosInterruptionLevel(IOSInterruptionLevel iosInterruptionLevel) {
            this.iosInterruptionLevel = iosInterruptionLevel;
            return this;
        }

        public Builder setRelevanceScore(Double relevanceScore) {
            Preconditions.checkArgument((relevanceScore >= 0.0 && relevanceScore <= 1.0 ? 1 : 0) != 0, (Object)"Relevance score must be a number between 0.0 and 1.0.");
            this.relevanceScore = relevanceScore;
            return this;
        }

        public IOSDevicePayload build() {
            return new IOSDevicePayload(Optional.ofNullable(this.alert), Optional.ofNullable(this.badge), Optional.ofNullable(this.contentAvailable), Optional.ofNullable(this.expiry), Optional.ofNullable(this.priority), this.extra == null ? Optional.empty() : Optional.ofNullable(this.extra.build()), Optional.ofNullable(this.category), Optional.ofNullable(this.interactive), Optional.ofNullable(this.title), Optional.ofNullable(this.subtitle), Optional.ofNullable(this.mediaAttachment), Optional.ofNullable(this.sound), Optional.ofNullable(this.mutableContent), Optional.ofNullable(this.collapseId), Optional.ofNullable(this.threadId), Optional.ofNullable(this.actions), Optional.ofNullable(this.targetContentId), Optional.ofNullable(this.iosTemplate), Optional.ofNullable(this.iosInterruptionLevel), Optional.ofNullable(this.relevanceScore));
        }
    }
}

